/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.bims.service.impl;

import com.xdja.pams.bims.bean.ImpPersonExcelBean;
import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.bean.PersonExtraColumnBean;
import com.xdja.pams.bims.bean.PersonTerminal;
import com.xdja.pams.bims.bean.QueryDeviceBean;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.bean.QueryPersonExcelBean;
import com.xdja.pams.bims.bean.TreePerson;
import com.xdja.pams.bims.dao.BimsGroupDao;
import com.xdja.pams.bims.dao.MobileDao;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.dao.PersonExtraDao;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.GroupMemberSyn;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonExcel;
import com.xdja.pams.bims.entity.PersonExtra;
import com.xdja.pams.bims.entity.PersonUpdated;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.service.impl.UserManageServiceImpl;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.commonException.WorkflowException;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.PinYin4j;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.entity.WorkFlowControlDept;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.sso.bean.SynQueryParam;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syn.entity.MDPAndPolice;
import com.xdja.pams.syn.service.PersonMDPService;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import com.xdja.pams.wfms.service.WorkflowUserSynService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.bims.bean.PersonDepBean;
import pams.function.xatl.bims.service.UserManageServiceForXatl;

@Service
public class UserManageServiceImplForXatl
implements UserManageServiceForXatl {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonDao personDao;
    @Autowired
    private MobileDao mobileDao;
    @Autowired
    private WorkflowUserSynService workflowUserSynService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private DepManageService depService;
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private DevicePbService devicePbService;
    private static final Logger log = LoggerFactory.getLogger(UserManageServiceImpl.class);
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private BimsGroupDao groupDao;
    @Autowired
    private TerminalReportService terminalReportService;
    @Autowired
    private PersonMDPService personMDPService;
    @Autowired
    private PersonExtraDao personExtraDao;
    private static final String ALL_STR = "all";
    private static final String TRUE_STR = "true";
    private static final String COMMA = ",";

    private Person getPerson(QueryPersonBean personBean) {
        Role role;
        Person person = new Person();
        person.setName(personBean.getName());
        person.setCode(personBean.getCode());
        person.setIdentifier(personBean.getIdentifier());
        person.setSex(personBean.getSex());
        person.setPosition(personBean.getPosition());
        person.setPolice(personBean.getPolice());
        person.setOfficePhone(personBean.getOfficePhone());
        person.setMobileMultimediaMessage(personBean.getMobileMultimediaMessage());
        person.setMobilePersonal(personBean.getMobilePersonal());
        ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        if (personBean.getMobile() != null) {
            String[] mobiles;
            for (String strMobile : mobiles = personBean.getMobile().split(COMMA)) {
                Mobile mobile = new Mobile();
                mobile.setMobile(strMobile);
                mobileList.add(mobile);
            }
            person.setMobiledList(mobileList);
        }
        person.setMobile(personBean.getMobile());
        person.setOrderField(personBean.getOrderField());
        person.setDepartment(this.depService.queryDepById(personBean.getDepId()));
        person.setPersonState(personBean.getPersonState());
        person.setDisplayState(personBean.getDisplayState());
        person.setLeaderLevel(personBean.getLeaderLevel());
        person.setPersonType(personBean.getPersonType());
        person.setCommType(personBean.getCommType());
        person.setDepCode(person.getDepartment().getCode());
        if (personBean.getGroupIds() != null) {
            String[] groupIdsArray = personBean.getGroupIds().split(COMMA);
            ArrayList<BimsGroup> list = new ArrayList<BimsGroup>();
            for (String id : groupIdsArray) {
                BimsGroup group = this.groupManageService.queryGroupByID(id);
                list.add(group);
            }
            person.setGroupList(list);
        }
        ArrayList<Role> roleList = new ArrayList<Role>();
        String isSetSysRole = this.systemConfigPbService.getValueByCode("isSetSysRole");
        if ("0".equals(isSetSysRole)) {
            roleList.addAll(this.sysRoleService.queryDefaultRoleList());
        }
        if (personBean.getRoleIds() != null) {
            String[] roleIdsArray;
            for (String id : roleIdsArray = personBean.getRoleIds().split(COMMA)) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        if (personBean.getTerminalRoleIds() != null) {
            String[] roleIdsArray;
            for (String id : roleIdsArray = personBean.getTerminalRoleIds().split(COMMA)) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        person.setRoleList(roleList);
        person.setCreatorId(personBean.getCreatorId());
        person.setLastChangePwDate(new Date());
        return person;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(QueryPersonBean personBean, QueryDeviceBean device) {
        String cardcount = this.systemConfigPbService.getValueByCode("cardcount");
        String cardTypes = this.systemConfigPbService.getValueByCode("addPersonDevice");
        ArrayList<String> cardTypeList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)cardTypes)) {
            String[] tmpArr;
            for (String type : tmpArr = cardTypes.split(COMMA)) {
                if (!"1".equals(type) && !"3".equals(type) && !"2".equals(type) && !"4".equals(type)) continue;
                cardTypeList.add(type);
            }
        }
        Person p = this.getPerson(personBean);
        if (device != null) {
            if ("one".equals(cardcount)) {
                this.addUserAndDevice(p, device);
            } else if (cardTypeList.size() > 0) {
                this.addUserAndDevice(p, cardTypeList, device);
            } else {
                this.addUser(p);
            }
        } else {
            this.addUser(p);
        }
        this.saveControlDeptList2(p, personBean.getDepId());
        this.saveOrUpdatePersonExtra(p.getId(), personBean.getPersonExtraColumns());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addUser(Person person) {
        if (person.getIdentifier() != null) {
            person.setIdentifier(person.getIdentifier().toUpperCase());
        }
        person.setPassword(Md5PwdEncoder.getInstance().encodePassword(this.systemConfigPbService.getValueByCode("defaultPass")));
        person.setLockState("0");
        person.setFlag("0");
        if (StringUtils.isBlank((CharSequence)(person.getOrderField() + ""))) {
            person.setOrderField(999L);
        }
        person.setGrade(BimsUtil.checkLevel((String)person.getGrade(), (String)person.getDepartment().getCode()) + "");
        person.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone((String)person.getName()));
        String personId = this.personDao.addPerson(person);
        UserEntity user = new UserEntity();
        user.setId(personId);
        user.setFirstName(person.getName());
        this.workflowUserSynService.saveUser((User)user);
        return personId;
    }

    private Terminal getDefaultTerminal() {
        List list = this.commonCodeService.queryByType("2021");
        String terminalBand = list != null && list.size() > 0 ? ((CommonCode)list.get(0)).getCode() : "";
        list = this.commonCodeService.queryByType("2022");
        String terminalOs = list != null && list.size() > 0 ? ((CommonCode)list.get(0)).getCode() : "";
        list = this.commonCodeService.queryByType("2020");
        String terminalType = list != null && list.size() > 0 ? ((CommonCode)list.get(0)).getCode() : "";
        list = this.commonCodeService.queryByType("terminalName");
        String terminalName = list != null && list.size() > 0 ? ((CommonCode)list.get(0)).getCode() : "";
        Terminal terminal = new Terminal();
        terminal.setTerminalband(terminalBand);
        terminal.setTerminalos(terminalOs);
        terminal.setTerminaltype(terminalType);
        terminal.setTerminalname(terminalName);
        return terminal;
    }

    public String addUserAndDevice(Person person, List<String> cardTypes, QueryDeviceBean device) {
        List codes;
        String personId = this.addUser(person);
        Mobile mobile = this.getMobile(person.getMobile().split(COMMA)[0]);
        if (null != device && StringUtils.isNotBlank((CharSequence)device.getType())) {
            boolean include = false;
            for (String cardType : cardTypes) {
                if (!cardType.equals(device.getType())) continue;
                include = true;
            }
            if (!include) {
                cardTypes.add(device.getType());
            }
        }
        String useType = (codes = this.commonCodeService.queryByType("useType")) != null && codes.size() > 0 ? ((CommonCode)codes.get(0)).getCode() : "";
        ArrayList<Device> devices = new ArrayList<Device>();
        for (String cardType : cardTypes) {
            Device newDevice = new Device();
            if (null != device && StringUtils.isNotBlank((CharSequence)device.getType())) {
                newDevice.setPersonId(personId);
                newDevice.setType(cardType);
                Terminal terminal = new Terminal();
                terminal.setTerminalband(device.getTerminalBrand());
                terminal.setTerminalname(device.getTerminalName());
                terminal.setTerminalos(device.getTerminalOs());
                terminal.setTerminaltype(device.getTerminalType());
                newDevice.setTerminal(terminal);
                newDevice.setMobile(mobile);
                newDevice.setBindingState(this.getBingDingState(cardType));
                newDevice.setBindingDate(new Date());
                newDevice.setLockState("0");
                newDevice.setFlag("1");
                newDevice.setName(device.getCardName());
                newDevice.setCommType(device.getCommType());
                newDevice.setUseType(device.getUseType());
                if ("2".equals(cardType)) {
                    newDevice.setUseType("1");
                }
                devices.add(newDevice);
                continue;
            }
            String commType = device.getCommType();
            if (StringUtils.isBlank((CharSequence)commType)) {
                List list = this.commonCodeService.queryByType("2015");
                commType = list != null && list.size() > 0 ? ((CommonCode)list.get(0)).getCode() : "";
            }
            newDevice.setCommType(commType);
            newDevice.setFlag("1");
            newDevice.setLockState("0");
            newDevice.setMobile(mobile);
            newDevice.setPersonId(personId);
            newDevice.setBindingState(this.getBingDingState(cardType));
            newDevice.setBindingDate(new Date());
            Terminal terminal = this.getDefaultTerminal();
            newDevice.setTerminal(terminal);
            newDevice.setType(cardType);
            newDevice.setUseType(useType);
            if ("2".equals(cardType)) {
                newDevice.setUseType("1");
            }
            devices.add(newDevice);
        }
        this.devicePbService.save(devices, person);
        return personId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addUserAndDevice(Person person, QueryDeviceBean device) {
        String personId = this.addUser(person);
        Device device2 = new Device();
        device2.setPersonId(personId);
        device2.setType(device.getType());
        Terminal terminal = new Terminal();
        terminal.setTerminalband(device.getTerminalBrand());
        terminal.setTerminalname(device.getTerminalName());
        terminal.setTerminalos(device.getTerminalOs());
        terminal.setTerminaltype(device.getTerminalType());
        device2.setTerminal(terminal);
        if (person.getMobile() != null) {
            Mobile mobile = this.getMobile(person.getMobile().split(COMMA)[0]);
            device2.setMobile(mobile);
        }
        device2.setBindingState(this.getBingDingState(device.getType()));
        device2.setBindingDate(new Date());
        device2.setLockState("0");
        device2.setFlag("1");
        device2.setName(device.getCardName());
        device2.setCommType(device.getCommType());
        device2.setUseType(device.getUseType());
        if ("2".equals(device.getType())) {
            device2.setUseType("1");
        }
        this.devicePbService.save(device2, person);
        return personId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUser(Person person) {
        if (person.getIdentifier() != null) {
            person.setIdentifier(person.getIdentifier().toUpperCase());
        }
        person.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone((String)person.getName()));
        person.setTimestamp(System.currentTimeMillis());
        this.personDao.updatePerson(person);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserNotUpdateLastupdatetime(Person person) {
        if (person.getIdentifier() != null) {
            person.setIdentifier(person.getIdentifier().toUpperCase());
        }
        person.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone((String)person.getName()));
        this.personDao.updatePerson(person);
    }

    @Override
    public List<PersonUpdated> queryEditHistoryById(String id) {
        Person person = this.personDao.queryPersonById(id);
        return person.getPersonUpdatedList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deletePersonById(String id) {
        Person person = this.personDao.queryPersonById(id);
        person.setFlag("1");
        person.setTimestamp(System.currentTimeMillis());
        person.setMobiledList(null);
        person.setGroupList(null);
        person.setRoleList(null);
        person.setControlDepdList(null);
        person.setControlPolicedList(null);
        this.depService.deleteWorkFlowControlDept(id);
        this.personDao.updatePerson(person);
        UserEntity user = new UserEntity();
        user.setId(person.getId());
        user.setFirstName(person.getName());
        this.workflowUserSynService.deleteUser((User)user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        this.deletePersonById(id);
        this.devicePbService.deleteDeviceWorkflow(id);
        this.deleteDeviceByPersonId(id);
        this.deleteNoPersonMobile();
        this.fjmsNotice(id, "0");
    }

    @Override
    public Person queryPersonById(String id) {
        return this.personDao.queryPersonById(id);
    }

    @Override
    public List<Person> queryPersonListByNameOrCode(String nameOrCode, String controlDepIds, String controlPolices, Page page) {
        StringBuilder selectHql = new StringBuilder("select  * from t_person  person where 1=1 ");
        StringBuilder countHql = new StringBuilder("select  count(*) from t_person  person where 1=1");
        ArrayList<String> paramList = new ArrayList<String>();
        selectHql.append("and person.flag = ? ");
        countHql.append("and person.flag = ? ");
        paramList.add("0");
        if (StringUtils.isNotBlank((CharSequence)nameOrCode)) {
            selectHql.append("and (person.code like ?  or person.name like ? ) ");
            countHql.append("and (person.code like ?  or person.name like ? )  ");
            paramList.add("%" + StringUtils.trim((String)nameOrCode) + "%");
            paramList.add("%" + StringUtils.trim((String)nameOrCode) + "%");
        }
        selectHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")");
        countHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")");
        if (!ALL_STR.equals(controlPolices)) {
            selectHql.append("and person.police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ")");
            countHql.append("and person.police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ")");
        }
        selectHql.append(" order by order_field,code asc ");
        return this.personDao.queryPersonListBySql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    public List<Person> queryPersonList(QueryPersonBean queryBean, String controlDepIds, String controlPolices, Page page) {
        StringBuilder selectHql = new StringBuilder("select distinct person.* from t_person person left join t_bims_mobile m  on  person.id=m.person_id where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(distinct person.id) from t_person person left join t_bims_mobile m  on  person.id=m.person_id where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        selectHql.append("and person.flag = ? ");
        countHql.append("and person.flag = ? ");
        paramList.add("0");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCode())) {
            selectHql.append("and person.code like ? ");
            countHql.append("and person.code like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getCode()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPersonType())) {
            selectHql.append("and person.PERSON_TYPE like ? ");
            countHql.append("and person.PERSON_TYPE like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getPersonType()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getNameOrCode())) {
            selectHql.append("and (person.code like ?  or person.name like ? ) ");
            countHql.append("and (person.code like ?  or person.name like ? )  ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getNameOrCode()) + "%");
            paramList.add("%" + StringUtils.trim((String)queryBean.getNameOrCode()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getIdentifier())) {
            selectHql.append("and person.identifier like ? ");
            countHql.append("and person.identifier like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getIdentifier()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and person.name like ? ");
            countHql.append("and person.name like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getMobile())) {
            selectHql.append("and m.mobile like ? ");
            countHql.append("and m.mobile like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getMobile()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPosition())) {
            selectHql.append("and person.position = ? ");
            countHql.append("and person.position = ? ");
            paramList.add(StringUtils.trim((String)queryBean.getPosition()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPolice())) {
            selectHql.append("and person.police = ? ");
            countHql.append("and person.police = ? ");
            paramList.add(StringUtils.trim((String)queryBean.getPolice()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getLockState())) {
            selectHql.append("and person.CLIENT_LOCK_STATE = ? ");
            countHql.append("and person.CLIENT_LOCK_STATE = ? ");
            paramList.add(queryBean.getLockState());
        }
        if (null != queryBean.getClientLoginTime()) {
            selectHql.append("and person.login_time is not Null ");
            countHql.append("and person.login_time is not Null ");
        }
        if (queryBean.getIsContain() != null && queryBean.getIsContain().contains(TRUE_STR)) {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepName())) {
                selectHql.append("and person.dep_Id in (" + BimsUtil.getAllDepIdByName() + ")");
                countHql.append("and person.dep_Id in (" + BimsUtil.getAllDepIdByName() + ")");
                paramList.add("%" + queryBean.getDepName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
                selectHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
                countHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
                paramList.add(queryBean.getDepId());
            } else {
                selectHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")");
                countHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")");
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepName())) {
                selectHql.append("and person.dep_Id in (" + BimsUtil.getDepIdByName() + ")");
                countHql.append("and person.dep_Id in (" + BimsUtil.getDepIdByName() + ")");
                paramList.add("%" + StringUtils.trim((String)queryBean.getDepName()) + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
                selectHql.append("and person.dep_Id = ? ");
                countHql.append("and person.dep_Id = ? ");
                paramList.add(queryBean.getDepId());
            } else {
                selectHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")");
                countHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")");
            }
        }
        if (!ALL_STR.equals(controlPolices)) {
            selectHql.append("and person.police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ")");
            countHql.append("and person.police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ")");
        }
        selectHql.append(" order by order_field,code asc ");
        return this.personDao.queryPersonListBySql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    public Person getUserByCode(String code) {
        Person p = null;
        String selectHql = "from Person as person where person.code=? and person.flag=?";
        String[] values = new String[]{code, "0"};
        p = this.personDao.queryPersonByHql(selectHql, values);
        return p;
    }

    @Override
    public List<Person> queryUserListByIdentifier(List<String> list) {
        String queryIdentifiers = Util.listToString(list);
        if (StringUtils.isNotBlank((CharSequence)queryIdentifiers)) {
            String selectHql = "select * from T_PERSON p where p.identifier in (" + queryIdentifiers.toUpperCase() + ") and p.flag='" + "0" + "'";
            return this.personDao.queryPersonListBySql(null, selectHql, null, null);
        }
        return null;
    }

    @Override
    public List<Person> queryUserListByCode(List<String> list) {
        String queryCodes = Util.listToString(list);
        if (StringUtils.isNotBlank((CharSequence)queryCodes)) {
            String selectHql = "select * from T_PERSON p where p.code in (" + queryCodes.toUpperCase() + ") and p.flag='" + "0" + "'";
            return this.personDao.queryPersonListBySql(null, selectHql, null, null);
        }
        return null;
    }

    @Override
    public List<Person> queryUserListByMobile(List<String> mobileList) {
        String queryMobiles = Util.listToString(mobileList);
        if (StringUtils.isNotBlank((CharSequence)queryMobiles)) {
            String selectHql = "select * from T_PERSON p where p.mobile in (" + queryMobiles.toUpperCase() + ")";
            return this.personDao.queryPersonListBySql(null, selectHql, null, null);
        }
        return null;
    }

    public List<Mobile> queryMobileListByMobile(List<String> mobileList) {
        String queryMobiles = Util.listToString(mobileList);
        if (StringUtils.isNotBlank((CharSequence)queryMobiles)) {
            String sql = "select * from T_BIMS_MOBILE p where p.mobile in (" + queryMobiles.toUpperCase() + ")";
            return this.mobileDao.queryMobileListBySql(sql, null);
        }
        return null;
    }

    @Override
    public Person getUserByMobile(String mobile) {
        Person p = null;
        String selectHql = "from Mobile as mobile where mobile.mobile=?";
        String[] values = new String[]{mobile};
        Mobile moblie = this.mobileDao.queryMobileByHql(selectHql, values);
        if (moblie != null) {
            p = moblie.getPerson();
        }
        return p;
    }

    @Override
    public Person getUserByIdentifer(String identifier) {
        Person p = this.personDao.getUserByIdentifer(identifier);
        return p;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePersonForEdit(QueryPersonBean personBean, QueryDeviceBean queryDeviceBean, String editorId) {
        Role role;
        Person oldInfo = this.personDao.queryPersonById(personBean.getId());
        PersonUpdated personUpdated = new PersonUpdated();
        personUpdated.setCode(oldInfo.getCode());
        personUpdated.setName(oldInfo.getName());
        personUpdated.setIdentifier(oldInfo.getIdentifier());
        personUpdated.setDepName(oldInfo.getDepartment().getName());
        personUpdated.setDepCode(oldInfo.getDepartment().getCode());
        personUpdated.setDepartmnetId(oldInfo.getDepartment().getId());
        personUpdated.setEditorId(editorId);
        personUpdated.setMobile(oldInfo.getMobile());
        personUpdated.setOrderField(oldInfo.getOrderField());
        personUpdated.setPersonId(oldInfo.getId());
        personUpdated.setPosition(oldInfo.getPosition());
        personUpdated.setSex(oldInfo.getSex());
        personUpdated.setPersonType(oldInfo.getPersonType());
        personUpdated.setMobileMultimediaMessage(oldInfo.getMobileMultimediaMessage());
        personUpdated.setMobilePersonal(oldInfo.getMobilePersonal());
        oldInfo.getPersonUpdatedList().add(personUpdated);
        oldInfo.setName(personBean.getName());
        oldInfo.setCode(personBean.getCode());
        oldInfo.setIdentifier(personBean.getIdentifier());
        oldInfo.setSex(personBean.getSex());
        oldInfo.setPosition(personBean.getPosition());
        oldInfo.setPolice(personBean.getPolice());
        oldInfo.setOfficePhone(personBean.getOfficePhone());
        oldInfo.setMobile(personBean.getMobile());
        oldInfo.setMobiledList(personBean.getMobiledList());
        oldInfo.setOrderField(personBean.getOrderField());
        oldInfo.setDepartment(this.depService.queryDepById(personBean.getDepId()));
        oldInfo.setPersonState(personBean.getPersonState());
        oldInfo.setDisplayState(personBean.getDisplayState());
        oldInfo.setLeaderLevel(personBean.getLeaderLevel());
        oldInfo.setPersonType(personBean.getPersonType());
        oldInfo.setMobileMultimediaMessage(personBean.getMobileMultimediaMessage());
        oldInfo.setMobilePersonal(personBean.getMobilePersonal());
        oldInfo.setDepCode(oldInfo.getDepartment().getCode());
        oldInfo.setTimestamp(System.currentTimeMillis());
        oldInfo.setNameBriefSpell(PinYin4j.getNameSimplicityWithPolyphone((String)oldInfo.getName()));
        oldInfo.setCommType(personBean.getCommType());
        ArrayList<BimsGroup> groupList = null;
        String[] groupIdsArray = null;
        if (!Util.varCheckEmp((String)personBean.getGroupIds())) {
            groupIdsArray = personBean.getGroupIds().split(COMMA);
            groupList = new ArrayList<BimsGroup>();
            for (String id : groupIdsArray) {
                BimsGroup group = this.groupManageService.queryGroupByID(id);
                groupList.add(group);
            }
        }
        this.synGroupMember(oldInfo, groupIdsArray);
        oldInfo.setGroupList(groupList);
        ArrayList<Role> roleList = new ArrayList<Role>();
        String isSetSysRole = this.systemConfigPbService.getValueByCode("isSetSysRole");
        if ("0".equals(isSetSysRole)) {
            roleList.addAll(this.sysRoleService.queryDefaultRoleList());
        }
        if (personBean.getRoleIds() != null) {
            String[] roleIdsArray;
            for (String id : roleIdsArray = personBean.getRoleIds().split(COMMA)) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        if (personBean.getTerminalRoleIds() != null) {
            String[] roleIdsArray;
            for (String id : roleIdsArray = personBean.getTerminalRoleIds().split(COMMA)) {
                role = this.sysRoleService.queryRoleById(id);
                roleList.add(role);
            }
        }
        oldInfo.setRoleList(roleList);
        this.personDao.updatePerson(oldInfo);
        if (personUpdated.getDepartmnetId() != null && !personUpdated.getDepartmnetId().equals(personBean.getDepId())) {
            this.saveControlDeptList2(oldInfo, personBean.getDepId());
        }
        if (!oldInfo.getName().equals(personUpdated.getName())) {
            UserEntity user = new UserEntity();
            user.setId(oldInfo.getId());
            user.setFirstName(oldInfo.getName());
            this.workflowUserSynService.updateUser((User)user);
        }
        if (!personBean.getDepId().equals(personUpdated.getDepartmnetId())) {
            this.fjmsNotice(personBean.getId(), "1");
        }
        this.saveOrUpdatePersonExtra(personBean.getId(), personBean.getPersonExtraColumns());
    }

    @Transactional(rollbackFor={Exception.class})
    void synGroupMember(Person oldInfo, String[] newGroupIdsArray) {
        boolean flag;
        boolean isNullOfNewAndOldGroup;
        ArrayList<GroupMemberSyn> groupMemberSynList = new ArrayList<GroupMemberSyn>();
        String personId = oldInfo.getId();
        List groupList = oldInfo.getGroupList();
        boolean bl = isNullOfNewAndOldGroup = !(groupList != null && groupList.size() != 0 || newGroupIdsArray != null && newGroupIdsArray.length != 0);
        if (isNullOfNewAndOldGroup) {
            return;
        }
        if (groupList != null && groupList.size() > 0) {
            for (BimsGroup group : groupList) {
                flag = false;
                if (newGroupIdsArray != null && newGroupIdsArray.length > 0) {
                    for (String groupId : newGroupIdsArray) {
                        if (!group.getId().equals(groupId)) {
                            flag = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    flag = true;
                }
                if (!flag) continue;
                GroupMemberSyn groupMemberSyn = new GroupMemberSyn();
                groupMemberSyn.setGroupId(group.getId());
                groupMemberSyn.setPersonId(personId);
                groupMemberSyn.setType("2");
                groupMemberSynList.add(groupMemberSyn);
            }
        }
        if (newGroupIdsArray != null && newGroupIdsArray.length > 0) {
            for (String groupId : newGroupIdsArray) {
                flag = false;
                if (groupList != null && groupList.size() > 0) {
                    BimsGroup group;
                    Iterator i$ = groupList.iterator();
                    while (i$.hasNext() && !(group = (BimsGroup)i$.next()).getId().equals(groupId)) {
                        flag = true;
                    }
                } else {
                    flag = true;
                }
                if (!flag) continue;
                GroupMemberSyn groupMemberSyn = new GroupMemberSyn();
                groupMemberSyn.setGroupId(groupId);
                groupMemberSyn.setPersonId(personId);
                groupMemberSyn.setType("1");
                groupMemberSynList.add(groupMemberSyn);
            }
        }
        this.groupDao.addGroupMemberSyn(groupMemberSynList);
    }

    @Override
    public List<PersonExcel> queryPersonExcelList(QueryPersonExcelBean queryBean, String controlDepIds, Page page) {
        StringBuilder selectHql = new StringBuilder("select * from t_person person where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from t_person person where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCode())) {
            selectHql.append("and person.code like ? ");
            countHql.append("and person.code like ? ");
            paramList.add("%" + queryBean.getCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getIdentifier())) {
            selectHql.append("and person.identifier like ? ");
            countHql.append("and person.identifier like ? ");
            paramList.add("%" + queryBean.getIdentifier() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and person.name like ? ");
            countHql.append("and person.name like ? ");
            paramList.add("%" + queryBean.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getMobile())) {
            selectHql.append("and person.mobile like ? ");
            countHql.append("and person.mobile like ? ");
            paramList.add("%" + queryBean.getMobile() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPosition())) {
            selectHql.append("and person.position = ? ");
            countHql.append("and person.position = ? ");
            paramList.add(queryBean.getPosition());
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPolice())) {
            selectHql.append("and person.police = ? ");
            countHql.append("and person.police = ? ");
            paramList.add(queryBean.getPolice());
        }
        if (null != queryBean.getClientLoginTime()) {
            selectHql.append("and person.login_time is not Null ");
            countHql.append("and person.login_time is not Null ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
            selectHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            countHql.append("and person.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
            paramList.add(queryBean.getDepId());
        }
        selectHql.append(" order by order_field,code asc ");
        return this.personDao.queryPersonExcelListBySql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importPerson(MultipartFile file, Set<ImpPersonExcelBean> wellList, List<ImpPersonExcelBean> exitList, List<ImpPersonExcelBean> infoNotExitList, List<ImpPersonExcelBean> errorList, Map totalCount, String createPersonId, HttpServletRequest request) throws Exception {
        request.getSession().setAttribute("uploadUserCount", (Object)"0");
        log.info("parseExcel....................");
        ArrayList<ImpPersonExcelBean> allList = new ArrayList<ImpPersonExcelBean>();
        this.parseExcel(file, allList);
        totalCount.put("totalCount", allList.size());
        HashSet<ImpPersonExcelBean> oldSet = new HashSet();
        HashSet<ImpPersonExcelBean> newSet = new HashSet<ImpPersonExcelBean>();
        HashMap<String, String> identiferMap = new HashMap<String, String>(8);
        HashMap<String, String> codeMap = new HashMap<String, String>(8);
        HashMap<String, String> mobileMap = new HashMap<String, String>(8);
        boolean isOne = "one".equals(this.systemConfigPbService.getValueByCode("cardcount"));
        log.info("checkSelf....................");
        this.checkSelf(allList, identiferMap, codeMap, mobileMap, newSet, infoNotExitList, exitList, errorList, isOne);
        oldSet = newSet;
        String[] errorMsg = new String[]{MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.codeExist"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.phoneExist"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.identiferExist")};
        log.info("dbCheck....................");
        Map<String, String> tmpExitMap = this.dbCheck(identiferMap, codeMap, mobileMap);
        log.info("saveExcel....................");
        this.saveExcel(oldSet, tmpExitMap, errorMsg, wellList, exitList, errorList, createPersonId, request);
    }

    private void parseExcel(MultipartFile file, List<ImpPersonExcelBean> allList) throws Exception {
        if (file == null) {
            throw new Exception(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.parseExcel.notFile"));
        }
        String[] colsName = new String[]{MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.code"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.name"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.sex"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.identifer"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.dep.page.info.depcode"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.police"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.position"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.mobile"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.cardtype"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.terminaltype"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.terminalbrand"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.terminalname"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.terminalos"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.commtype"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.devicename"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"device.apply.page.info.index.useType"), MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.page.info.personType")};
        Sheet sheet = ExcelUtil.parseExcel((MultipartFile)file, (int)0);
        if (sheet != null) {
            int i;
            int colLens = sheet.getRow(0).getPhysicalNumberOfCells();
            if (colLens != colsName.length) {
                throw new Exception(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.parseExcel.colNotMatch"));
            }
            for (i = 0; i < colLens; ++i) {
                String cloumnName = sheet.getRow(0).getCell(i).getStringCellValue();
                if (colsName[i].equals(cloumnName)) continue;
                throw new Exception(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.parseExcel.badColName") + "[" + cloumnName + ":" + colsName[i] + "]");
            }
            for (i = 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                ImpPersonExcelBean excel = new ImpPersonExcelBean();
                Row row = sheet.getRow(i);
                for (int j = 0; j < colLens; ++j) {
                    if (row.getCell(j) == null) continue;
                    row.getCell(j).setCellType(1);
                }
                if (row.getCell(0) != null) {
                    excel.setCode(Util.lrTrim((String)row.getCell(0).getStringCellValue()));
                }
                if (row.getCell(1) != null) {
                    excel.setName(Util.lrTrim((String)row.getCell(1).getStringCellValue()));
                }
                if (row.getCell(2) != null) {
                    excel.setSex(Util.lrTrim((String)row.getCell(2).getStringCellValue()));
                }
                if (row.getCell(3) != null) {
                    excel.setIdentifier(Util.lrTrim((String)row.getCell(3).getStringCellValue()));
                }
                if (row.getCell(4) != null) {
                    excel.setI_dep_code(Util.lrTrim((String)row.getCell(4).getStringCellValue()));
                }
                if (row.getCell(5) != null) {
                    excel.setPolice(Util.lrTrim((String)row.getCell(5).getStringCellValue()));
                }
                if (row.getCell(6) != null) {
                    excel.setPosition(Util.lrTrim((String)row.getCell(6).getStringCellValue()));
                }
                if (row.getCell(7) != null) {
                    excel.setI_mobile(Util.lrTrim((String)row.getCell(7).getStringCellValue()));
                }
                excel.setPersonType(Util.lrTrim((String)(row.getCell(16) == null ? "1" : row.getCell(16).getStringCellValue())));
                if (row.getCell(8) != null) {
                    excel.setDeviceType(Util.lrTrim((String)row.getCell(8).getStringCellValue()));
                }
                if (row.getCell(9) != null) {
                    excel.setTerminalType(Util.lrTrim((String)row.getCell(9).getStringCellValue()));
                }
                if (row.getCell(10) != null) {
                    excel.setTerminalBrand(Util.lrTrim((String)row.getCell(10).getStringCellValue()));
                }
                if (row.getCell(11) != null) {
                    excel.setTerminalName(Util.lrTrim((String)row.getCell(11).getStringCellValue()));
                }
                if (row.getCell(12) != null) {
                    excel.setTerminalOs(Util.lrTrim((String)row.getCell(12).getStringCellValue()));
                }
                if (row.getCell(13) != null) {
                    excel.setCommType(Util.lrTrim((String)row.getCell(13).getStringCellValue()));
                }
                if (row.getCell(14) != null) {
                    excel.setCardName(Util.lrTrim((String)row.getCell(14).getStringCellValue()));
                }
                if (row.getCell(15) != null) {
                    excel.setUseType(Util.lrTrim((String)row.getCell(15).getStringCellValue()));
                }
                allList.add(excel);
            }
        }
    }

    private void checkSelf(List<ImpPersonExcelBean> allList, Map<String, String> identiferMap, Map<String, String> codeMap, Map<String, String> mobileMap, Set<ImpPersonExcelBean> newSet, List<ImpPersonExcelBean> infoNotExitList, List<ImpPersonExcelBean> exitList, List<ImpPersonExcelBean> errorList, boolean isOne) {
        HashMap<String, String> sexMap = new HashMap<String, String>(8);
        HashMap<String, String> policeMap = new HashMap<String, String>(8);
        HashMap<String, String> positionMap = new HashMap<String, String>(8);
        HashMap<String, String> deviceTypeMap = new HashMap<String, String>(8);
        HashMap<String, String> terminalTypeMap = new HashMap<String, String>(8);
        HashMap<String, String> terminalBrandMap = new HashMap<String, String>(8);
        HashMap<String, String> terminalOSMap = new HashMap<String, String>(8);
        HashMap<String, String> commTypeMap = new HashMap<String, String>(8);
        HashMap<String, String> personTypeMap = new HashMap<String, String>(8);
        List codeList = this.commonCodePbService.queryByType("sex");
        for (CommonCode tmp : codeList) {
            sexMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2012");
        for (CommonCode tmp : codeList) {
            policeMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2011");
        for (CommonCode tmp : codeList) {
            positionMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2000");
        for (CommonCode tmp : codeList) {
            deviceTypeMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2020");
        for (CommonCode tmp : codeList) {
            terminalTypeMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2021");
        for (CommonCode tmp : codeList) {
            terminalBrandMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2022");
        for (CommonCode tmp : codeList) {
            terminalOSMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("2015");
        for (CommonCode tmp : codeList) {
            commTypeMap.put(tmp.getCode(), tmp.getName());
        }
        codeList = this.commonCodePbService.queryByType("PERSON_TYPE");
        for (CommonCode tmp : codeList) {
            personTypeMap.put(tmp.getCode(), tmp.getName());
        }
        for (ImpPersonExcelBean excelItem : allList) {
            if (!sexMap.containsKey(excelItem.getSex())) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.sexCode"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (!policeMap.containsKey(excelItem.getPolice())) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.policeCode"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (!positionMap.containsKey(excelItem.getPosition())) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.positonCode"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)excelItem.getPersonType())) {
                excelItem.setPersonType("1");
            } else if (!personTypeMap.containsKey(excelItem.getPersonType())) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.personType"));
                infoNotExitList.add(excelItem);
                continue;
            }
            String code = excelItem.getCode();
            if (StringUtils.isBlank((CharSequence)code)) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.noCode"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (codeMap.containsKey(code)) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.codeExist"));
                exitList.add(excelItem);
                continue;
            }
            if (code.length() > 20) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.codeError"));
                errorList.add(excelItem);
                continue;
            }
            String identifier = excelItem.getIdentifier();
            if (StringUtils.isBlank((CharSequence)identifier)) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.NoIdentifier"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (identiferMap.containsKey(identifier)) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.identifierExist"));
                exitList.add(excelItem);
                continue;
            }
            if (identifier.length() != 18 && identifier.length() != 15) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.identifierError"));
                errorList.add(excelItem);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)excelItem.getName())) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.noName"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (excelItem.getName().length() > 20) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.nameError"));
                errorList.add(excelItem);
                continue;
            }
            String depCode = excelItem.getI_dep_code();
            if (StringUtils.isBlank((CharSequence)depCode)) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.noDepCode"));
                infoNotExitList.add(excelItem);
                continue;
            }
            if (depCode.length() != 12) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.depCodeError"));
                errorList.add(excelItem);
                continue;
            }
            String iMobile = excelItem.getI_mobile();
            if (StringUtils.isBlank((CharSequence)iMobile)) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.noPhone"));
                infoNotExitList.add(excelItem);
                continue;
            }
            String[] mobils = iMobile.split(";");
            HashMap<String, String> tmpMobils = new HashMap<String, String>(8);
            for (String mobil : mobils) {
                if (mobileMap.containsKey(mobil)) break;
                tmpMobils.put(mobil, excelItem.getCode());
            }
            if (mobils.length != tmpMobils.size()) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.phoneExist"));
                exitList.add(excelItem);
                continue;
            }
            boolean ifError = false;
            for (String mobil : mobils) {
                if (mobil.length() <= 15) continue;
                ifError = true;
                break;
            }
            if (ifError) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.phoneError"));
                errorList.add(excelItem);
                continue;
            }
            if (isOne) {
                if (!deviceTypeMap.containsKey(excelItem.getDeviceType())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.deviceType"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (!terminalTypeMap.containsKey(excelItem.getTerminalType())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.terminalType"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (!terminalBrandMap.containsKey(excelItem.getTerminalBrand())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.terminalBrand"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (!terminalOSMap.containsKey(excelItem.getTerminalOs())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.terminalOS"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (!commTypeMap.containsKey(excelItem.getCommType())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.commType"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)excelItem.getTerminalName())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.noTerminalName"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (excelItem.getTerminalName().length() > 32) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.terminalNameError"));
                    errorList.add(excelItem);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)excelItem.getCardName())) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.noCardName"));
                    infoNotExitList.add(excelItem);
                    continue;
                }
                if (excelItem.getCardName().length() > 32) {
                    excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.checkSelf.CardNameError"));
                    errorList.add(excelItem);
                    continue;
                }
            }
            mobileMap.putAll(tmpMobils);
            identiferMap.put(excelItem.getIdentifier(), excelItem.getCode());
            codeMap.put(excelItem.getCode(), excelItem.getCode());
            newSet.add(excelItem);
        }
    }

    private Map<String, String> dbCheck(Map<String, String> identiferMap, Map<String, String> codeMap, Map<String, String> mobileMap) {
        List<Person> personList;
        HashMap<String, String> tmpExitMap = new HashMap<String, String>(8);
        Set<String> tmpKeySet = codeMap.keySet();
        List<List<String>> lists = UserManageServiceImplForXatl.subSet(tmpKeySet, 200);
        for (List<String> codeList : lists) {
            personList = this.queryUserListByCode(codeList);
            if (personList == null || personList.size() <= 0) continue;
            for (Person person : personList) {
                tmpExitMap.put(person.getCode(), "0");
            }
        }
        tmpKeySet = mobileMap.keySet();
        lists = UserManageServiceImplForXatl.subSet(tmpKeySet, 200);
        for (List<String> mobileList : lists) {
            List<Mobile> mobiles = this.queryMobileListByMobile(mobileList);
            if (mobiles == null || mobiles.size() <= 0) continue;
            for (Mobile mobile : mobiles) {
                tmpExitMap.put(mobileMap.get(mobile.getMobile()), "1");
            }
        }
        tmpKeySet = identiferMap.keySet();
        lists = UserManageServiceImplForXatl.subSet(tmpKeySet, 200);
        for (List<String> identifierList : lists) {
            personList = this.queryUserListByIdentifier(identifierList);
            if (personList == null || personList.size() <= 0) continue;
            for (Person person : personList) {
                tmpExitMap.put(identiferMap.get(person.getIdentifier()), "2");
            }
        }
        return tmpExitMap;
    }

    private static List<List<String>> subSet(Set<String> tmpKeySet, int size) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (tmpKeySet != null && tmpKeySet.size() > 0) {
            ArrayList<String> list = new ArrayList<String>(tmpKeySet);
            for (int i = 0; i <= tmpKeySet.size() / size; ++i) {
                if (i * size + size < list.size()) {
                    result.add(list.subList(i * size, i * size + size));
                    continue;
                }
                result.add(list.subList(i * size, list.size()));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    void saveExcel(Set<ImpPersonExcelBean> oldSet, Map<String, String> tmpExitMap, String[] errorMsg, Set<ImpPersonExcelBean> wellList, List<ImpPersonExcelBean> exitList, List<ImpPersonExcelBean> errorList, String createPersonId, HttpServletRequest request) {
        HttpSession session = request.getSession();
        double execelCount = oldSet.size();
        double n = 0.0;
        ArrayList<QueryPersonBean> personList = new ArrayList<QueryPersonBean>();
        for (ImpPersonExcelBean excelItem : oldSet) {
            try {
                if (tmpExitMap.containsKey(excelItem.getCode())) {
                    int i = Integer.parseInt(tmpExitMap.get(excelItem.getCode()));
                    excelItem.setErrorMsg(errorMsg[i]);
                    exitList.add(excelItem);
                    continue;
                }
                Department department = this.depService.getDepartmentByCode(excelItem.getI_dep_code());
                if (department != null) {
                    double d = n;
                    n = d + 1.0;
                    if (d % 100.0 == 0.0) {
                        this.baseDao.flushSession();
                    }
                    QueryPersonBean personBean = new QueryPersonBean();
                    personBean.setCode(excelItem.getCode());
                    personBean.setName(excelItem.getName());
                    personBean.setIdentifier(excelItem.getIdentifier());
                    personBean.setPosition(excelItem.getPosition());
                    personBean.setSex(excelItem.getSex());
                    personBean.setPolice(excelItem.getPolice());
                    personBean.setMobile(excelItem.getI_mobile().replaceAll(";", COMMA));
                    personBean.setDepId(department.getId());
                    personBean.setCreatorId(createPersonId);
                    personBean.setPersonType(excelItem.getPersonType());
                    QueryDeviceBean device = new QueryDeviceBean();
                    device.setTerminalBrand(excelItem.getTerminalBrand());
                    device.setTerminalName(excelItem.getTerminalName());
                    device.setTerminalOs(excelItem.getTerminalOs());
                    device.setTerminalType(excelItem.getTerminalType());
                    device.setType(excelItem.getDeviceType());
                    device.setCommType(excelItem.getCommType());
                    device.setCardName(excelItem.getCardName());
                    device.setUseType(excelItem.getUseType());
                    long timeBetween = System.currentTimeMillis();
                    log.info("savePerson:" + personBean.getCode() + "." + personBean.getName());
                    this.add(personBean, device);
                    personList.add(personBean);
                    log.info("savePerson use time:" + (System.currentTimeMillis() - timeBetween));
                    wellList.add(excelItem);
                    continue;
                }
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.saveExcel.noDep"));
                exitList.add(excelItem);
            }
            catch (Exception e) {
                excelItem.setErrorMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.saveExcel.noSuccess"));
                errorList.add(excelItem);
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                session.setAttribute("uploadUserCount", (Object)(n / execelCount));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSkin(String personId, String skinCode) {
        Person person = this.queryPersonById(personId);
        person.setTheme(skinCode);
        this.updateUser(person);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savaShortcutMenu(String personId, String shortcutMenu) {
        Person person = this.queryPersonById(personId);
        person.setShortcutMenu(shortcutMenu);
        this.updateUser(person);
    }

    @Override
    public Mobile getMobile(String mobile) {
        String selectHql = "from Mobile as mobile where mobile.mobile=?";
        Mobile moblie = this.mobileDao.queryMobileByHql(selectHql, new String[]{mobile});
        return moblie;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteNoPersonMobile() {
        this.personDao.deleteNoPersonMobile();
    }

    @Override
    public boolean checkIdentifer(String identifer) {
        MDPAndPolice person = this.personMDPService.getMDPAndPoliceByIdentifierOrCodeIgnoreCase(identifer);
        return person != null;
    }

    @Override
    public boolean checkCode(String code) {
        MDPAndPolice person = this.personMDPService.getMDPAndPoliceByIdentifierOrCodeIgnoreCase(code);
        return person != null;
    }

    @Override
    public boolean checkIdentifer(String identifer, String personId) {
        MDPAndPolice person = this.personMDPService.getMDPAndPoliceByIdentifierOrCodeIgnoreCase(identifer);
        if (person == null) {
            return false;
        }
        return !personId.equals(person.getId());
    }

    @Override
    public boolean checkCode(String code, String personId) {
        MDPAndPolice person = this.personMDPService.getMDPAndPoliceByIdentifierOrCodeIgnoreCase(code);
        if (person == null) {
            return false;
        }
        return !personId.equals(person.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDeviceByPersonId(String personId) {
        List deviceList = this.deviceService.getAllByPersonId(personId);
        for (Device device : deviceList) {
            this.deviceService.delete(device);
        }
    }

    @Override
    public List<Person> getWorkFlowUserList(String groupid, String personId, String powerid) {
        return this.getWorkFlowUserList(groupid, personId, powerid, null);
    }

    @Override
    public List<Person> getWorkFlowUserList(String groupid, String personId, String powerid, String depId) {
        boolean isNotNullAboutGroupIdAndPersonIdAndDepId;
        ArrayList<Person> person = null;
        boolean bl = isNotNullAboutGroupIdAndPersonIdAndDepId = StringUtils.isNotBlank((CharSequence)groupid) && (StringUtils.isNotBlank((CharSequence)personId) || StringUtils.isNotBlank((CharSequence)depId)) && StringUtils.isNotBlank((CharSequence)powerid);
        if (isNotNullAboutGroupIdAndPersonIdAndDepId) {
            StringBuilder select = new StringBuilder("select distinct(person.id),person.* from t_person person, t_workflow_person_controldep dept,t_upms_person_role personrole,t_upms_role role,t_upms_sysrole_power rolepower where person.id=dept.person_id and (person.id=personrole.person_id or person.dep_id  in (select distinct id from t_department connect by prior id= parent_id start with id in (select department_id from t_upms_department_role where sys_role_id = role.id ))) and person.flag='0' and role.id=personrole.sys_role_id and rolepower.sysrole_id=role.id and rolepower.syspower_id='" + powerid + "' and person.id in(select ship.user_id_ from act_id_membership ship where ship.group_id_='" + groupid + "')");
            Person userperson = null;
            if (StringUtils.isNotBlank((CharSequence)depId)) {
                select.append(" and dept.dep_id = '").append(depId).append("' ");
            } else if (!personId.contains(COMMA)) {
                userperson = this.personDao.queryPersonById(personId);
                String deptId = userperson.getDepartment().getId();
                select.append(" and dept.dep_id = '").append(deptId).append("' ");
            } else {
                String[] personIdSplit = personId.split(COMMA);
                StringBuilder builder = new StringBuilder();
                String depStr = "";
                for (String srt : personIdSplit) {
                    userperson = this.personDao.queryPersonById(srt);
                    String deptId = userperson.getDepartment().getId();
                    builder.append("'").append(deptId).append("',");
                }
                depStr = builder.toString();
                depStr = depStr.substring(0, depStr.length() - 1);
                select.append(" and dept.dep_id in (").append(depStr).append(")");
            }
            List tmpLst = this.personDao.queryPersonListBySql(select.toString());
            if (StringUtils.isNotBlank((CharSequence)depId)) {
                return tmpLst;
            }
            if (tmpLst != null && !tmpLst.isEmpty()) {
                person = new ArrayList<Person>();
                block1: for (Person p : tmpLst) {
                    List ccList = p.getControlPolicedList();
                    if (ccList == null || ccList.isEmpty()) {
                        person.add(p);
                        continue;
                    }
                    for (CommonCode cc : ccList) {
                        assert (userperson != null);
                        if (!userperson.getPolice().equals(cc.getCode())) continue;
                        person.add(p);
                        continue block1;
                    }
                }
            }
        }
        return person;
    }

    @Override
    public List<Person> getWorkFlowUserListByDep(String groupid, String personId, String powerid, String depIds) {
        ArrayList<Person> person = null;
        if (StringUtils.isNotBlank((CharSequence)groupid) && StringUtils.isNotBlank((CharSequence)powerid) && StringUtils.isNotBlank((CharSequence)depIds)) {
            List tmpLst;
            String[] depArr = depIds.split(COMMA);
            StringBuilder depIdBuilder = new StringBuilder();
            for (String dep : depArr) {
                depIdBuilder.append("'").append(dep).append("',");
            }
            String depIdStr = depIdBuilder.toString();
            if (depIdStr.length() > 0) {
                depIdStr = depIdStr.substring(0, depIdStr.length() - 1);
            }
            StringBuilder select = new StringBuilder("select distinct(person.id),person.* from t_person person, t_workflow_person_controldep dept,t_upms_person_role personrole,t_upms_role role,t_upms_sysrole_power rolepower where person.id=dept.person_id and (person.id=personrole.person_id or person.dep_id  in (select distinct id from t_department connect by prior id= parent_id start with id in (select department_id from t_upms_department_role where sys_role_id = role.id )))and person.flag='0' and role.id=personrole.sys_role_id and rolepower.sysrole_id=role.id and rolepower.syspower_id='" + powerid + "' and person.dep_id in (select distinct id from t_department connect by prior id = parent_id start with id in (" + depIdStr + ") ) ");
            Person userperson = null;
            if (StringUtils.isNotBlank((CharSequence)personId)) {
                if (!personId.contains(COMMA)) {
                    userperson = this.personDao.queryPersonById(personId);
                    String deptId = userperson.getDepartment().getId();
                    select.append(" and dept.dep_id = '").append(deptId).append("' ");
                } else {
                    String[] personIdSplit = personId.split(COMMA);
                    StringBuilder depBuilder = new StringBuilder();
                    for (String srt : personIdSplit) {
                        userperson = this.personDao.queryPersonById(srt);
                        String deptId = userperson.getDepartment().getId();
                        depBuilder.append("'").append(deptId).append("',");
                    }
                    String depStr = depBuilder.toString();
                    depStr = depStr.substring(0, depStr.length() - 1);
                    select.append(" and dept.dep_id in (").append(depStr).append(")");
                }
            }
            if ((tmpLst = this.personDao.queryPersonListBySql(select.toString())) != null && !tmpLst.isEmpty()) {
                person = new ArrayList<Person>();
                block2: for (Person p : tmpLst) {
                    List ccList = p.getControlPolicedList();
                    if (ccList == null || ccList.isEmpty()) {
                        person.add(p);
                        continue;
                    }
                    for (CommonCode cc : ccList) {
                        assert (userperson != null);
                        if (!userperson.getPolice().equals(cc.getCode())) continue;
                        person.add(p);
                        continue block2;
                    }
                }
            }
        }
        return person;
    }

    @Override
    public List<Person> getWorkFlowUserListByGroupDep(String groupid, String personId, String powerid) {
        ArrayList<Person> person = null;
        if (StringUtils.isNotBlank((CharSequence)groupid) && StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)powerid)) {
            StringBuilder select = new StringBuilder("select distinct(person.id),person.* from t_person person, t_workflow_person_controldep dept,t_upms_person_role personrole,t_upms_role role,t_upms_sysrole_power rolepower where person.id=dept.person_id and  (person.id=personrole.person_id or person.dep_id  in (select distinct id from t_department connect by prior id= parent_id start with id in (select department_id from t_upms_department_role where sys_role_id = role.id ))) and person.flag='0' and role.id=personrole.sys_role_id and rolepower.sysrole_id=role.id and rolepower.syspower_id='" + powerid + "' and person.dep_id in (select distinct id from t_department connect by prior id = parent_id start with id in (select dep_id_ from T_WORKFLOW_GROUP_DEP where group_id_ = '" + groupid + "') ) ");
            Person userperson = null;
            if (!personId.contains(COMMA)) {
                userperson = this.personDao.queryPersonById(personId);
                String deptId = userperson.getDepartment().getId();
                select.append(" and dept.dep_id = '").append(deptId).append("' ");
            } else {
                String[] personIdSplit = personId.split(COMMA);
                StringBuilder builder = new StringBuilder();
                for (String srt : personIdSplit) {
                    userperson = this.personDao.queryPersonById(srt);
                    String deptId = userperson.getDepartment().getId();
                    builder.append("'").append(deptId).append("',");
                }
                String depStr = builder.toString();
                depStr = depStr.substring(0, depStr.length() - 1);
                select.append(" and dept.dep_id in (").append(depStr).append(")");
            }
            List tmpLst = this.personDao.queryPersonListBySql(select.toString());
            if (tmpLst != null && !tmpLst.isEmpty()) {
                person = new ArrayList<Person>();
                block1: for (Person p : tmpLst) {
                    List ccList = p.getControlPolicedList();
                    if (ccList == null || ccList.isEmpty()) {
                        person.add(p);
                        continue;
                    }
                    for (CommonCode cc : ccList) {
                        if (!userperson.getPolice().equals(cc.getCode())) continue;
                        person.add(p);
                        continue block1;
                    }
                }
            }
        }
        return person;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveControlDeptList(String personId, String controldept, String controlpolice) {
        ArrayList<Department> controlDepdList = new ArrayList<Department>();
        ArrayList<CommonCode> controlPolicedList = new ArrayList<CommonCode>();
        Person p = this.queryPersonById(personId);
        String[] controldepts = controldept.split(COMMA);
        if (StringUtils.isNotBlank((CharSequence)controlpolice)) {
            String[] controlpolices;
            for (String controlpolice1 : controlpolices = controlpolice.split(COMMA)) {
                CommonCode police = new CommonCode();
                CommonCode code = this.commonCodeService.get((Serializable)((Object)controlpolice1));
                police.setId(code.getId());
                police.setName(code.getName());
                police.setCode(code.getCode());
                police.setpCode(code.getpCode());
                controlPolicedList.add(police);
            }
            p.setControlPolicedList(controlPolicedList);
        } else {
            p.setControlPolicedList(null);
        }
        for (String controldept1 : controldepts) {
            Department dept = this.depService.queryDepById(controldept1);
            controlDepdList.add(dept);
        }
        p.setControlDepdList(controlDepdList);
        this.updateUser(p);
        List deptlist = p.getControlDepdList();
        this.depService.deleteWorkFlowControlDept(personId);
        for (Department dept : deptlist) {
            List childdeptlist = this.depService.getAllDepartments(dept.getId());
            for (Department childdept : childdeptlist) {
                WorkFlowControlDept entity = new WorkFlowControlDept();
                entity.setPersonId(personId);
                entity.setDepId(childdept.getId());
                this.depService.addWorkFlowControlDept(entity);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void saveControlDeptList2(Person p, String controldept) {
        String[] controldepts;
        ArrayList<Department> controlDepdList = new ArrayList<Department>();
        for (String controldept1 : controldepts = controldept.split(COMMA)) {
            Department dept = this.depService.queryDepById(controldept1);
            controlDepdList.add(dept);
        }
        p.setControlDepdList(controlDepdList);
        this.updateUser(p);
        List deptlist = p.getControlDepdList();
        this.depService.deleteWorkFlowControlDept(p.getId());
        for (Department dept : deptlist) {
            List childdeptlist = this.depService.getAllDepartments(dept.getId());
            for (Department childdept : childdeptlist) {
                WorkFlowControlDept entity = new WorkFlowControlDept();
                entity.setPersonId(p.getId());
                entity.setDepId(childdept.getId());
                this.depService.addWorkFlowControlDept(entity);
            }
        }
    }

    @Override
    public pams.function.xatl.bims.bean.PersonBean getPersonById(String id) {
        String sql = "select t.name,(select t2.name  from t_commoncode t1,t_commoncode t2 where  t2.type=t1.id  and t1.code='sex' and t2.code=t.sex) as sex,t.code,t.identifier,d.id as depId, d.name as depName,d.code as depCode,t.police,t.grade from t_person t,t_department d where t.dep_id=d.id and t.id='" + id + "'";
        List list = this.baseDao.getListBySQL(sql, null, PersonBean.class);
        if (list != null && !list.isEmpty()) {
            return (pams.function.xatl.bims.bean.PersonBean)list.get(0);
        }
        return null;
    }

    @Override
    public String getWorkFlowUser(String personId, String groupId) {
        String personIds;
        StringBuilder builder = new StringBuilder();
        try {
            List<Person> personList = this.getWorkFlowUserList(groupId, personId, "SCMS02");
            for (Person person : personList) {
                builder.append(person.getId()).append(COMMA);
            }
            personIds = builder.toString();
            if (!"".equals(personIds)) {
                personIds = personIds.substring(0, personIds.length() - 1);
            }
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"wfms.error.notApprovePerson"), (Throwable)e);
            throw new WorkflowException(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"wfms.error.notApprovePerson"));
        }
        return personIds;
    }

    @Override
    public String checkMobileIsExist(String[] mobiles) {
        HashMap<String, String> mMap = new HashMap<String, String>(8);
        String tmp = null;
        for (String m : mobiles) {
            if (Util.varCheckEmp((String)m)) continue;
            if (mMap.get(m) != null) {
                tmp = m;
                break;
            }
            mMap.put(m, m);
            Mobile tmpMobile = this.getMobile(m);
            if (tmpMobile == null) continue;
            tmp = m;
            break;
        }
        return tmp;
    }

    @Override
    public boolean checkdelete(String personId) {
        String cardStates = this.systemConfigPbService.getValueByCode("can_not_delete_state");
        if (cardStates == null) {
            return true;
        }
        List deviceList = this.deviceService.getByPersonId(personId);
        if (deviceList == null || deviceList.size() == 0) {
            return true;
        }
        for (Device dev : deviceList) {
            if (!cardStates.contains(dev.getState())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int checkCardCanEdit(String cardState) {
        String cardStates = this.systemConfigPbService.getValueByCode("can_not_edit_state");
        if (cardStates == null) {
            return 1;
        }
        if (cardStates.contains(cardState)) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getBingDingState(String cardType) {
        if ("1".equals(cardType) || "2".equals(cardType)) {
            return "0";
        }
        String bingDingType = this.systemConfigPbService.getValueByCode("terminalbindtype");
        if (bingDingType == null) {
            return "0";
        }
        return bingDingType;
    }

    @Override
    public List<QueryPersonBean> queryPersonList2(QueryPersonBean queryBean, String controlDepIds, String controlPolices, Page page) {
        List<Person> personList = this.queryPersonList(queryBean, controlDepIds, controlPolices, page);
        ArrayList<QueryPersonBean> list = new ArrayList<QueryPersonBean>();
        for (Person aPersonList : personList) {
            QueryPersonBean personBean = new QueryPersonBean();
            personBean.setId(aPersonList.getId());
            personBean.setCode(aPersonList.getCode());
            personBean.setName(aPersonList.getName());
            personBean.setSex(this.commonCodePbService.getCodeNameByCode(aPersonList.getSex(), "sex"));
            personBean.setIdentifier(aPersonList.getIdentifier());
            personBean.setDepName(aPersonList.getDepartment().getName());
            personBean.setPolice(this.commonCodePbService.getCodeNameByCode(aPersonList.getPolice(), "2012"));
            personBean.setPosition(this.commonCodePbService.getCodeNameByCode(aPersonList.getPosition(), "2011"));
            personBean.setOrderField(aPersonList.getOrderField());
            personBean.setLockState(aPersonList.getLockState());
            personBean.setPersonType(aPersonList.getPersonType());
            personBean.setPersonTypeName(this.commonCodePbService.getCodeNameByCode(aPersonList.getPersonType(), "PERSON_TYPE"));
            personBean.setPersonStateName(this.commonCodePbService.getCodeNameByCode(aPersonList.getPersonState(), "personState"));
            personBean.setCommTypeName(this.commonCodePbService.getCodeNameByCode(aPersonList.getCommType(), "2015"));
            personBean.setGradeName(this.commonCodePbService.getCodeNameByCode(aPersonList.getLeaderLevel(), "grade"));
            List controldept = aPersonList.getControlDepdList();
            List controlMobile = aPersonList.getMobiledList();
            List controlpolice = aPersonList.getControlPolicedList();
            StringBuilder deptstrBuilder = new StringBuilder();
            StringBuilder mobileBuilder = new StringBuilder();
            StringBuilder policeBuilder = new StringBuilder();
            String mobileStr = "";
            for (Department bean : controldept) {
                deptstrBuilder.append(bean.getName()).append(COMMA);
            }
            String deptstr = deptstrBuilder.toString();
            if (deptstrBuilder.length() > 0) {
                deptstr = deptstr.substring(0, deptstr.length() - 1);
            }
            if (controlMobile != null && controlMobile.size() > 0) {
                for (Department bean : controlMobile) {
                    mobileBuilder.append(bean.getMobile()).append(COMMA);
                }
                mobileStr = mobileBuilder.toString();
                mobileStr = mobileStr.substring(0, mobileStr.lastIndexOf(COMMA));
            }
            for (Department bean : controlpolice) {
                policeBuilder.append(bean.getName()).append(COMMA);
            }
            String policestr = policeBuilder.toString();
            if (policestr.endsWith(COMMA)) {
                policestr = policestr.substring(0, deptstr.length() - 1);
            }
            personBean.setControldept(deptstr);
            personBean.setMobile(mobileStr);
            personBean.setControlpolice(policestr);
            personBean.setDisplayState(aPersonList.getDisplayState());
            personBean.setOfficePhone(aPersonList.getOfficePhone());
            list.add(personBean);
        }
        return list;
    }

    private void lazyPerson(Person p) {
        if (p != null) {
            List g;
            List r;
            List m;
            List c;
            List d = p.getControlDepdList();
            if (d != null) {
                d.isEmpty();
            }
            if ((c = p.getControlPolicedList()) != null) {
                c.isEmpty();
            }
            if ((m = p.getMobiledList()) != null) {
                m.isEmpty();
            }
            if ((r = p.getRoleList()) != null) {
                r.isEmpty();
            }
            if ((g = p.getGroupList()) != null) {
                g.isEmpty();
            }
        }
    }

    @Override
    public boolean judgePerson(String personPolice, String controlPolice) {
        if (StringUtils.isBlank((CharSequence)controlPolice) || ALL_STR.equals(controlPolice)) {
            return true;
        }
        return controlPolice.contains(personPolice);
    }

    @Override
    public List<Person> querySynPersonList(SynQueryParam synQueryParam, Page page) {
        StringBuilder selecttab = new StringBuilder("from t_person where 1=1");
        ArrayList<String> list = new ArrayList<String>();
        long lastTime = Long.parseLong(synQueryParam.getLastTime());
        if (lastTime > 0L) {
            selecttab.append(" and N_LAST_UPDATE_TIME>?");
            list.add(Long.toString(lastTime));
        }
        long endLastTime = 0L;
        try {
            if (StringUtils.isNotBlank((CharSequence)synQueryParam.getEndLastTime())) {
                endLastTime = Long.parseLong(synQueryParam.getEndLastTime());
            }
        }
        catch (NumberFormatException e) {
            endLastTime = 0L;
        }
        if (endLastTime > 0L) {
            selecttab.append(" and N_LAST_UPDATE_TIME<?");
            list.add(Long.toString(endLastTime));
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getCode())) {
            selecttab.append(" and code=?");
            list.add(synQueryParam.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getCardNo())) {
            selecttab.append(" and id in (select person_id from t_device where lower(card_id)=lower(?) or lower(iccid)=lower(?))");
            list.add(synQueryParam.getCardNo());
            list.add(synQueryParam.getCardNo());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getId())) {
            selecttab.append(" and id=?");
            list.add(synQueryParam.getId());
        }
        String selectCount = "select count(*) " + selecttab.toString();
        String select = "select * " + selecttab.toString() + " order by N_LAST_UPDATE_TIME asc";
        return this.personDao.queryPersonListBySql(selectCount, select, list.toArray(), page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserDep(String ids, String depId) {
        String[] idArray = ids.split(COMMA);
        Department dep = this.depService.queryDepById(depId);
        for (String id : idArray) {
            Person oldPerson = this.queryPersonById(id);
            oldPerson.setTimestamp(System.currentTimeMillis());
            PersonUpdated personUpdated = new PersonUpdated();
            personUpdated.setCode(oldPerson.getCode());
            personUpdated.setName(oldPerson.getName());
            personUpdated.setIdentifier(oldPerson.getIdentifier());
            personUpdated.setDepName(oldPerson.getDepartment().getName());
            personUpdated.setDepCode(oldPerson.getDepartment().getCode());
            personUpdated.setDepartmnetId(oldPerson.getDepartment().getId());
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            Operator operator = (Operator)request.getSession().getAttribute("operator");
            personUpdated.setEditorId(operator.getPerson().getId());
            personUpdated.setMobile(oldPerson.getMobile());
            personUpdated.setOrderField(oldPerson.getOrderField());
            personUpdated.setPersonId(oldPerson.getId());
            personUpdated.setPosition(oldPerson.getPosition());
            personUpdated.setSex(oldPerson.getSex());
            personUpdated.setPersonType(oldPerson.getPersonType());
            personUpdated.setMobileMultimediaMessage(oldPerson.getMobileMultimediaMessage());
            personUpdated.setMobilePersonal(oldPerson.getMobilePersonal());
            oldPerson.getPersonUpdatedList().add(personUpdated);
            oldPerson.setDepartment(dep);
            oldPerson.setDepId(depId);
            oldPerson.setDepCode(dep.getCode());
            this.updateUser(oldPerson);
            this.saveControlDeptList2(oldPerson, oldPerson.getDepId());
            this.terminalReportService.saveAndReportLogForEdit(oldPerson);
            this.fjmsNotice(id, "1");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateClientLoginTime(Person person) {
        this.personDao.updatePerson(person);
    }

    @Override
    public List<Person> getWorkFlowUserListByDepAndDepApply(String groupid, String depId, String powerid, String depIds) {
        List person = null;
        if (StringUtils.isNotBlank((CharSequence)groupid) && StringUtils.isNotBlank((CharSequence)powerid) && StringUtils.isNotBlank((CharSequence)depIds)) {
            String[] depArr = depIds.split(COMMA);
            StringBuilder builder = new StringBuilder();
            String depIdStr = "";
            for (String dep : depArr) {
                builder.append("'").append(dep).append("',");
            }
            depIdStr = builder.toString();
            if (depIdStr.length() > 0) {
                depIdStr = depIdStr.substring(0, depIdStr.length() - 1);
            }
            String select = "select distinct(person.id),person.* from t_person person, t_workflow_person_controldep dept,t_upms_person_role personrole,t_upms_role role,t_upms_sysrole_power rolepower where person.id=dept.person_id and (person.id=personrole.person_id or person.dep_id  in (select distinct id from t_department connect by prior id= parent_id start with id in (select department_id from t_upms_department_role where sys_role_id = role.id )))and person.flag='0' and role.id=personrole.sys_role_id and rolepower.sysrole_id=role.id and rolepower.syspower_id='" + powerid + "' and person.dep_id in (select distinct id from t_department connect by prior id = parent_id start with id in (" + depIdStr + ") ) " + " and dept.dep_id = '" + depId + "' ";
            person = this.personDao.queryPersonListBySql(select);
        }
        return person;
    }

    @Override
    public List<Person> queryPerson(QueryPersonBean queryBean) {
        StringBuilder selectHql = new StringBuilder("select distinct person.* from t_person person left join t_bims_mobile m  on  person.id=m.person_id where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        selectHql.append("and person.flag = ? ");
        paramList.add("0");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCode())) {
            selectHql.append("and person.code like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getCode()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getIdentifier())) {
            selectHql.append("and person.identifier like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getIdentifier()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and person.name like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getMobile())) {
            selectHql.append("and m.mobile like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getMobile()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPosition())) {
            selectHql.append("and person.position = ? ");
            paramList.add(StringUtils.trim((String)queryBean.getPosition()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPolice())) {
            selectHql.append("and person.police = ? ");
            paramList.add(StringUtils.trim((String)queryBean.getPolice()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getLockState())) {
            selectHql.append("and person.CLIENT_LOCK_STATE = ? ");
            paramList.add(queryBean.getLockState());
        }
        if (null != queryBean.getClientLoginTime()) {
            selectHql.append("and person.login_time is not Null ");
        }
        if (queryBean.getIsContain() != null && queryBean.getIsContain().contains(TRUE_STR)) {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepName())) {
                selectHql.append("and person.dep_Id in (").append(BimsUtil.getAllDepIdByName()).append(")");
                paramList.add("%" + queryBean.getDepName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
                selectHql.append("and person.dep_Id in (").append(BimsUtil.getChildDepsSql()).append(")");
                paramList.add(queryBean.getDepId());
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepName())) {
                selectHql.append("and person.dep_Id in (").append(BimsUtil.getDepIdByName()).append(")");
                paramList.add("%" + StringUtils.trim((String)queryBean.getDepName()) + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
                selectHql.append("and person.dep_Id = ? ");
                paramList.add(queryBean.getDepId());
            }
        }
        return this.personDao.queryPersonListBySql(selectHql.toString(), paramList.toArray());
    }

    @Override
    public List<Person> queryNotCardPerson(QueryPersonBean queryBean) {
        StringBuilder selectHql = new StringBuilder("select distinct person.* from t_person person left join t_bims_mobile m  on  person.id=m.person_id where person.id not in (select person_id from t_device where nvl(revokeflag,'0') <>'1') ");
        ArrayList<String> paramList = new ArrayList<String>();
        selectHql.append("and person.flag = ? ");
        paramList.add("0");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCode())) {
            selectHql.append("and person.code like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getCode()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getIdentifier())) {
            selectHql.append("and person.identifier like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getIdentifier()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getName())) {
            selectHql.append("and person.name like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getMobile())) {
            selectHql.append("and m.mobile like ? ");
            paramList.add("%" + StringUtils.trim((String)queryBean.getMobile()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPosition())) {
            selectHql.append("and person.position = ? ");
            paramList.add(StringUtils.trim((String)queryBean.getPosition()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getPolice())) {
            selectHql.append("and person.police = ? ");
            paramList.add(StringUtils.trim((String)queryBean.getPolice()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getLockState())) {
            selectHql.append("and person.CLIENT_LOCK_STATE = ? ");
            paramList.add(queryBean.getLockState());
        }
        if (null != queryBean.getClientLoginTime()) {
            selectHql.append("and person.login_time is not Null ");
        }
        if (queryBean.getIsContain() != null && queryBean.getIsContain().contains(TRUE_STR)) {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepName())) {
                selectHql.append("and person.dep_Id in (").append(BimsUtil.getAllDepIdByName()).append(")");
                paramList.add("%" + queryBean.getDepName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
                selectHql.append("and person.dep_Id in (").append(BimsUtil.getChildDepsSql()).append(")");
                paramList.add(queryBean.getDepId());
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepName())) {
                selectHql.append("and person.dep_Id in (").append(BimsUtil.getDepIdByName()).append(")");
                paramList.add("%" + StringUtils.trim((String)queryBean.getDepName()) + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDepId())) {
                selectHql.append("and person.dep_Id = ? ");
                paramList.add(queryBean.getDepId());
            }
        }
        return this.personDao.queryPersonListBySql(selectHql.toString(), paramList.toArray());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Person applyJwt(QueryPersonBean personBean, QueryDeviceBean device) {
        Person p = this.getPerson(personBean);
        this.addUserAndDevice(p, device);
        this.saveControlDeptList2(p, personBean.getDepId());
        return p;
    }

    private void fjmsNotice(String personId, String type) {
        String fjmsNotictUse = this.systemConfigPbService.getValueByCode("fjms_notice_use");
        if (!"1".equals(fjmsNotictUse)) {
            return;
        }
        String url = this.systemConfigPbService.getValueByCode("fjms_notice_url");
        HttpRequestUtil httpClientUtil = new HttpRequestUtil();
        String param = "personId=" + personId + "&type=" + type;
        try {
            String rst = httpClientUtil.post(url, param);
            Map map = (Map)Util.readValue((String)rst, Map.class);
            String flag = (String)map.get("flag");
            if (!"0".equals(flag)) {
                throw new RuntimeException("\u8c03\u7528\u8f85\u8b66\u901a\u77e5\u63a5\u53e3\u5931\u8d25[" + (String)map.get("message") + "]");
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8f85\u8b66\u901a\u77e5\u63a5\u53e3\u5931\u8d25[" + e.getMessage() + "]", (Throwable)e);
            throw new RuntimeException("\u8c03\u7528\u8f85\u8b66\u901a\u77e5\u63a5\u53e3\u5931\u8d25[" + e.getMessage() + "]");
        }
    }

    @Override
    public List<TreePerson> queryTreePersonList(String controlDepIds, String controlPolices) {
        String sql = "select id,name,dep_id,code,person_type,mobile,flag,order_Field from t_person where flag ='0'  and dep_id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ")";
        if (!ALL_STR.equals(controlPolices)) {
            sql = sql + "and police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ")";
        }
        return this.personDao.queryTreePersonBySql(sql, null);
    }

    @Override
    public List<TreePerson> queryTreePersonList(String controlDepIds, String controlPolices, String key) {
        String sql = "select id,name,dep_id,code,person_type,mobile,flag,order_Field from t_person where (DISPLAY_STATE='1' or DISPLAY_STATE is null) and flag ='0'  and dep_id in (" + BimsUtil.getChildDepsSqlDisplayFalse((String)controlDepIds) + ")";
        ArrayList<String> param = new ArrayList<String>();
        if (!ALL_STR.equals(controlPolices)) {
            sql = sql + "and police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ")";
        }
        if (StringUtils.isNotBlank((CharSequence)key)) {
            sql = sql + " and (name like ? or code like ? or mobile like ?)";
            param.add("%" + key + "%");
            param.add("%" + key + "%");
            param.add("%" + key + "%");
        }
        sql = sql + " order by order_Field,code asc";
        return this.personDao.queryTreePersonBySql(sql, param.toArray());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePersonDepByState() {
        String selectHql = "select * from t_person person where person.flag = ? and state=? and dep_id <>'4028928a525e2aa501525e303838000b'";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("0");
        paramList.add("2");
        List list = this.personDao.queryPersonListBySql(selectHql, paramList.toArray());
        if (list != null && !list.isEmpty()) {
            Department depDie = this.depService.queryDepById("4028928a525e2aa501525e303838000b");
            for (Person person : list) {
                person.setDepartment(depDie);
                this.updateUser(person);
            }
        }
        selectHql = "select * from t_person person where person.flag = ? and state=? and dep_id <>'4028928a525e2aa501525e2ffc240007'";
        paramList = new ArrayList();
        paramList.add("0");
        paramList.add("3");
        list = this.personDao.queryPersonListBySql(selectHql.toString(), paramList.toArray());
        if (list != null && !list.isEmpty()) {
            Department depRetire = this.depService.queryDepById("4028928a525e2aa501525e2ffc240007");
            for (Person person : list) {
                person.setDepartment(depRetire);
                this.updateUser(person);
            }
        }
        selectHql = "select * from t_person person where person.flag = ? and state=? and dep_id <>'4028928a5261c25f015261cd3c540016'";
        paramList = new ArrayList();
        paramList.add("0");
        paramList.add("4");
        list = this.personDao.queryPersonListBySql(selectHql, paramList.toArray());
        if (list != null && !list.isEmpty()) {
            Department depTransfer = this.depService.queryDepById("4028928a5261c25f015261cd3c540016");
            for (Person person : list) {
                person.setDepartment(depTransfer);
                this.updateUser(person);
            }
        }
    }

    @Override
    public List<PersonTerminal> queryUseImeiList(String personId) {
        return this.personDao.queryPersonImeiList(personId);
    }

    public void saveOrUpdatePersonExtra(String personId, List<PersonExtraColumnBean> columns) {
        if (personId != null && columns != null && columns.size() > 0) {
            String data = Util.toJsonStr(columns);
            if (log.isDebugEnabled()) {
                log.debug("PersonExtra: " + data);
            }
            PersonExtra pe = new PersonExtra();
            pe.setPersonId(personId);
            pe.setData(data);
            this.personExtraDao.saveOrUpdatePersonExtra(pe);
        }
    }

    @Override
    public List<PersonExtraColumnBean> getPersonExtraByPersonId(String personId) {
        PersonExtra pe = this.personExtraDao.getPersonExtraByPersonId(personId);
        if (pe != null) {
            return (List)Util.readValue((String)pe.getData(), ArrayList.class, (Class[])new Class[]{PersonExtraColumnBean.class});
        }
        return null;
    }

    @Override
    public Map<String, List<PersonExtraColumnBean>> getPersonExtraByPersonIds(List<String> personIds) {
        HashMap<String, List<PersonExtraColumnBean>> map = new HashMap<String, List<PersonExtraColumnBean>>(8);
        List list = this.personExtraDao.getPersonExtraByPersonIds(personIds);
        if (list != null && !list.isEmpty()) {
            for (PersonExtra pe : list) {
                List peList = (List)Util.readValue((String)pe.getData(), ArrayList.class, (Class[])new Class[]{PersonExtraColumnBean.class});
                map.put(pe.getPersonId(), peList);
            }
        }
        return map;
    }

    @Override
    public List<Person> querySynPersonListWithoutFuJing(SynQueryParam synQueryParam, Page page) {
        StringBuilder selecttab = new StringBuilder("from t_person where 1=1 and person_type <> '2'");
        ArrayList<String> list = new ArrayList<String>();
        long lastTime = Long.parseLong(synQueryParam.getLastTime());
        if (lastTime > 0L) {
            selecttab.append(" and N_LAST_UPDATE_TIME>=?");
            list.add(Long.toString(lastTime));
        }
        long endLastTime = 0L;
        try {
            if (StringUtils.isNotBlank((CharSequence)synQueryParam.getEndLastTime())) {
                endLastTime = Long.parseLong(synQueryParam.getEndLastTime());
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (endLastTime > 0L) {
            selecttab.append(" and N_LAST_UPDATE_TIME<?");
            list.add(Long.toString(endLastTime));
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getCode())) {
            selecttab.append(" and code=?");
            list.add(synQueryParam.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getCardNo())) {
            selecttab.append(" and id in (select person_id from t_device where lower(card_id)=lower(?) or lower(iccid)=lower(?))");
            list.add(synQueryParam.getCardNo());
            list.add(synQueryParam.getCardNo());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getId())) {
            selecttab.append(" and id=?");
            list.add(synQueryParam.getId());
        }
        String selectCount = "select count(*) " + selecttab.toString();
        String select = "select * " + selecttab.toString() + " order by N_LAST_UPDATE_TIME asc";
        return this.personDao.queryPersonListBySql(selectCount, select, list.toArray(), page);
    }

    @Override
    public List<Person> queryPersonByPersonIds(List<String> personIds) {
        StringBuilder select = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        select.append(" select * from t_Person t where flag != '1' ");
        if (null != personIds && personIds.size() > 0) {
            select.append(" and ( ");
            for (int i = 0; i < personIds.size(); ++i) {
                select.append(" id = ? ");
                if (i != personIds.size() - 1) {
                    select.append(" or ");
                }
                values.add(personIds.get(i));
            }
            select.append(" ) ");
        }
        return this.baseDao.getListBySQL(select.toString(), values.toArray(), Person.class);
    }

    @Override
    public List<String> queryAllPersonId() {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("0");
        return this.baseDao.getListByHQL("select distinct person.id from Person person where person.flag = ? ", paramList.toArray());
    }

    @Override
    public List<PersonDepBean> queryAllPersonInfo() {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("0");
        return this.baseDao.getListBySQL("select t.id, t.name, t.code, d.name depName from t_person t left join t_department d on t.dep_id = d.id where t.flag = ? ", paramList.toArray(), PersonDepBean.class);
    }
}

