/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.common.util;

import com.xdja.pams.common.filter.SafeFilters;
import com.xdja.pams.common.util.ConfigSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    private static final long serialVersionUID = 1L;
    private static ObjectMapper mapper = new ObjectMapper();

    public static String getDate(String format) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String getStrDate(long publishTime) {
        String strDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(publishTime);
        return strDate;
    }

    public static String getDate(String format, Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static int compare(Date date1, Date date2) {
        long l2;
        long l1 = date1.getTime();
        if (l1 > (l2 = date2.getTime())) {
            return 1;
        }
        if (l1 == l2) {
            return 0;
        }
        if (l1 < l2) {
            return -1;
        }
        return 0;
    }

    public static Date relationDate(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, i);
        return cal.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.set(5, 1);
        return cd.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        return Util.addDay(Util.getFirstDayOfMonth(Util.addMonth(date, 1)), -1);
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date parseDate(String s) throws Exception {
        DateFormat df = DateFormat.getDateInstance(2, new Locale("zh", "CN"));
        return df.parse(s);
    }

    public static Date parseDate(String s, String formart) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(formart);
        return sdf.parse(s);
    }

    public static Long getLongDate(String dateStr) throws ParseException {
        SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = simpledateformat.parse(dateStr);
        return date.getTime();
    }

    public String[] split(String s, String regex) {
        return this.split(s, regex, -1);
    }

    public String[] split(String s, String regex, int limit) {
        if (null == s) {
            return null;
        }
        return s.split(regex, limit);
    }

    public String toUpperCase(String s) {
        return Util.varFormat(s).toUpperCase();
    }

    public String toLowerCase(String s) {
        return Util.varFormat(s).toLowerCase();
    }

    public String limitFormat(String s, int len) {
        return this.limitFormat(s, len, true, "");
    }

    public String limitFormat(String s, int len, String c) {
        return this.limitFormat(s, len, true, c);
    }

    public String limitFormat(String s, int len, boolean b) {
        return this.limitFormat(s, len, b, "");
    }

    public String limitFormat(String s, int len, boolean b, String c) {
        s = Util.varFormat(s);
        c = Util.varFormat(c);
        if (s.length() > len) {
            if (b) {
                if ("".equals(c)) {
                    return s.substring(0, len);
                }
                return s.substring(0, len) + c;
            }
            if ("".equals(c)) {
                return s.substring(s.length() - len, s.length());
            }
            return c + s.substring(s.length() - len, s.length());
        }
        return s;
    }

    public static String sqlFormat(String s) {
        if ((s = Util.varFormat(s)).contains("'")) {
            s = s.replaceAll("'", "''");
        }
        if (s.contains("%")) {
            s = s.replaceAll("%", "\\\\%");
        }
        return s;
    }

    public static String urlFormat(String s) {
        return Util.varFormat(s).replaceAll("&", "%26");
    }

    public static String xmlFormat(String s, String c) {
        s = Util.varFormat(s);
        if ((c = Util.varFormat(c)).contains("&")) {
            s = s.replaceAll("&", "&amp;");
        }
        if (c.contains("<")) {
            s = s.replaceAll("<", "&lt;");
        }
        if (c.contains(">")) {
            s = s.replaceAll(">", "&gt;");
        }
        if (c.contains("\"")) {
            s = s.replaceAll("\"", "&quot;");
        }
        if (c.contains("'")) {
            s = s.replaceAll("'", "&#39;");
        }
        if (c.contains(" ")) {
            s = s.replaceAll(" ", "&nbsp;");
        }
        return s;
    }

    public static String xmlFormat(String s) {
        return Util.xmlFormat(s, "<'&\">");
    }

    public static String xmlMobileFormat(String s) {
        s = s.replaceAll("&", "");
        return Util.xmlFormat(s, "<'&\">");
    }

    public String xmlSpanFormat(String s, String c) {
        if ("".equals(s = Util.xmlFormat(s, c))) {
            s = "\u3000";
        }
        return s;
    }

    public static String xmlSpanFormat(String s) {
        if ("".equals(s = Util.xmlFormat(s))) {
            s = "\u3000";
        }
        return s;
    }

    public String jsStringFormat(String s) {
        if (s == null) {
            s = "";
        } else {
            s = s.replaceAll("\\\\", "\\\\\\\\");
            s = s.replaceAll("\b", "\\\\b");
            s = s.replaceAll("\f", "\\\\f");
            s = s.replaceAll("\n", "\\\\n");
            s = s.replaceAll("\r", "\\\\r");
            s = s.replaceAll("\t", "\\\\t");
            s = s.replaceAll("'", "\\\\'");
            s = s.replaceAll("\"", "\\\\\"");
        }
        return s;
    }

    public static Date relationMonth(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, i);
        return cal.getTime();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public long getLong(String num) {
        if (num == null) {
            return 0L;
        }
        String pattern = "[0-9]+";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(num);
        boolean b = m.matches();
        if (b) {
            return Long.parseLong(num);
        }
        return 0L;
    }

    public double getDouble(String num) {
        if (num == null) {
            return 0.0;
        }
        String pattern = "[0-9]+(.[0-9]+)?";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(num);
        boolean b = m.matches();
        if (b) {
            return Double.parseDouble(num);
        }
        return 0.0;
    }

    public static boolean checkNum(String num) {
        boolean b = false;
        if (num != null && !Util.varCheckEmp(num) && num.length() == 11) {
            String pattern = "[0-9]+";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(num);
            b = m.matches();
        }
        return b;
    }

    public static Calendar getCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        Util.setCalendar(calendar);
        return calendar;
    }

    private static void setCalendar(Calendar calendar) {
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(1);
    }

    public static Calendar getCalendar(int year, int month, int dayOfMonth) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, dayOfMonth);
        Util.setCalendar(calendar);
        return calendar;
    }

    public static String htmlStringFormat(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = text.replace(" ", "&nbsp;");
        text = text.replace("\"", "&quot;");
        text = text.replace("'", "&apos;");
        return text.replace("\n", "<br/>");
    }

    public static boolean varCheckEmp(String s) {
        boolean b = false;
        if (s == null || "".equals(s.trim())) {
            b = true;
        }
        return b;
    }

    public static String varFormat(String s) {
        if (s == null || "".equals(s.trim())) {
            s = "";
        }
        return s;
    }

    public static String varFormat1(String s) {
        if (s == null || "".equals(s.trim())) {
            s = "\u3000";
        }
        return s;
    }

    public static String varTrim(String s) {
        s = s == null ? "" : s.trim();
        return s;
    }

    public static void writeUtf8Text(HttpServletResponse response, String text) {
        response.setContentType("html/text;charset=utf-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        try {
            response.getWriter().write(text);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeUtf8Text1(HttpServletResponse response, String text) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Expires", "0");
        response.setContentType("text/html;charset=UTF-8");
        try {
            response.getWriter().write(text);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public static void writeUtf8JSON(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(text);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public static String getRequestParam(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)request.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String s = "";
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return sb.toString();
    }

    public static Map<String, String> getRequestKeyValue(String param) {
        HashMap<String, String> map = new HashMap<String, String>(50);
        if (StringUtils.isNotBlank((CharSequence)param)) {
            String[] keyAndValues;
            for (String keyAndValue : keyAndValues = param.split("&")) {
                String[] kv = keyAndValue.split("=");
                if (kv.length != 2) continue;
                map.put(kv[0], kv[1]);
            }
        }
        return map;
    }

    public static String getWeek(Date date) {
        String week = "";
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        if (cal.get(7) == 1) {
            week = "\u65e5";
        } else if (cal.get(7) == 2) {
            week = "\u4e00";
        } else if (cal.get(7) == 3) {
            week = "\u4e8c";
        } else if (cal.get(7) == 4) {
            week = "\u4e09";
        } else if (cal.get(7) == 5) {
            week = "\u56db";
        } else if (cal.get(7) == 6) {
            week = "\u4e94";
        } else if (cal.get(7) == 7) {
            week = "\u516d";
        }
        return week;
    }

    public static String getRemortIP(HttpServletRequest request) {
        if (request.getHeader("x-forwarded-for") == null) {
            return request.getRemoteAddr();
        }
        return request.getHeader("x-forwarded-for");
    }

    public static String toJsonStr(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonGenerationException e) {
            log.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return "";
    }

    public static <T> T readValue(String context, Class<T> valueType) {
        try {
            return (T)mapper.readValue(context, valueType);
        }
        catch (JsonParseException e) {
            log.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static <T> T readValue(String context, Class<?> collectionClass, Class<?> ... elementCLasses) {
        try {
            return (T)mapper.readValue(context, Util.getCollectionJavaType(collectionClass, elementCLasses));
        }
        catch (Exception e) {
            log.error("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        String str = "{\"jsonrpc\": \"2.0\", \"id\": null, \"result\": {\"jsonrpc\": \"2.0\", \"params\": [{\"event\": \"user.login\", \"message\": {\"sn\": \"27b6b37852388d73717936b3\", \"port\": 39721, \"ip\": \"20.51.0.18\", \"dn\": \"C=cn, O=xdja, OU=tf, CN=78646a6178646a613252563337165545\", \"protocol\": \"TLSv1.0\", \"cipher\": \"TLS_RSA_WITH_SM4_CBC_SHA\", \"mode\": \"tunnel\", \"virtual-ip\": \"33.0.128.252\"}}], \"method\": \"notify\"}}";
        System.out.println(Util.readValue(str, Map.class));
    }

    private static JavaType getCollectionJavaType(Class<?> collectionClass, Class<?> ... elementCLasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementCLasses);
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProFile(String key) {
        String[] fireURLList = null;
        Properties prop = new Properties();
        InputStream in = SafeFilters.class.getResourceAsStream("/safe_filters.properties");
        try {
            prop.load(in);
            String fireURL = prop.getProperty(key);
            fireURLList = fireURL != null ? fireURL.split(";") : new String[]{};
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return fireURLList;
    }

    public boolean checkFilterUrl(String url, String filterName) {
        String[] fireURLList = this.getProFile(filterName);
        for (int i = 0; i < fireURLList.length; ++i) {
            if (!url.contains(fireURLList[i])) continue;
            return true;
        }
        return false;
    }

    public static String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder("");
        if (list != null && list.size() > 0) {
            for (String str : list) {
                sb.append("'" + str + "'").append(",");
            }
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public static String lrTrim(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str.replaceAll(" ", "");
    }

    public static String cvNameByPersonType(String name, String personType) {
        String abb = Util.getPersonTypeAbbreviation(personType);
        if ("".equals(abb)) {
            return name;
        }
        return name + "(" + abb + ")";
    }

    public static String getPersonTypeAbbreviation(String personType) {
        String abb = "";
        if ("2".equals(personType)) {
            abb = "\u534f";
        }
        if ("3".equals(personType)) {
            abb = "\u975e";
        }
        return abb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigFile(String key) {
        String value = null;
        if (!ConfigSet.isEmpty()) {
            value = ConfigSet.get((String)key);
            return value;
        }
        Properties prop = new Properties();
        InputStream in = Util.class.getResourceAsStream("/conf.properties");
        try {
            prop.load(in);
            for (Object o : prop.keySet()) {
                value = prop.getProperty((String)o);
                ConfigSet.set((String)((String)o), (String)value);
            }
            value = ConfigSet.get((String)key);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return value;
    }
}

