/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.crewaddressbook.bean;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pams.function.xatl.crewaddressbook.bean.ZhandianBean;

public class PhoneBean {
    private int railBookId;
    private String phone;
    private String description;

    public int getRailBookId() {
        return this.railBookId;
    }

    public void setRailBookId(int railBookId) {
        this.railBookId = railBookId;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PhoneBean(int railBookId, String phone, String description) {
        this.railBookId = railBookId;
        this.phone = phone;
        this.description = description;
    }

    public PhoneBean() {
    }

    public static void parseStr(ZhandianBean zhandianBean, String type, String str) {
        ArrayList<PhoneBean> rtn = new ArrayList<PhoneBean>();
        String location = "";
        if (StringUtils.isBlank((String)str.trim()) || "\u2014\u2014".equalsIgnoreCase(str.trim())) {
            PhoneBean bean = new PhoneBean();
            bean.setRailBookId(zhandianBean.getId());
            rtn.add(bean);
        } else {
            String[] phoneStrList;
            for (String phoneStr : phoneStrList = str.split("\n")) {
                if (StringUtils.isBlank((String)phoneStr) || StringUtils.contains((String)phoneStr, (String)"\u2014")) continue;
                if (phoneStr.contains(" ") && !phoneStr.matches("^[\\u4e00-\\u9fa5].*$")) {
                    String[] strs;
                    for (String onePhone : strs = phoneStr.split(" ")) {
                        location = PhoneBean.dealOnenPhone(zhandianBean, rtn, location, onePhone);
                    }
                    continue;
                }
                location = PhoneBean.dealOnenPhone(zhandianBean, rtn, location, phoneStr);
            }
            if ("1".equalsIgnoreCase(type)) {
                zhandianBean.setStationLocation(location);
                zhandianBean.setStationPhoneList(rtn);
            } else {
                zhandianBean.setPositionLocation(location);
                zhandianBean.setPositionPhoneList(rtn);
            }
        }
    }

    private static String dealOnenPhone(ZhandianBean zhandianBean, List<PhoneBean> rtn, String location, String phoneStr) {
        if (phoneStr.matches("[\\u4e00-\\u9fa5]+")) {
            location = phoneStr;
        } else if (phoneStr.matches("^[\\u4e00-\\u9fa5].*$")) {
            String[] strings = PhoneBean.splitChineseAndNum(phoneStr);
            location = strings[0];
            phoneStr = strings[1];
        }
        if (!StringUtils.isAlphaSpace((String)phoneStr)) {
            String phone = phoneStr.trim();
            if (phone.contains(" ")) {
                String[] s = phoneStr.split("  ");
                for (int i = 0; i < s.length; ++i) {
                    if (!StringUtils.isNotBlank((String)s[i])) continue;
                    if (s[i].matches("[\\u4e00-\\u9fa5]+")) {
                        location = s[i];
                        continue;
                    }
                    PhoneBean bean = PhoneBean.dealPhoneString(zhandianBean, s[i]);
                    if (!StringUtils.isNotBlank((String)bean.getPhone())) continue;
                    rtn.add(bean);
                }
            } else {
                PhoneBean bean = PhoneBean.dealPhoneString(zhandianBean, phoneStr);
                if (StringUtils.isNotBlank((String)bean.getPhone())) {
                    rtn.add(bean);
                }
            }
        }
        return location;
    }

    private static PhoneBean dealPhoneString(ZhandianBean zhandianBean, String phoneStr) {
        PhoneBean bean = new PhoneBean();
        String[] splitTemp = phoneStr.split("\uff08");
        splitTemp[0] = splitTemp[0].replaceAll("\u8f6c", "-");
        bean.setPhone(splitTemp[0]);
        bean.setRailBookId(zhandianBean.getId());
        if (splitTemp.length > 1) {
            bean.setDescription("\uff08" + splitTemp[1]);
        } else {
            bean.setDescription("");
        }
        return bean;
    }

    public String toString() {
        return "PhoneBean{phone='" + this.phone + '\'' + ", description='" + this.description + '\'' + '}';
    }

    private static String[] splitChineseAndNum(String str) {
        char[] chars = str.trim().toCharArray();
        StringBuffer chinese = new StringBuffer();
        String num = "";
        for (int i = 0; i < chars.length; ++i) {
            String s = String.valueOf(chars[i]);
            if (!s.matches("[\\u4e00-\\u9fa5]+")) {
                num = str.substring(i);
                break;
            }
            chinese.append(s);
        }
        return new String[]{chinese.toString(), num};
    }
}

