/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.crewaddressbook.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.crewaddressbook.bean.CrewAddressBookParam;
import pams.function.xatl.crewaddressbook.bean.PhoneBean;
import pams.function.xatl.crewaddressbook.bean.ResultCode;
import pams.function.xatl.crewaddressbook.service.CrewAddressBookService;

@Controller
@Scope(value="session")
public class CrewAddressBookControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(CrewAddressBookControl.class);
    @Autowired
    CrewAddressBookService crewAddressBookService;
    @Autowired
    private ResourceBundleMessageSource resourceBundleMessageSource;

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/uploadExcle.do"})
    public void uploadExcle(@RequestParam MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        ResultCode resultCode = this.crewAddressBookService.updownExcel(file);
        mapBean.put("code", resultCode.getCode());
        mapBean.put("tips", resultCode.getTips());
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/toImportExcel.do"})
    public String toImport(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "crewAddressBook/default/import";
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/getTree.do"})
    public void getTree(String id, HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        JSONArray list = null;
        HashMap<String, JSONArray> mapBean = new HashMap<String, JSONArray>(4);
        try {
            list = null == id || StringUtils.isBlank((String)id) ? this.crewAddressBookService.getTreeList() : this.crewAddressBookService.getFangxiangById(Integer.valueOf(id));
            mapBean.put("tree", list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)list));
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/getZhandianList.do"})
    public void getZhandianList(HttpServletRequest request, HttpServletResponse response, ModelMap map, CrewAddressBookParam param) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            if (null != param.getRootId() || null != param.getName() || null != param.getId()) {
                int id = 0;
                int rootId = 0;
                if (null != param.getRootId()) {
                    rootId = Integer.valueOf(param.getRootId());
                }
                if (null != param.getId()) {
                    id = Integer.valueOf(param.getId());
                }
                List zhandianList = this.crewAddressBookService.getZhandianList(id, rootId, param.getName());
                List<Object> list = this.getObjectListByPage(param, zhandianList);
                mapBean.put("rows", list);
                mapBean.put("total", zhandianList.size());
            } else {
                mapBean.put("rows", Collections.EMPTY_LIST);
                mapBean.put("total", 0);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    private List<Object> getObjectListByPage(CrewAddressBookParam param, List list) {
        int page = param.getPage();
        int rows = param.getRows();
        if (page <= 0) {
            page = 1;
        }
        if (rows <= 0) {
            rows = 15;
        }
        int length = list.size();
        int startIndex = (page - 1) * rows;
        int endIndex = page * rows;
        if (endIndex > length) {
            if (startIndex == 0) {
                return list;
            }
            endIndex = length;
        }
        return list.subList(startIndex, endIndex);
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/getAllTree.do"})
    public void getAllTree(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        HashMap<String, List> mapBean = new HashMap<String, List>(4);
        try {
            List allTree = this.crewAddressBookService.getAllTree();
            mapBean.put("tree", allTree);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/toDetail.do"})
    public String toDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String type) {
        String sendUrl = "error/error";
        try {
            Integer id1 = Integer.valueOf(id);
            JSONObject list = this.crewAddressBookService.getPhoneListById(id1);
            String path = this.crewAddressBookService.getZhanPath(id1);
            map.put((Object)"data", (Object)list);
            map.put((Object)"path", (Object)path);
            sendUrl = type.equalsIgnoreCase("1") ? (id.startsWith("1") || id.startsWith("4") ? "crewAddressBook/default/highdetail" : "crewAddressBook/default/otherdetail") : (id.startsWith("1") || id.startsWith("4") ? "crewAddressBook/default/editHighdetail" : "crewAddressBook/default/editOtherdetail");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/crewAddressBook/crewAddressBookControl/updatePhoneList.do"})
    public void updatePhoneList(HttpServletRequest request, HttpServletResponse response, ModelMap map, @RequestBody String phoneListBean) {
        HashMap<String, Integer> mapBean = new HashMap<String, Integer>(4);
        try {
            JSONObject json = JSONObject.parseObject((String)phoneListBean);
            int id = json.getInteger("id");
            JSONArray stationArr = json.getJSONArray("stationList");
            JSONArray positionArr = json.getJSONArray("positionList");
            List stationList = stationArr.toJavaList(PhoneBean.class);
            List positionList = positionArr.toJavaList(PhoneBean.class);
            if (id != 0) {
                ResultCode resultCode = this.crewAddressBookService.updatePhoneList(id, stationList, positionList);
                mapBean.put("data", resultCode.getCode());
            } else {
                mapBean.put("data", ResultCode.UPDATEFAIL.getCode());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }
}

