/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.crewaddressbook.service.serviceimpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.crewaddressbook.bean.FangxiangBean;
import pams.function.xatl.crewaddressbook.bean.PhoneBean;
import pams.function.xatl.crewaddressbook.bean.RailWayBook;
import pams.function.xatl.crewaddressbook.bean.ResultCode;
import pams.function.xatl.crewaddressbook.bean.XianLuBean;
import pams.function.xatl.crewaddressbook.service.CrewAddressBookService;
import pams.function.xatl.crewaddressbook.util.ResolveExcel;
import pams.function.xatl.datacollection.service.JDBCSessionService;
import pams.function.xatl.util.JDBCSession;

@Service
public class CrewAddressBookServiceImp
implements CrewAddressBookService {
    @Autowired
    JDBCSessionService jdbcSessionService;
    private static final Logger log = LoggerFactory.getLogger(CrewAddressBookServiceImp.class);

    @Override
    public ResultCode updateFangxiangInfo(List<FangxiangBean> fangxiangList) {
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.insertFangxiang(fangxiangList);
    }

    @Override
    public ResultCode updownExcel(MultipartFile file) {
        ArrayList<FangxiangBean> fangxiangList = new ArrayList<FangxiangBean>(64);
        try {
            ResultCode resultCode;
            FileInputStream inputStream = (FileInputStream)file.getInputStream();
            String name = file.getOriginalFilename();
            if ("\u9ad8\u94c1\u5217\u8f66\u6cbf\u9014\u5404\u7ad9\u8054\u7cfb\u7535\u8bdd.xls".equalsIgnoreCase(name)) {
                resultCode = ResolveExcel.resovelHighSpeedRailwayEmuTrai(inputStream, fangxiangList, 100);
            } else if ("\u5b89\u5eb7\u4e58\u8b66\u6cbf\u9014\u8f66\u7ad9\u53ca\u96b6\u5c5e\u6307\u6325\u4e2d\u5fc3\u8054\u7cfb\u65b9\u5f0f.xls".equalsIgnoreCase(name)) {
                resultCode = ResolveExcel.resovelHighSpeedRailwayEmuTrai(inputStream, fangxiangList, 400);
            } else if ("\u6cbf\u7ebf\u6d3e\u51fa\u6240\u8054\u7cfb\u7535\u8bdd.xls".equalsIgnoreCase(name)) {
                resultCode = ResolveExcel.resolvePoliceStations(inputStream, fangxiangList, 200);
            } else if ("\u5b9d\u9e21\u4e58\u8b66\u652f\u961f\u5c31\u8fd1\u62a5\u8b66\u901a\u8baf\u8054\u7cfb\u8868.xls".equalsIgnoreCase(name)) {
                resultCode = ResolveExcel.resolveBaojiRidingPolice(inputStream, fangxiangList, 300);
            } else {
                return ResultCode.NAMEFAIL;
            }
            if (resultCode.getCode() == 402) {
                return resultCode;
            }
            return this.updateFangxiangInfo(fangxiangList);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultCode.READFAIL;
        }
    }

    @Override
    public JSONArray getTreeList() {
        RailWayBook[] railWayBooks = RailWayBook.values();
        JSONArray jsonArray = new JSONArray();
        for (RailWayBook book : railWayBooks) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)book.getCode());
            json.put("text", (Object)book.getName());
            json.put("children", (Object)Collections.EMPTY_LIST);
            json.put("attributes", (Object)Collections.EMPTY_LIST);
            json.put("state", (Object)"closed");
            jsonArray.add((Object)json);
        }
        return jsonArray;
    }

    @Override
    public List getZhandianList(int parentId, int rootId, String name) {
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT  rd.*, rp.`type`, GROUP_CONCAT(rp.phone) as phones, GROUP_CONCAT(rp.`discription`) as discriptions FROM `rail_directory` rd left join  `rail_phone` rp  on rd.id = rp.`rail_book_id` WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((String)name)) {
            sb.append(" and rd.name like  '%" + name + "%' ");
        }
        if (rootId != 0) {
            sb.append(" AND id IN (SELECT id FROM `rail_directory` WHERE parent_id in ( (SELECT id FROM `rail_directory` WHERE parent_id = " + rootId + ")) ) ");
        }
        if (parentId != 0) {
            sb.append(" AND id IN (SELECT id FROM `rail_directory` WHERE parent_id = " + parentId + " ) ");
        }
        sb.append(" GROUP BY rp.`rail_book_id`,rp.`type`  ");
        return jdbcSession.getZhandianByParentId(sb.toString());
    }

    @Override
    public JSONArray getFangxiangById(int parentId) {
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.getFangxiangJsonArray(parentId);
    }

    @Override
    public List getAllTree() {
        String sql = "SELECT t.*,rd1.name  as fangxiangName, rd1.`parent_id` pId FROM  (SELECT  rd.*, rp.`type`, GROUP_CONCAT(rp.phone) as phones, GROUP_CONCAT(rp.`discription`) as discriptions FROM `rail_directory` rd, `rail_phone` rp WHERE rd.id = rp.`rail_book_id` AND id IN (SELECT id FROM `rail_directory`) GROUP BY rp.`rail_book_id`,rp.`type`) AS t LEFT JOIN `rail_directory` rd1 ON t.parent_id = rd1.`id`";
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        Map<Integer, XianLuBean> fangxiang = jdbcSession.getFangxiang(sql);
        return new ArrayList<XianLuBean>(fangxiang.values());
    }

    @Override
    public JSONObject getPhoneListById(int id) {
        String sql = "SELECT  rp.`rail_book_id` as id,  rp.type, GROUP_CONCAT(rp.phone) AS phones, GROUP_CONCAT(rp.`discription`) AS discriptions FROM   `rail_phone` rp WHERE rp.`rail_book_id` = ?   GROUP BY rp.`rail_book_id`,rp.`type`";
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        JSONObject object = jdbcSession.getPhoneListById(sql, id);
        return object;
    }

    @Override
    public ResultCode updatePhoneList(int id, List<PhoneBean> stationPhoneList, List<PhoneBean> positionPhoneList) {
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.updatePhoneList(id, stationPhoneList, positionPhoneList);
    }

    @Override
    public String getZhanPath(int id) {
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.getZhanPath(id);
    }
}

