/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.crewaddressbook.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static String toJsonStr(Object value) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            mapper.setDateFormat((DateFormat)dateFormat);
            return mapper.writeValueAsString(value);
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6362\u5bf9\u8c61\u4e3aJSON\u5b57\u7b26\u4e32\u5f02\u5e38");
            return "";
        }
    }

    public static <T> T readValue(String context, Class<T> valueType) {
        try {
            return (T)mapper.readValue(context, valueType);
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38");
            return null;
        }
    }

    public static <T> T readValue(String context, Class<?> collectionClass, Class<?> ... elementCLasses) {
        try {
            return (T)mapper.readValue(context, JsonUtils.getCollectionJavaType(collectionClass, elementCLasses));
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38");
            return null;
        }
    }

    public static <T> T readValue(String content, TypeReference valueTypeRef) {
        try {
            return (T)mapper.readValue(content, valueTypeRef);
        }
        catch (IOException e) {
            System.out.println("\u8f6c\u5316json\u5b57\u7b26\u4e32\u4e3a\u5bf9\u8c61\u5f02\u5e38");
            return null;
        }
    }

    private static JavaType getCollectionJavaType(Class<?> collectionClass, Class<?> ... elementCLasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementCLasses);
    }

    public static JsonNode readTree(String jsonStr) throws JsonProcessingException, IOException {
        return mapper.readTree(jsonStr);
    }

    public static <T> T readValue(JsonNode node, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(node, clazz);
    }

    static {
        mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

