/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.crewaddressbook.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import pams.function.xatl.crewaddressbook.bean.FangxiangBean;
import pams.function.xatl.crewaddressbook.bean.PhoneBean;
import pams.function.xatl.crewaddressbook.bean.ResultCode;
import pams.function.xatl.crewaddressbook.bean.ZhandianBean;

public class ResolveExcel {
    public static ResultCode resolveBaojiRidingPolice(FileInputStream file, List<FangxiangBean> fangxiangList, int id) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)file);
            Sheet sheet = workbook.getSheetAt(0);
            List<CellRangeAddress> cellList = ResolveExcel.getCombineCell(sheet);
            int lastRowNum = sheet.getLastRowNum();
            String lastFangxiangName = "";
            int fangxiangNum = 1;
            int fangxiangId = 1;
            FangxiangBean fangxiangBean = null;
            int zhandianNum = 1;
            int rowIndex = 2;
            while (rowIndex < lastRowNum) {
                ArrayList<PhoneBean> list;
                PhoneBean phoneBean;
                Cell cell;
                Row row;
                if ((row = sheet.getRow(rowIndex++)) == null || (cell = row.getCell(0)) == null) continue;
                String combineValues = ResolveExcel.isCombineCell(cellList, cell, sheet);
                if (StringUtils.isNotBlank((String)combineValues) && !combineValues.equalsIgnoreCase(lastFangxiangName)) {
                    lastFangxiangName = combineValues;
                    fangxiangBean = new FangxiangBean();
                    fangxiangId = id + fangxiangNum++;
                    fangxiangBean.setId(fangxiangId);
                    fangxiangBean.setParentId(id);
                    fangxiangBean.setName(lastFangxiangName);
                    fangxiangList.add(fangxiangBean);
                    zhandianNum = 1;
                }
                ZhandianBean zhandianBean = new ZhandianBean();
                zhandianBean.setParentId(fangxiangId);
                zhandianBean.setId(fangxiangId * 100 + zhandianNum++);
                Cell nameCell = row.getCell(1);
                if (nameCell != null && nameCell.getCellType() != 3) {
                    zhandianBean.setName(nameCell.getStringCellValue());
                }
                if ((cell = row.getCell(3)) != null && cell.getCellType() != 3) {
                    phoneBean = new PhoneBean();
                    phoneBean.setRailBookId(zhandianBean.getId());
                    phoneBean.setPhone(cell.getStringCellValue());
                    list = new ArrayList<PhoneBean>();
                    list.add(phoneBean);
                    zhandianBean.setStationPhoneList(list);
                }
                if ((cell = (row = sheet.getRow(rowIndex++)).getCell(3)) != null && cell.getCellType() != 3) {
                    phoneBean = new PhoneBean();
                    phoneBean.setPhone(cell.getStringCellValue());
                    phoneBean.setRailBookId(zhandianBean.getId());
                    list = new ArrayList();
                    list.add(phoneBean);
                    zhandianBean.setPositionPhoneList(list);
                }
                fangxiangBean.getChildren().add(zhandianBean);
            }
            return ResultCode.SUCCESS;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultCode.FORMATFAIL;
        }
    }

    public static ResultCode resolvePoliceStations(FileInputStream file, List<FangxiangBean> fangxiangList, int id) {
        try {
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)file);
            int numberOfSheets = workbook.getNumberOfSheets();
            int fangxiangNum = 1;
            int fangxiangId = 0;
            int zhandianNum = 1;
            FangxiangBean fangxiangBean = null;
            for (int sheetIndex = 1; sheetIndex <= numberOfSheets; ++sheetIndex) {
                Sheet sheet = workbook.getSheetAt(sheetIndex - 1);
                List<CellRangeAddress> cellList = ResolveExcel.getCombineCell(sheet);
                int lastRowNum = sheet.getLastRowNum();
                String[] fangxiangNames = null;
                int fangxiangNamesIndex = 0;
                for (int rowNum = 0; rowNum <= lastRowNum; ++rowNum) {
                    Cell cell2;
                    Cell cell1;
                    Cell cell;
                    Row row = sheet.getRow(rowNum);
                    if (row == null || (cell = row.getCell(0)) == null || cell.getCellType() == 3) continue;
                    String combineValues = ResolveExcel.isCombineCell(cellList, cell, sheet);
                    if (StringUtils.isNotBlank((String)combineValues)) {
                        if (combineValues.endsWith("\u6b21")) {
                            if (combineValues.contains("    ")) {
                                String[] s = combineValues.split("    ");
                                if (s.length <= 1) continue;
                                fangxiangNames = s;
                                fangxiangNamesIndex = 0;
                                continue;
                            }
                            fangxiangBean = new FangxiangBean();
                            zhandianNum = 1;
                            fangxiangId = id + fangxiangNum++;
                            fangxiangBean.setId(fangxiangId);
                            fangxiangBean.setParentId(id);
                            fangxiangBean.setName(combineValues);
                            fangxiangList.add(fangxiangBean);
                            continue;
                        }
                        if (fangxiangNames == null || fangxiangNames.length <= 0 || !combineValues.equalsIgnoreCase("\u7ad9 \u540d")) continue;
                        fangxiangBean = new FangxiangBean();
                        zhandianNum = 1;
                        fangxiangId = id + fangxiangNum++;
                        fangxiangBean.setId(fangxiangId);
                        fangxiangBean.setParentId(id);
                        fangxiangBean.setName(fangxiangNames[fangxiangNamesIndex++]);
                        fangxiangList.add(fangxiangBean);
                        if (fangxiangNamesIndex != fangxiangNames.length) continue;
                        fangxiangNames = null;
                        fangxiangNamesIndex = 0;
                        continue;
                    }
                    ZhandianBean zhandianBean = new ZhandianBean();
                    zhandianBean.setId(fangxiangId * 100 + zhandianNum++);
                    zhandianBean.setParentId(fangxiangId);
                    Cell nameCell = row.getCell(0);
                    if (nameCell != null) {
                        zhandianBean.setName(nameCell.getStringCellValue());
                    }
                    if ((cell1 = row.getCell(1)) != null) {
                        PhoneBean phoneBean = new PhoneBean();
                        phoneBean.setPhone(cell1.getStringCellValue());
                        phoneBean.setRailBookId(zhandianBean.getId());
                        ArrayList<PhoneBean> list = new ArrayList<PhoneBean>();
                        list.add(phoneBean);
                        zhandianBean.setStationPhoneList(list);
                    }
                    if ((cell2 = row.getCell(2)) != null) {
                        PhoneBean phoneBean = new PhoneBean();
                        phoneBean.setPhone(cell2.getStringCellValue());
                        phoneBean.setRailBookId(zhandianBean.getId());
                        ArrayList<PhoneBean> list = new ArrayList<PhoneBean>();
                        list.add(phoneBean);
                        zhandianBean.setPositionPhoneList(list);
                    }
                    if (zhandianBean.getName() == null) continue;
                    fangxiangBean.getChildren().add(zhandianBean);
                }
            }
            return ResultCode.SUCCESS;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultCode.FORMATFAIL;
        }
    }

    public static ResultCode resovelHighSpeedRailwayEmuTrai(FileInputStream file, List<FangxiangBean> fangxiangList, int id) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook((InputStream)file);
            int numberOfSheets = workbook.getNumberOfSheets();
            for (int sheetIndex = 1; sheetIndex <= numberOfSheets; ++sheetIndex) {
                Sheet sheet = workbook.getSheetAt(sheetIndex - 1);
                String sheetName = sheet.getSheetName();
                List<CellRangeAddress> cellList = ResolveExcel.getCombineCell(sheet);
                if (sheetIndex <= 0) continue;
                FangxiangBean fangxiangBean = new FangxiangBean();
                int fangxianIndex = id + sheetIndex;
                fangxiangBean.setId(fangxianIndex);
                fangxiangBean.setName(sheetName);
                fangxiangBean.setParentId(id);
                fangxiangList.add(fangxiangBean);
                int rowIndex = 2;
                Row row = sheet.getRow(rowIndex++);
                int seqValue = 0;
                Cell cell = row.getCell(0);
                while (null != row && cell.getCellType() != 3) {
                    ZhandianBean zhandianBean = new ZhandianBean();
                    zhandianBean.setId(fangxianIndex * 100 + ++seqValue);
                    zhandianBean.setParentId(fangxianIndex);
                    Cell nameCell = row.getCell(1);
                    zhandianBean.setName(nameCell.getStringCellValue());
                    Cell stationPhoneCell = row.getCell(2);
                    String stationPhoneStr = ResolveExcel.isCombineCell(cellList, stationPhoneCell, sheet);
                    if (StringUtils.isBlank((String)stationPhoneStr)) {
                        stationPhoneStr = stationPhoneCell.getStringCellValue();
                    }
                    PhoneBean.parseStr(zhandianBean, "1", stationPhoneStr);
                    Cell positionPhoneCell = row.getCell(3);
                    String positionPhoneStr = ResolveExcel.isCombineCell(cellList, positionPhoneCell, sheet);
                    if (StringUtils.isBlank((String)positionPhoneStr)) {
                        positionPhoneStr = positionPhoneCell.getStringCellValue();
                    }
                    PhoneBean.parseStr(zhandianBean, "2", positionPhoneStr);
                    fangxiangBean.getChildren().add(zhandianBean);
                    if ((row = sheet.getRow(rowIndex++)) == null) continue;
                    cell = row.getCell(0);
                }
            }
            return ResultCode.SUCCESS;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultCode.FORMATFAIL;
        }
    }

    public static List<CellRangeAddress> getCombineCell(Sheet sheet) {
        ArrayList<CellRangeAddress> list = new ArrayList<CellRangeAddress>();
        int sheetmergerCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetmergerCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            list.add(ca);
        }
        return list;
    }

    public static String isCombineCell(List<CellRangeAddress> listCombineCell, Cell cell, Sheet sheet) {
        int firstC = 0;
        int lastC = 0;
        int firstR = 0;
        int lastR = 0;
        String cellValue = null;
        for (CellRangeAddress ca : listCombineCell) {
            firstC = ca.getFirstColumn();
            lastC = ca.getLastColumn();
            firstR = ca.getFirstRow();
            lastR = ca.getLastRow();
            if (cell.getRowIndex() >= firstR && cell.getRowIndex() <= lastR) {
                if (cell.getColumnIndex() < firstC || cell.getColumnIndex() > lastC) continue;
                Row fRow = sheet.getRow(firstR);
                Cell fCell = fRow.getCell(firstC);
                cellValue = ResolveExcel.getCellValue(fCell);
                break;
            }
            cellValue = "";
        }
        return cellValue;
    }

    public static String getCellValue(Cell cell) {
        return cell == null ? "" : cell.getStringCellValue();
    }
}

