/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.datacollection.control;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.datacollection.bean.DataCollectionCaseInfo;
import pams.function.xatl.datacollection.bean.DataCollectionParams;
import pams.function.xatl.datacollection.bean.DataCollectionPersonInfo;
import pams.function.xatl.datacollection.bean.DataCollectionVehicleInfo;
import pams.function.xatl.datacollection.service.DataCollectionService;

@Controller
@Scope(value="session")
public class DataCollectionControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DataCollectionControl.class);
    @Autowired
    private ResourceBundleMessageSource resourceBundleMessageSource;
    @Autowired
    DataCollectionService dataCollectionService;

    @RequestMapping(value={"/dataCollection/dataCollectionControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/queryPersonInfo.do"})
    public void queryPersonInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            List<DataCollectionPersonInfo> personInfoList = this.dataCollectionService.queryPerSonInfo(dataCollectionParams, false);
            Long total = this.dataCollectionService.queryPerSonInfoCount(dataCollectionParams);
            mapBean.put("rows", personInfoList);
            mapBean.put("total", total);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/exportInfo.do"})
    public void exportInfo(HttpServletRequest request, HttpServletResponse response, String ids, String startDate, String endDate) {
        HSSFWorkbook wb = new HSSFWorkbook();
        DataCollectionParams dataCollectionParams = this.getDataCollectionParams(ids, startDate, endDate);
        String fileName = this.dataCollectionService.exportInfo(wb, dataCollectionParams);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.flush();
            wb.write((OutputStream)outputStream);
            log.debug("----Excle\u6587\u4ef6\u5df2\u751f\u6210------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DataCollectionParams getDataCollectionParams(String ids, String startDate, String endDate) {
        DataCollectionParams dataCollectionParams = new DataCollectionParams();
        dataCollectionParams.setPersonIds(Arrays.asList(ids.split(",")));
        dataCollectionParams.setStartTime(startDate);
        dataCollectionParams.setEndTime(endDate);
        return dataCollectionParams;
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/queryVehicleInfo.do"})
    public void queryVehicleInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            List<DataCollectionVehicleInfo> dataCollectionVehicleInfoList = this.dataCollectionService.queryVehicleInfo(dataCollectionParams, false);
            Long total = this.dataCollectionService.queryVehicleInfoCount(dataCollectionParams);
            mapBean.put("rows", dataCollectionVehicleInfoList);
            mapBean.put("total", total);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/queryVehicleDetailInfo.do"})
    public String queryVehicleDetailInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/queryCaseInfo.do"})
    public void queryCaseInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            List<DataCollectionCaseInfo> dataCollectionCaseInfo = this.dataCollectionService.queryCaseInfo(dataCollectionParams, false);
            Long total = this.dataCollectionService.queryCaseInfoCount(dataCollectionParams);
            mapBean.put("rows", dataCollectionCaseInfo);
            mapBean.put("total", total);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/queryCaseDetailInfo.do"})
    public String queryCaseDetailInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/toPersonDetailInfo.do"})
    public String toPersonDetailInfo(ModelMap map, String id, String id1) {
        String sendUrl = "error/error";
        try {
            Department dept = this.person.getDepartment();
            String parentId = dept.getParentID();
            String address = null != parentId ? dept.getParentDep().getName() : dept.getName();
            String url = "/dataCollection/dataCollection/default/map.html?address=" + URLEncoder.encode(address, "utf-8");
            log.debug(url);
            JSONObject detail = this.dataCollectionService.queryDetail(id, id1);
            map.put((Object)"mapUrl", (Object)url);
            map.put((Object)"data", (Object)detail);
            sendUrl = "dataCollection/dataCollection/default/toPersonDetailInfo";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/toVehicleDetailInfo.do"})
    public String toVehicleInfo(ModelMap map, String id, String id1) {
        String sendUrl = "error/error";
        try {
            Department dept = this.person.getDepartment();
            String parentId = dept.getParentID();
            String address = null != parentId ? dept.getParentDep().getName() : dept.getName();
            String url = "/dataCollection/dataCollection/default/map.html?address=" + URLEncoder.encode(address, "utf-8");
            log.debug(url);
            JSONObject detail = this.dataCollectionService.queryDetail(id, id1);
            map.put((Object)"mapUrl", (Object)url);
            map.put((Object)"data", (Object)detail);
            sendUrl = "dataCollection/dataCollection/default/toVehicleDetailInfo";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/dataCollection/dataCollectionControl/toCaseInfo.do"})
    public String toCaseInfo(ModelMap map, String id, String id1) {
        String sendUrl = "error/error";
        try {
            Department dept = this.person.getDepartment();
            String parentId = dept.getParentID();
            String address = null != parentId ? dept.getParentDep().getName() : dept.getName();
            String url = "/dataCollection/dataCollection/default/map.html?address=" + URLEncoder.encode(address, "utf-8");
            log.debug(url);
            JSONObject detail = this.dataCollectionService.queryDetail(id, id1);
            map.put((Object)"mapUrl", (Object)url);
            map.put((Object)"data", (Object)detail);
            sendUrl = "dataCollection/dataCollection/default/toCaseDetailInfo";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }
}

