/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.datacollection.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.datacollection.bean.DataCollectionParams;
import pams.function.xatl.datacollection.bean.DataStatisticsCaseInfo;
import pams.function.xatl.datacollection.bean.DataStatisticsDataInfo;
import pams.function.xatl.datacollection.bean.DataStatisticsPersonInfo;
import pams.function.xatl.datacollection.bean.DataStatisticsVehicleInfo;
import pams.function.xatl.datacollection.service.DataStatisticsService;

@Controller
@Scope(value="session")
public class DataStatisticsControl
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(DataStatisticsControl.class);
    @Autowired
    private ResourceBundleMessageSource resourceBundleMessageSource;
    @Autowired
    DataStatisticsService dataStatisticsService;

    @RequestMapping(value={"/dataCollection/dataStatisticsControl/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/dataCollection/dataStatisticsControl/dataSummary.do"})
    public void dataSummary(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            ArrayList<DataStatisticsDataInfo> list = this.dataStatisticsService.queryDataNumberInfo(dataCollectionParams, true);
            Collections.sort(list);
            List<Object> subList = this.getObjectListByPage(dataCollectionParams, list);
            mapBean.put("rows", subList);
            mapBean.put("total", list.size());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    private List<Object> getObjectListByPage(DataCollectionParams dataCollectionParams, List list) {
        int page = dataCollectionParams.getPage();
        int rows = dataCollectionParams.getRows();
        if (page <= 0) {
            page = 1;
        }
        if (rows <= 0) {
            rows = 15;
        }
        int length = list.size();
        int startIndex = (page - 1) * rows;
        int endIndex = page * rows;
        if (endIndex > length) {
            if (startIndex == 0) {
                return list;
            }
            endIndex = length;
        }
        return list.subList(startIndex, endIndex);
    }

    @RequestMapping(value={"/dataCollection/dataStatisticsControl/exportAllInfo.do"})
    public void exportDataSummary(HttpServletRequest request, HttpServletResponse response, String ids, String startDate, String endDate) {
        HSSFWorkbook wb = new HSSFWorkbook();
        DataCollectionParams dataCollectionParams = this.getDataCollectionParams(ids, startDate, endDate);
        String fileName = this.dataStatisticsService.exportAllInfo(wb, dataCollectionParams);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.flush();
            wb.write((OutputStream)outputStream);
            log.debug("----Excle\u6587\u4ef6\u5df2\u751f\u6210------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/dataCollection/dataStatisticsControl/personSummary.do"})
    public void personSummary(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            List<DataStatisticsPersonInfo> dataStatisticsPersonInfos = this.dataStatisticsService.queryPersonNumberInfo(dataCollectionParams, false);
            Collections.sort(dataStatisticsPersonInfos);
            List<Object> subList = this.getObjectListByPage(dataCollectionParams, dataStatisticsPersonInfos);
            mapBean.put("rows", subList);
            mapBean.put("total", dataStatisticsPersonInfos.size());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/dataCollection/dataStatisticsControl/vehicleSummary.do"})
    public void vehicleSummary(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            ArrayList<DataStatisticsVehicleInfo> list = this.dataStatisticsService.queryVehicleNumberInfo(dataCollectionParams, false);
            Collections.sort(list);
            List<Object> subList = this.getObjectListByPage(dataCollectionParams, list);
            mapBean.put("rows", subList);
            mapBean.put("total", list.size());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    @RequestMapping(value={"/dataCollection/dataStatisticsControl/caseSummary.do"})
    public void caseSummary(HttpServletRequest request, HttpServletResponse response, ModelMap map, DataCollectionParams dataCollectionParams) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>(4);
        try {
            ArrayList<DataStatisticsCaseInfo> infos = this.dataStatisticsService.queryCaseNumberInfo(dataCollectionParams, false);
            Collections.sort(infos);
            List<Object> subList = this.getObjectListByPage(dataCollectionParams, infos);
            mapBean.put("rows", subList);
            mapBean.put("total", infos.size());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(mapBean));
    }

    private DataCollectionParams getDataCollectionParams(String ids, String startDate, String endDate) {
        DataCollectionParams dataCollectionParams = new DataCollectionParams();
        dataCollectionParams.setPersonIds(Arrays.asList(ids.split(",")));
        dataCollectionParams.setStartTime(startDate);
        dataCollectionParams.setEndTime(endDate);
        return dataCollectionParams;
    }
}

