/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.datacollection.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Person;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.datacollection.bean.AttachmentBean;
import pams.function.xatl.datacollection.bean.DataCollectionCaseDetail;
import pams.function.xatl.datacollection.bean.DataCollectionCaseInfo;
import pams.function.xatl.datacollection.bean.DataCollectionParams;
import pams.function.xatl.datacollection.bean.DataCollectionPersonDetail;
import pams.function.xatl.datacollection.bean.DataCollectionPersonInfo;
import pams.function.xatl.datacollection.bean.DataCollectionVehicleDetail;
import pams.function.xatl.datacollection.bean.DataCollectionVehicleInfo;
import pams.function.xatl.datacollection.service.DataCollectionService;
import pams.function.xatl.datacollection.service.JDBCSessionService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.util.ExportExcelUtil;
import pams.function.xatl.util.JDBCSession;

@Service
public class DataCollectionServiceImpl
implements DataCollectionService {
    @Autowired
    JDBCSessionService jdbcSessionService;
    @Resource
    PersonDao personDao;
    @Resource
    private FastDFSClientService fastDFSClientService;

    @Override
    public List<DataCollectionPersonInfo> queryPerSonInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        List<DataCollectionPersonInfo> resultList = null;
        HashMap<String, Person> personMap = new HashMap<String, Person>(32);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ap.id as id,  DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime, c.name AS collectReason ,ap.name,   c1.name  AS sex , ap.identity AS identity,CONCAT(IFNULL(ap.origin_province,''),IFNULL(ap.origin_city,''),IFNULL(ap.origin_country,''),IFNULL(ap.origin_street,'')) AS originAddress,ap.origin_street as originAddressDetail,  ap.contact_phone AS contactPhone, ap.collect_id as collectId,  g.collecter_id as collecterId FROM t_collect_associated_person ap LEFT JOIN t_collect_general g  ON ap.collect_id = g.id  ");
            sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
            sb.append(" LEFT JOIN t_commoncode c1 on c1.code = ap.sex  ");
            sb.append(" where 1 = 1  ");
            if (isExportExcel) {
                this.addCommonConditionForSql(dataCollectionParams, sb);
            } else {
                this.addConditionForSql(dataCollectionParams, sb);
            }
            JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
            resultList = jdbcSession.findMoreRefResult(sb.toString(), null, DataCollectionPersonInfo.class);
            for (DataCollectionPersonInfo personInfo : resultList) {
                String collecterId = personInfo.getCollecterId();
                Person person = (Person)personMap.get(collecterId);
                if (person == null && (person = this.personDao.queryPersonById(collecterId)) != null) {
                    personMap.put(collecterId, person);
                }
                if (person == null) continue;
                personInfo.setPolicyCode(person.getCode());
                personInfo.setPolicyName(person.getName());
                personInfo.setDeptmentId(person.getDepId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public Long queryPerSonInfoCount(DataCollectionParams dataCollectionParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(ap.id) FROM t_collect_associated_person  ap left join t_collect_general g on ap.collect_id = g.id    where 1 = 1 ");
        this.addCommonConditionForSql(dataCollectionParams, sb);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.executeQueryCount(sb.toString(), null);
    }

    @Override
    public String exportInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        this.exportPersonInfo(wb, dataCollectionParams);
        this.exportVehicleInfo(wb, dataCollectionParams);
        this.exportCaseInfo(wb, dataCollectionParams);
        String sj = this.getSj(dataCollectionParams);
        String fileName = "\u901a\u7528\u4fe1\u606f\u91c7\u96c6" + this.getSj(dataCollectionParams);
        return ExportExcelUtil.getFileName(fileName, sj);
    }

    @Override
    public String exportPersonInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.getSj(dataCollectionParams);
        List<DataCollectionPersonInfo> personInfoList = this.queryPerSonInfo(dataCollectionParams, true);
        String[] aryTitle = new String[]{"\u91c7\u96c6\u65f6\u95f4", "\u91c7\u96c6\u539f\u56e0", "\u4eba\u5458\u59d3\u540d", "\u6027\u522b", "\u8eab\u4efd\u8bc1\u53f7", "\u6237\u7c4d\u5730\u5740", "\u8054\u7cfb\u7535\u8bdd", "\u8b66\u5458\u59d3\u540d", "\u8b66\u53f7"};
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataCollectionPersonInfo personInfo : personInfoList) {
            Object[] aryData = new Object[]{personInfo.getCreateTime(), personInfo.getCollectReason(), personInfo.getName(), personInfo.getSex(), personInfo.getIdentity(), personInfo.getOriginAddress(), personInfo.getContactPhone(), personInfo.getPolicyName(), personInfo.getPolicyCode()};
            dataList.add(aryData);
        }
        String fileName = "\u4eba\u5458\u4fe1\u606f" + sj;
        ExportExcelUtil.createExcel(wb, fileName, aryTitle, dataList);
        return ExportExcelUtil.getFileName("\u4eba\u5458\u4fe1\u606f", sj);
    }

    @Override
    public List<DataCollectionVehicleInfo> queryVehicleInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        List<DataCollectionVehicleInfo> refResult = null;
        HashMap<String, Person> personMap = new HashMap<String, Person>(32);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ap.id as id,  DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime, c.name AS collectReason , tc.name AS cardType, ap.card_number AS cardNumber, ap.vehicle_owner AS vehicleOwner, ap.vehicle_brand AS vehicleBrand, ap.vehicle_factory_time AS vehicleFactoryTime, tc1.name AS vehicleState, ap.vehicle_color AS vehicleColor, ap.contact_phone AS contactPhone, ap.collect_id as collectId, g.collecter_id AS collecterId FROM t_collect_associated_vehicle ap LEFT JOIN t_collect_general g ON ap.collect_id = g.id  LEFT JOIN t_commoncode tc   ON tc.code = ap.card_type   LEFT JOIN t_commoncode tc1   ON tc1.code = ap.vehicle_state  ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" where 1 = 1  ");
        if (isExportExcel) {
            this.addCommonConditionForSql(dataCollectionParams, sb);
        } else {
            this.addConditionForSql(dataCollectionParams, sb);
        }
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            refResult = jdbcSession.findMoreRefResult(sb.toString(), null, DataCollectionVehicleInfo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (DataCollectionVehicleInfo vehicleInfo : refResult) {
            String collecterId = vehicleInfo.getCollecterId();
            Person person = (Person)personMap.get(collecterId);
            if (person == null && (person = this.personDao.queryPersonById(collecterId)) != null) {
                personMap.put(collecterId, person);
            }
            if (person == null) continue;
            vehicleInfo.setPolicyCode(person.getCode());
            vehicleInfo.setPolicyName(person.getName());
            vehicleInfo.setDeptmentId(person.getDepId());
        }
        return refResult;
    }

    @Override
    public Long queryVehicleInfoCount(DataCollectionParams dataCollectionParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(ap.id) FROM t_collect_associated_vehicle ap left join t_collect_general g on ap.collect_id = g.id   where 1 = 1 ");
        this.addCommonConditionForSql(dataCollectionParams, sb);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.executeQueryCount(sb.toString(), null);
    }

    @Override
    public String exportVehicleInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.getSj(dataCollectionParams);
        List<DataCollectionVehicleInfo> dataCollectionVehicleInfoList = this.queryVehicleInfo(dataCollectionParams, true);
        String[] aryTitle = new String[]{"\u91c7\u96c6\u65f6\u95f4", "\u91c7\u96c6\u539f\u56e0", "\u53f7\u724c\u79cd\u7c7b", "\u53f7\u724c\u53f7\u7801", "\u673a\u52a8\u8f66\u6240\u6709\u4eba", "\u8f66\u8f86\u7c7b\u578b", "\u8f66\u8f86\u72b6\u6001", "\u8f66\u8f86\u989c\u8272", "\u8054\u7cfb\u7535\u8bdd", "\u8b66\u5458\u59d3\u540d", "\u8b66\u53f7"};
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataCollectionVehicleInfo vehicleInfo : dataCollectionVehicleInfoList) {
            Object[] aryData = new Object[]{vehicleInfo.getCreateTime(), vehicleInfo.getCollectReason(), vehicleInfo.getCardType(), vehicleInfo.getCardNumber(), vehicleInfo.getVehicleOwner(), vehicleInfo.getVehicleBrand(), vehicleInfo.getVehicleState(), vehicleInfo.getVehicleColor(), vehicleInfo.getContactPhone(), vehicleInfo.getPolicyName(), vehicleInfo.getPolicyCode()};
            dataList.add(aryData);
        }
        String name = "\u8f66\u8f86\u4fe1\u606f";
        String fileName = name + sj;
        ExportExcelUtil.createExcel(wb, fileName, aryTitle, dataList);
        return ExportExcelUtil.getFileName(name, sj);
    }

    @Override
    public List<DataCollectionCaseInfo> queryCaseInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        List<DataCollectionCaseInfo> refResult = null;
        HashMap<String, Person> personMap = new HashMap<String, Person>(32);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT  ap.id as id, DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime , c.name AS collectReason, tc.name AS caseType, tc1.name AS degree, CONCAT(IFNULL(ap.province,''),IFNULL(ap.city,''),IFNULL(ap.country,''),IFNULL(ap.street,'')) AS localtion,  ap.collect_id as collectId, ap.street AS localtionDetail, ap.description AS description, ap.suggest AS suggest, DATE_FORMAT(    FROM_UNIXTIME(ap.case_time / 1000),    '%Y-%m-%d %H:%m:%s'  ) AS caseTime, g.collecter_id AS collecterId  FROM t_collect_associated_case ap LEFT JOIN t_collect_general g ON  ap.collect_id = g.id  LEFT JOIN t_commoncode tc    ON tc.code = ap.type LEFT JOIN t_commoncode tc1 ON tc1.code = ap.degree ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" where 1 = 1  ");
        if (isExportExcel) {
            this.addCommonConditionForSql(dataCollectionParams, sb);
        } else {
            this.addConditionForSql(dataCollectionParams, sb);
        }
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            refResult = jdbcSession.findMoreRefResult(sb.toString(), null, DataCollectionCaseInfo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (DataCollectionCaseInfo caseInfo : refResult) {
            String collecterId = caseInfo.getCollecterId();
            Person person = (Person)personMap.get(collecterId);
            if (person == null && (person = this.personDao.queryPersonById(collecterId)) != null) {
                personMap.put(collecterId, person);
            }
            if (person == null) continue;
            caseInfo.setPolicyCode(person.getCode());
            caseInfo.setPolicyName(person.getName());
            caseInfo.setDeptmentId(person.getDepId());
        }
        return refResult;
    }

    @Override
    public Long queryCaseInfoCount(DataCollectionParams dataCollectionParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(ap.id) FROM t_collect_associated_case  ap left join t_collect_general g on ap.collect_id = g.id   where 1 = 1 ");
        this.addCommonConditionForSql(dataCollectionParams, sb);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        return jdbcSession.executeQueryCount(sb.toString(), null);
    }

    @Override
    public String exportCaseInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.getSj(dataCollectionParams);
        List<DataCollectionCaseInfo> dataCollectionCaseInfos = this.queryCaseInfo(dataCollectionParams, true);
        String[] aryTitle = new String[]{"\u91c7\u96c6\u65f6\u95f4", "\u91c7\u96c6\u539f\u56e0", "\u4e8b\u4ef6\u7c7b\u578b", "\u4e25\u91cd\u7a0b\u5ea6", "\u4e8b\u4ef6\u5730\u70b9", "\u4e8b\u4ef6\u63cf\u8ff0", "\u5904\u7406\u610f\u89c1", "\u53d1\u751f\u65f6\u95f4", "\u8b66\u5458\u59d3\u540d", "\u8b66\u53f7"};
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataCollectionCaseInfo caseInfo : dataCollectionCaseInfos) {
            Object[] aryData = new Object[]{caseInfo.getCreateTime(), caseInfo.getCollectReason(), caseInfo.getCaseType(), caseInfo.getDegree(), caseInfo.getLocaltion(), caseInfo.getDescription(), caseInfo.getSuggest(), caseInfo.getCaseTime(), caseInfo.getPolicyName(), caseInfo.getPolicyCode()};
            dataList.add(aryData);
        }
        String name = "\u4e8b\u4ef6\u4fe1\u606f";
        String fileName = name + sj;
        ExportExcelUtil.createExcel(wb, fileName, aryTitle, dataList);
        return ExportExcelUtil.getFileName(name, sj);
    }

    @Override
    public void addCommonConditionForSql(DataCollectionParams dataCollectionParams, StringBuilder sb) {
        this.addDateForSql(dataCollectionParams, sb);
        this.addCollecterIdForSql(dataCollectionParams, sb);
        this.addOrderByForSql(sb);
    }

    @Override
    public void addConditionForSql(DataCollectionParams dataCollectionParams, StringBuilder sb) {
        this.addCommonConditionForSql(dataCollectionParams, sb);
        this.addPageLimitForSql(dataCollectionParams, sb);
    }

    @Override
    public void addDateForSql(DataCollectionParams dataCollectionParams, StringBuilder sb) {
        if (dataCollectionParams != null) {
            String startTime = dataCollectionParams.getStartTime();
            String endTime = dataCollectionParams.getEndTime();
            if (startTime != null && StringUtils.isNotBlank((CharSequence)startTime)) {
                sb.append(" and g.create_time >=   '" + startTime + " 00:00:00" + "' ");
            }
            if (endTime != null && StringUtils.isNotBlank((CharSequence)endTime)) {
                sb.append(" and g.create_time <=   '" + endTime + " 23:59:59" + "' ");
            }
        }
    }

    @Override
    public void addCollecterIdForSql(DataCollectionParams dataCollectionParams, StringBuilder sb) {
        StringBuilder sbId = new StringBuilder();
        List<String> personIdList = dataCollectionParams.getPersonIds();
        if (personIdList != null && personIdList.size() > 0) {
            for (int i = 0; i < personIdList.size(); ++i) {
                sbId.append(" '" + personIdList.get(i) + "' ");
                if (i >= personIdList.size() - 1) continue;
                sbId.append(",");
            }
            sb.append(" and g.collecter_id in ( " + sbId + ")  ");
        }
    }

    @Override
    public void addOrderByForSql(StringBuilder sb) {
        sb.append(" order by g.create_time desc ");
    }

    @Override
    public void addPageLimitForSql(DataCollectionParams dataCollectionParams, StringBuilder sb) {
        int page = dataCollectionParams.getPage();
        int rows = dataCollectionParams.getRows();
        page = page <= 0 ? 1 : page;
        rows = rows <= 0 ? 15 : rows;
        int currentPage = (page - 1) * rows;
        sb.append("limit  " + currentPage + " , " + rows);
    }

    @Override
    public String getSj(DataCollectionParams dataCollectionParams) {
        String sj = "";
        if (StringUtils.isNotBlank((CharSequence)dataCollectionParams.getStartTime()) && StringUtils.isNotBlank((CharSequence)dataCollectionParams.getEndTime())) {
            sj = "(" + dataCollectionParams.getStartTime().replaceAll("-", ".") + "-" + dataCollectionParams.getEndTime().replaceAll("-", ".") + ")";
        }
        return sj;
    }

    private List<DataCollectionPersonDetail> queryPersonDetailList(String collecterId, String id1) {
        StringBuilder sb = new StringBuilder();
        List<DataCollectionPersonDetail> detailList = null;
        sb.append("SELECT ap.id as id,ap.collect_id as collectId, DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime, c.name AS collectReason ,ap.name, c1.name     AS sex , ap.identity AS identity, CONCAT(IFNULL(ap.origin_province,''),IFNULL(ap.origin_city,''),IFNULL(ap.origin_country,''),IFNULL(ap.origin_street,''))AS originAddress,CONCAT(IFNULL(ap.`live_province`,''),IFNULL(ap.`live_city`,''),IFNULL(ap.`live_country`,''),IFNULL(ap.`live_street`,'')) AS liveAddress, ap.contact_phone AS contactPhone, g.collecter_id as collecterId, ap.remark as remark  FROM t_collect_associated_person ap LEFT JOIN t_collect_general g  ON ap.collect_id = g.id  ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" LEFT JOIN t_commoncode c1 on c1.code = ap.sex  ");
        sb.append(" where 1 = 1  and ap.collect_id =  '" + collecterId + "' and " + " ap.id != '" + id1 + "'  ");
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            detailList = jdbcSession.findMoreRefResult(sb.toString(), null, DataCollectionPersonDetail.class);
            return detailList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DataCollectionPersonDetail queryPersonDetail(String id) {
        StringBuilder sb = new StringBuilder();
        DataCollectionPersonDetail detail = null;
        sb.append("SELECT ap.id as id,ap.collect_id as collectId, DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime, c.name AS collectReason ,ap.name, c1.name     AS sex , ap.identity AS identity, CONCAT(IFNULL(ap.origin_province,''),IFNULL(ap.origin_city,''),IFNULL(ap.origin_country,''),IFNULL(ap.origin_street,''))AS originAddress,CONCAT(IFNULL(ap.`live_province`,''),IFNULL(ap.`live_city`,''),IFNULL(ap.`live_country`,''),IFNULL(ap.`live_street`,'')) AS liveAddress, ap.contact_phone AS contactPhone, g.collecter_id as collecterId, ap.remark as remark  FROM t_collect_associated_person ap LEFT JOIN t_collect_general g  ON ap.collect_id = g.id  ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" LEFT JOIN t_commoncode c1 on c1.code = ap.sex  ");
        sb.append(" where 1 = 1  and ap.id =  '" + id + "' ");
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            detail = jdbcSession.findSimpleRefResult(sb.toString(), null, DataCollectionPersonDetail.class);
            String collecterId = detail.getCollecterId();
            Person person = this.personDao.queryPersonById(collecterId);
            if (person != null) {
                detail.setPolicyCode(person.getCode());
                detail.setPolicyName(person.getName());
                detail.setDeptmentId(person.getDepId());
            }
            AttachmentBean attachmentBean = this.getAttachmentBean(detail.getCollectId(), jdbcSession, "p");
            detail.setAttachmentBean(attachmentBean);
            this.getFileName(attachmentBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detail;
    }

    private AttachmentBean getAttachmentBean(String collectId, JDBCSession jdbcSession, String searchType) {
        AttachmentBean attachmentBean = new AttachmentBean();
        StringBuilder sb = new StringBuilder();
        sb.append("  SELECT att.`attach_type` AS type ,att.`field1`,att.`field2`,att.`field3`,att.`field4` FROM `t_collect_attachment` att, t_collect_general g WHERE att.`collect_id` = '" + collectId + "' and g.id = att.`collect_id` ");
        if ("p".equalsIgnoreCase(searchType)) {
            sb.append(" and g.type_person = 1 ");
        } else if ("v".equalsIgnoreCase(searchType)) {
            sb.append(" and g.type_vehicle = 1 ");
        } else if ("c".equalsIgnoreCase(searchType)) {
            sb.append(" and g.type_case = 1 ");
        }
        List<Map<String, Object>> lss = jdbcSession.executeQuery(sb.toString(), null);
        for (int i = 0; i < lss.size(); ++i) {
            Map<String, Object> map = lss.get(i);
            String type = (String)map.get("type");
            String field1 = (String)map.get("field1");
            String field2 = (String)map.get("field2");
            String field3 = (String)map.get("field4");
            String field4 = (String)map.get("field4");
            if (type.equalsIgnoreCase("collect_attach_type_picture")) {
                if (StringUtils.isNotBlank((CharSequence)field1)) {
                    List<String> pictureList = attachmentBean.getPictureList();
                    pictureList.add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                }
                if (StringUtils.isNotBlank((CharSequence)field2)) {
                    attachmentBean.getPictureList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                }
                if (StringUtils.isNotBlank((CharSequence)field3)) {
                    attachmentBean.getPictureList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                }
                if (!StringUtils.isNotBlank((CharSequence)field4)) continue;
                attachmentBean.getPictureList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                continue;
            }
            if (type.equalsIgnoreCase("collect_attach_type_video")) {
                if (StringUtils.isNotBlank((CharSequence)field1)) {
                    attachmentBean.getVideoList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                }
                if (StringUtils.isNotBlank((CharSequence)field2)) {
                    attachmentBean.getVideoList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                }
                if (StringUtils.isNotBlank((CharSequence)field3)) {
                    attachmentBean.getVideoList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                }
                if (!StringUtils.isNotBlank((CharSequence)field4)) continue;
                attachmentBean.getVideoList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
                continue;
            }
            if (!type.equalsIgnoreCase("collect_attach_type_audio")) continue;
            if (StringUtils.isNotBlank((CharSequence)field1)) {
                attachmentBean.getAudioList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
            }
            if (StringUtils.isNotBlank((CharSequence)field2)) {
                attachmentBean.getAudioList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
            }
            if (StringUtils.isNotBlank((CharSequence)field3)) {
                attachmentBean.getAudioList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
            }
            if (!StringUtils.isNotBlank((CharSequence)field4)) continue;
            attachmentBean.getAudioList().add(this.fastDFSClientService.getFastDFSServerUrl(field1));
        }
        return attachmentBean;
    }

    private List<DataCollectionVehicleDetail> queryVehicleDetailList(String collecterId, String id1) {
        StringBuilder sb = new StringBuilder();
        List<DataCollectionVehicleDetail> detailList = null;
        sb.append("SELECT ap.id as id,ap.collect_id as collectId, ap.remark as remark,   DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime, c.name AS collectReason , tc.name AS cardType, ap.card_number AS cardNumber, ap.vehicle_owner AS vehicleOwner, ap.vehicle_brand AS vehicleBrand, ap.vehicle_factory_time AS vehicleFactoryTime, tc1.name AS vehicleState, ap.vehicle_color AS vehicleColor, ap.contact_phone AS contactPhone, g.collecter_id AS collecterId FROM t_collect_associated_vehicle ap LEFT JOIN t_collect_general g ON ap.collect_id = g.id  LEFT JOIN t_commoncode tc   ON tc.code = ap.card_type   LEFT JOIN t_commoncode tc1   ON tc1.code = ap.vehicle_state ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" where 1 = 1  and ap.collect_id =  '" + collecterId + "' ");
        sb.append(" and ap.id != '" + id1 + "'  ");
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            detailList = jdbcSession.findMoreRefResult(sb.toString(), null, DataCollectionVehicleDetail.class);
            return detailList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DataCollectionVehicleDetail queryVehicleDetail(String id) {
        StringBuilder sb = new StringBuilder();
        DataCollectionVehicleDetail detail = null;
        sb.append("SELECT ap.id as id,ap.collect_id as collectId, ap.remark as remark,   DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime, c.name AS collectReason , tc.name AS cardType, ap.card_number AS cardNumber, ap.vehicle_owner AS vehicleOwner, ap.vehicle_brand AS vehicleBrand, ap.vehicle_factory_time AS vehicleFactoryTime, tc1.name AS vehicleState, ap.vehicle_color AS vehicleColor, ap.contact_phone AS contactPhone, g.collecter_id AS collecterId FROM t_collect_associated_vehicle ap LEFT JOIN t_collect_general g ON ap.collect_id = g.id  LEFT JOIN t_commoncode tc   ON tc.code = ap.card_type   LEFT JOIN t_commoncode tc1   ON tc1.code = ap.vehicle_state ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" where 1 = 1  and ap.id =  '" + id + "' ");
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            detail = jdbcSession.findSimpleRefResult(sb.toString(), null, DataCollectionVehicleDetail.class);
            String collecterId = detail.getCollecterId();
            Person person = this.personDao.queryPersonById(collecterId);
            if (person != null) {
                detail.setPolicyCode(person.getCode());
                detail.setPolicyName(person.getName());
                detail.setDeptmentId(person.getDepId());
            }
            AttachmentBean attachmentBean = this.getAttachmentBean(detail.getCollectId(), jdbcSession, "v");
            detail.setAttachmentBean(attachmentBean);
            this.getFileName(attachmentBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detail;
    }

    private List<DataCollectionCaseDetail> queryCaseDetailList(String collecterId, String id1) {
        StringBuilder sb = new StringBuilder();
        List<DataCollectionCaseDetail> detailList = null;
        sb.append("SELECT  ap.id as id,ap.collect_id as collectId, ap.remark as remark, DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime , c.name AS collectReason, tc.name AS caseType, tc1.name AS degree, CONCAT(IFNULL(ap.province,''),IFNULL(ap.city,''),IFNULL(ap.country,''),IFNULL(ap.street,'')) AS localtion, ap.street AS localtionDetail, ap.description AS description, ap.suggest AS suggest, DATE_FORMAT(                FROM_UNIXTIME(ap.case_time / 1000),                   '%Y-%m-%d %H:%m:%s'                 ) AS caseTime, g.collecter_id AS collecterId  FROM t_collect_associated_case ap LEFT JOIN t_collect_general g ON  ap.collect_id = g.id  LEFT JOIN t_commoncode tc   ON tc.code = ap.type LEFT JOIN t_commoncode tc1  ON tc1.code = ap.degree ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" where 1 = 1  and ap.collect_id =  '" + collecterId + "' ");
        sb.append(" and ap.id != '" + id1 + "'  ");
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            detailList = jdbcSession.findMoreRefResult(sb.toString(), null, DataCollectionCaseDetail.class);
            return detailList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DataCollectionCaseDetail queryCaseDetail(String id) {
        DataCollectionCaseDetail detail = null;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT  ap.id as id,ap.collect_id as collectId, ap.remark as remark, DATE_FORMAT(g.create_time,'%Y-%m-%d %H:%i:%s')  AS createTime , c.name AS collectReason, tc.name AS caseType, tc1.name AS degree, CONCAT(IFNULL(ap.province,''),IFNULL(ap.city,''),IFNULL(ap.country,''),IFNULL(ap.street,'')) AS localtion, ap.street AS localtionDetail, ap.description AS description, ap.suggest AS suggest, DATE_FORMAT(                FROM_UNIXTIME(ap.case_time / 1000),                   '%Y-%m-%d %H:%m:%s'                 ) AS caseTime, g.collecter_id AS collecterId  FROM t_collect_associated_case ap LEFT JOIN t_collect_general g ON  ap.collect_id = g.id  LEFT JOIN t_commoncode tc   ON tc.code = ap.type LEFT JOIN t_commoncode tc1  ON tc1.code = ap.degree ");
        sb.append(" LEFT JOIN t_commoncode c on c.code = g.collect_reason  ");
        sb.append(" where 1 = 1  and ap.id =  '" + id + "' ");
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        try {
            detail = jdbcSession.findSimpleRefResult(sb.toString(), null, DataCollectionCaseDetail.class);
            String collecterId = detail.getCollecterId();
            Person person = this.personDao.queryPersonById(collecterId);
            if (person != null) {
                detail.setPolicyCode(person.getCode());
                detail.setPolicyName(person.getName());
                detail.setDeptmentId(person.getDepId());
            }
            AttachmentBean attachmentBean = this.getAttachmentBean(detail.getCollectId(), jdbcSession, "c");
            detail.setAttachmentBean(attachmentBean);
            this.getFileName(attachmentBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detail;
    }

    public void getFileName(AttachmentBean attachmentBean) {
        List<String> pictureList = attachmentBean.getPictureList();
        List<String> audioList = attachmentBean.getAudioList();
        List<String> videoList = attachmentBean.getVideoList();
        if (pictureList != null && pictureList.size() > 0) {
            attachmentBean.setPictureNameList(this.getNameList(pictureList));
        }
        if (audioList != null && audioList.size() > 0) {
            attachmentBean.setAudioNameList(this.getNameList(audioList));
        }
        if (videoList != null && videoList.size() > 0) {
            attachmentBean.setVideoNameList(this.getNameList(videoList));
        }
    }

    private List<String> getNameList(List<String> srcList) {
        ArrayList<String> nameList = new ArrayList<String>(4);
        for (String src : srcList) {
            int index = src.lastIndexOf("/");
            nameList.add(src.substring(index + 1));
        }
        return nameList;
    }

    @Override
    public JSONObject queryDetail(String id, String id1) {
        JSONObject json = new JSONObject();
        String s = "SELECT DATE_FORMAT(create_time,'%Y-%m-%d %H:%i:%s')  AS createTime ,\n  collecter_id as collecterId,\n  type_person AS typePerson,\n  type_vehicle AS typeVehicle,\n  type_case AS typeCase \nFROM\n  t_collect_general \nWHERE id = '" + id + "'";
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> list = jdbcSession.executeQuery(s, null);
        if (list != null && list.size() > 0) {
            List<Object> details;
            Object detail;
            Map<String, Object> map = list.get(0);
            String collecterId = (String)map.get("collecterId");
            String createTime = (String)map.get("createTime");
            String typePerson = (String)map.get("typePerson");
            String typeVehicle = (String)map.get("typeVehicle");
            String typeCase = (String)map.get("typeCase");
            Person person = this.personDao.queryPersonById(collecterId);
            json.put("policyName", (Object)person.getName());
            json.put("createTime", (Object)createTime);
            ArrayList<DataCollectionPersonDetail> personDetailList = new ArrayList<DataCollectionPersonDetail>(8);
            ArrayList<Object> vehicleDetails = new ArrayList<Object>(8);
            ArrayList<Object> caseDetails = new ArrayList<Object>(8);
            if ("1".equalsIgnoreCase(typePerson)) {
                List<DataCollectionPersonDetail> personDetails;
                detail = this.queryPersonDetail(id1);
                if (detail != null) {
                    personDetailList.add((DataCollectionPersonDetail)detail);
                }
                if ((personDetails = this.queryPersonDetailList(id, id1)) != null && personDetails.size() > 0) {
                    personDetailList.addAll(personDetails);
                }
            }
            if ("1".equalsIgnoreCase(typeVehicle)) {
                detail = this.queryVehicleDetail(id1);
                if (detail != null) {
                    vehicleDetails.add(detail);
                }
                if ((details = this.queryVehicleDetailList(id, id1)) != null && details.size() > 0) {
                    vehicleDetails.addAll(details);
                }
            }
            if ("1".equalsIgnoreCase(typeCase)) {
                detail = this.queryCaseDetail(id1);
                if (detail != null) {
                    caseDetails.add(detail);
                }
                if ((details = this.queryCaseDetailList(id, id1)) != null && details.size() > 0) {
                    caseDetails.addAll(details);
                }
            }
            json.put("personDetailList", personDetailList);
            json.put("vehicleDetails", vehicleDetails);
            json.put("caseDetails", caseDetails);
            AttachmentBean attachmentBean = this.getAttachmentBean(id, jdbcSession, null);
            json.put("attachmentBean", (Object)attachmentBean);
        }
        return json;
    }
}

