/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.datacollection.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.datacollection.bean.DataCollectionParams;
import pams.function.xatl.datacollection.bean.DataStatisticsCaseInfo;
import pams.function.xatl.datacollection.bean.DataStatisticsDataInfo;
import pams.function.xatl.datacollection.bean.DataStatisticsPersonInfo;
import pams.function.xatl.datacollection.bean.DataStatisticsVehicleInfo;
import pams.function.xatl.datacollection.bean.ExcelFirstRowBean;
import pams.function.xatl.datacollection.service.DataCollectionService;
import pams.function.xatl.datacollection.service.DataStatisticsService;
import pams.function.xatl.datacollection.service.JDBCSessionService;
import pams.function.xatl.util.ExportExcelUtil;
import pams.function.xatl.util.JDBCSession;

@Service
public class DataStatisticsServiceImpl
implements DataStatisticsService {
    @Autowired
    JDBCSessionService jdbcSessionService;
    @Autowired
    DataCollectionService dataCollectionService;

    @Override
    public ArrayList<DataStatisticsDataInfo> queryDataNumberInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        HashMap<String, DataStatisticsDataInfo> infoMap = new HashMap<String, DataStatisticsDataInfo>(32);
        this.getPersonCount(infoMap, dataCollectionParams);
        this.getVehicleCount(infoMap, dataCollectionParams);
        this.getCaseCount(infoMap, dataCollectionParams);
        Collection values = infoMap.values();
        ArrayList<DataStatisticsDataInfo> infos = new ArrayList<DataStatisticsDataInfo>(values);
        return infos;
    }

    @Override
    public String exportAllInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        this.exportDataNumberInfo(wb, dataCollectionParams);
        this.exportPersonNumberInfo(wb, dataCollectionParams);
        this.exportVehicleNumberInfo(wb, dataCollectionParams);
        this.exportCaseNumberInfo(wb, dataCollectionParams);
        return ExportExcelUtil.getFileName("\u91c7\u96c6\u6570\u636e\u7edf\u8ba1", this.dataCollectionService.getSj(dataCollectionParams));
    }

    private void getCaseCount(Map<String, DataStatisticsDataInfo> infoMap, DataCollectionParams dataCollectionParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') createTime ,COUNT(*) num ,g.`collect_reason` reason \nFROM\n  `t_collect_associated_case` ap \n  LEFT JOIN `t_collect_general` g \n    ON g.`id` = ap.`collect_id` where g.`type_case` ");
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.addPageGroupByForSql(sb);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("reason");
            Long num = (Long)map.get("num");
            DataStatisticsDataInfo dataInfo = infoMap.get(createTime);
            if (dataInfo != null) {
                this.setDataPersonReasonNum(dataInfo, reason, num, "c");
                continue;
            }
            dataInfo = new DataStatisticsDataInfo();
            dataInfo.setCreateTime(createTime);
            this.setDataPersonReasonNum(dataInfo, reason, num, "c");
            infoMap.put(createTime, dataInfo);
        }
    }

    private void getVehicleCount(Map<String, DataStatisticsDataInfo> infoMap, DataCollectionParams dataCollectionParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') createTime ,COUNT(*) num ,g.`collect_reason` reason \nFROM\n  `t_collect_associated_vehicle` ap \n  LEFT JOIN `t_collect_general` g \n    ON g.`id` = ap.`collect_id` where g.`type_vehicle` = 1  ");
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.addPageGroupByForSql(sb);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("reason");
            Long num = (Long)map.get("num");
            DataStatisticsDataInfo dataInfo = infoMap.get(createTime);
            if (dataInfo != null) {
                this.setDataPersonReasonNum(dataInfo, reason, num, "v");
                continue;
            }
            dataInfo = new DataStatisticsDataInfo();
            dataInfo.setCreateTime(createTime);
            this.setDataPersonReasonNum(dataInfo, reason, num, "v");
            infoMap.put(createTime, dataInfo);
        }
    }

    private void getPersonCount(Map<String, DataStatisticsDataInfo> infoMap, DataCollectionParams dataCollectionParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') createTime ,COUNT(*) num ,g.`collect_reason` reason \nFROM\n  `t_collect_associated_person` ap \n  LEFT JOIN `t_collect_general` g \n    ON g.`id` = ap.`collect_id` where g.`type_person` = 1  ");
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.addPageGroupByForSql(sb);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("reason");
            Long num = (Long)map.get("num");
            DataStatisticsDataInfo dataInfo = infoMap.get(createTime);
            if (dataInfo != null) {
                this.setDataPersonReasonNum(dataInfo, reason, num, "p");
                continue;
            }
            dataInfo = new DataStatisticsDataInfo();
            dataInfo.setCreateTime(createTime);
            this.setDataPersonReasonNum(dataInfo, reason, num, "p");
            infoMap.put(createTime, dataInfo);
        }
    }

    @Override
    public String exportDataNumberInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.dataCollectionService.getSj(dataCollectionParams);
        ArrayList<DataStatisticsDataInfo> dataInfos = this.queryDataNumberInfo(dataCollectionParams, true);
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataStatisticsDataInfo info1 : dataInfos) {
            Object[] aryData = null;
            aryData = new Object[]{info1.getCreateTime(), info1.getTotalInfoNum(), info1.getPersonInfoNum(), info1.getVehicleInfoNum(), info1.getCaseInfoNum(), info1.getSecurityInfoNum(), info1.getIllegalInfoNum(), info1.getOtherInfoNum()};
            dataList.add(aryData);
        }
        String name = "\u6570\u636e\u91c7\u96c6\u7edf\u8ba1";
        String fileName = name + sj;
        ArrayList<ExcelFirstRowBean> list = new ArrayList<ExcelFirstRowBean>(16);
        ExcelFirstRowBean b1 = new ExcelFirstRowBean("\u91c7\u96c6\u65f6\u95f4", 1, 0, 2, 0);
        ExcelFirstRowBean b4 = new ExcelFirstRowBean("\u5408\u8ba1", 1, 1, 2, 1);
        ExcelFirstRowBean b2 = new ExcelFirstRowBean("\u91c7\u96c6\u7c7b\u578b", 1, 2, 1, 4);
        ExcelFirstRowBean b3 = new ExcelFirstRowBean("\u91c7\u96c6\u539f\u56e0", 1, 5, 1, 7);
        list.add(b1);
        list.add(b2);
        list.add(b3);
        list.add(b4);
        String[] strs = new String[]{"\u4eba\u5458\u91c7\u96c6", "\u8f66\u8f86\u91c7\u96c6", "\u4e8b\u4ef6\u91c7\u96c6", "\u6cbb\u5b89\u4fe1\u606f", "\u8fdd\u6cd5\u4fe1\u606f", "\u5176\u4ed6"};
        ExportExcelUtil.createCombineExcel(wb, fileName, list, strs, dataList, 2, 8);
        return ExportExcelUtil.getFileName(name, sj);
    }

    @Override
    public List<DataStatisticsPersonInfo> queryPersonNumberInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, DataStatisticsPersonInfo> infoMap = new HashMap<String, DataStatisticsPersonInfo>(32);
        ArrayList<DataStatisticsPersonInfo> list = new ArrayList<DataStatisticsPersonInfo>(32);
        sb.append("SELECT       DATE_FORMAT(         g.create_time   ,         '%Y-%m-%d'       ) AS  createTime, g.collect_reason AS reason, COUNT(g.id) AS num     FROM  `t_collect_associated_person` ap  left join   t_collect_general g    on ap.collect_id = g.id  WHERE 1 = 1 and  g.`type_person` = '1' ");
        this.addStatisticsReasonConditionSql(dataCollectionParams, sb, isExportExcel);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("reason");
            Long num = (Long)map.get("num");
            DataStatisticsPersonInfo personInfo = (DataStatisticsPersonInfo)infoMap.get(createTime);
            if (personInfo != null) {
                this.setPersonReasonNum(personInfo, reason, (long)num);
                continue;
            }
            personInfo = new DataStatisticsPersonInfo();
            personInfo.setCreateTime(createTime);
            this.setPersonReasonNum(personInfo, reason, (long)num);
            infoMap.put(createTime, personInfo);
            list.add(personInfo);
        }
        return list;
    }

    @Override
    public String exportPersonNumberInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.dataCollectionService.getSj(dataCollectionParams);
        List<DataStatisticsPersonInfo> dataStatisticsPersonInfos = this.queryPersonNumberInfo(dataCollectionParams, true);
        String[] aryTitle = new String[]{"\u91c7\u96c6\u65f6\u95f4", "\u5408\u8ba1", "\u6cbb\u5b89\u4fe1\u606f", "\u8fdd\u6cd5\u4fe1\u606f", "\u5176\u4ed6"};
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataStatisticsPersonInfo info : dataStatisticsPersonInfos) {
            Object[] aryData = null;
            DataStatisticsPersonInfo info1 = info;
            aryData = new Object[]{info1.getCreateTime(), info1.getTotalInfoNum(), info1.getSecurityInfoNum(), info1.getIllegalInfoNum(), info1.getOtherInfoNum()};
            dataList.add(aryData);
        }
        String name = "\u4eba\u5458\u91c7\u96c6\u7edf\u8ba1";
        String fileName = name + sj;
        ExportExcelUtil.createExcel(wb, fileName, aryTitle, dataList);
        return ExportExcelUtil.getFileName(name, sj);
    }

    @Override
    public ArrayList<DataStatisticsVehicleInfo> queryVehicleNumberInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, DataStatisticsVehicleInfo> infoMap = new HashMap<String, DataStatisticsVehicleInfo>(32);
        ArrayList list = new ArrayList(32);
        this.dealVehicleReasonInfo(dataCollectionParams, isExportExcel, sb, infoMap);
        this.dealVehicleCardTypeInfo(dataCollectionParams, isExportExcel, infoMap);
        return new ArrayList<DataStatisticsVehicleInfo>(infoMap.values());
    }

    private void dealVehicleCardTypeInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel, Map<String, DataStatisticsVehicleInfo> infoMap) {
        StringBuilder sb = new StringBuilder("SELECT      \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') AS createTime,\n  ap.card_type as carType,\n  COUNT(g.id) AS num \nFROM  `t_collect_associated_vehicle` ap LEFT JOIN t_collect_general g  \n  ON ap.`collect_id` = g.id where 1 = 1  AND g.type_vehicle = '1'  ");
        this.addStatisticsCarTypeConditionSql(dataCollectionParams, sb, isExportExcel);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("carType");
            Long num = (Long)map.get("num");
            DataStatisticsVehicleInfo vehicleInfo = infoMap.get(createTime);
            if (vehicleInfo != null) {
                this.setCarTypeNum(vehicleInfo, reason, num);
                continue;
            }
            vehicleInfo = new DataStatisticsVehicleInfo();
            vehicleInfo.setCreateTime(createTime);
            this.setCarTypeNum(vehicleInfo, reason, num);
            infoMap.put(createTime, vehicleInfo);
        }
    }

    private void dealVehicleReasonInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel, StringBuilder sb, Map<String, DataStatisticsVehicleInfo> infoMap) {
        sb.append("SELECT  \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') AS createTime,\n  g.collect_reason AS reason,\n  COUNT(g.id) AS num \nFROM  `t_collect_associated_vehicle` ap LEFT JOIN t_collect_general g  \n  ON ap.`collect_id` = g.id where 1 = 1  AND g.type_vehicle = '1'  ");
        this.addStatisticsReasonConditionSql(dataCollectionParams, sb, isExportExcel);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("reason");
            Long num = (Long)map.get("num");
            DataStatisticsVehicleInfo vehicleInfo = infoMap.get(createTime);
            if (vehicleInfo != null) {
                this.setVehicleReasonNum(vehicleInfo, reason, num);
                continue;
            }
            vehicleInfo = new DataStatisticsVehicleInfo();
            vehicleInfo.setCreateTime(createTime);
            this.setVehicleReasonNum(vehicleInfo, reason, num);
            infoMap.put(createTime, vehicleInfo);
        }
    }

    @Override
    public String exportVehicleNumberInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.dataCollectionService.getSj(dataCollectionParams);
        ArrayList<DataStatisticsVehicleInfo> infos = this.queryVehicleNumberInfo(dataCollectionParams, true);
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataStatisticsVehicleInfo info1 : infos) {
            Object[] aryData = null;
            aryData = new Object[]{info1.getCreateTime(), info1.getTotalInfoNum(), info1.getSecurityInfoNum(), info1.getIllegalInfoNum(), info1.getOtherInfoNum(), info1.getBigCar(), info1.getSmallCar(), info1.getEmbassyCar(), info1.getConsulateCar(), info1.getOverseasCar(), info1.getWheeledMotorcycl(), info1.getTemporaryMotorcycle(), info1.getPoliceCar(), info1.getTestCar(), info1.getHandCar(), info1.getTractor(), info1.getTemporaryCar(), info1.getPoliceMotorcycle(), info1.getFarmVehicles(), info1.getConsulateMotorcycle(), info1.getCoachCar(), info1.getCoachMotorcycle(), info1.getTestMotorcycle(), info1.getForeignCar(), info1.getOverseasMotorcycles(), info1.getTemporaryVehicle(), info1.getEmbassyMotorcycles(), info1.getForeignMotorcycles(), info1.getMoped(), info1.getNewEntryCar()};
            dataList.add(aryData);
        }
        String[] strs = new String[]{"\u6cbb\u5b89\u4fe1\u606f", "\u8fdd\u6cd5\u4fe1\u606f", "\u5176\u4ed6", "\u5927\u578b\u6c7d\u8f66", "\u5c0f\u578b\u6c7d\u8f66", "\u4f7f\u9986\u6c7d\u8f66", "\u9886\u9986\u6c7d\u8f66", "\u5883\u5916\u6c7d\u8f66", "\u4e24\u4e09\u8f6e\u6469\u6258\u8f66", "\u4e34\u65f6\u5165\u5883\u6469\u6258\u8f66", "\u8b66\u7528\u6c7d\u8f66", "\u8bd5\u9a8c\u6c7d\u8f66", "\u6302\u8f66", "\u62d6\u62c9\u673a", "\u4e34\u65f6\u5165\u5883\u6c7d\u8f66", "\u8b66\u7528\u6469\u6258", "\u519c\u7528\u8fd0\u8f93\u8f66", "\u9886\u9986\u6469\u6258\u8f66", "\u6559\u7ec3\u6c7d\u8f66", "\u6559\u7ec3\u6469\u6258\u8f66", "\u8bd5\u9a8c\u6469\u6258\u8f66", "\u5916\u7c4d\u6c7d\u8f66", "\u5883\u5916\u6469\u6258\u8f66", "\u4e34\u65f6\u884c\u9a76\u8f66", "\u4f7f\u9986\u6469\u6258\u8f66", "\u5916\u7c4d\u6469\u6258\u8f66", "\u8f7b\u4fbf\u6469\u6258\u8f66", "\u65b0\u80fd\u6e90\u6c7d\u8f66"};
        String name = "\u8f66\u8f86\u91c7\u96c6\u7edf\u8ba1";
        String fileName = name + sj;
        ArrayList<ExcelFirstRowBean> list = new ArrayList<ExcelFirstRowBean>(16);
        ExcelFirstRowBean b1 = new ExcelFirstRowBean("\u91c7\u96c6\u65f6\u95f4", 1, 0, 2, 0);
        ExcelFirstRowBean b5 = new ExcelFirstRowBean("\u5408\u8ba1", 1, 1, 2, 1);
        ExcelFirstRowBean b2 = new ExcelFirstRowBean("\u91c7\u96c6\u539f\u56e0", 1, 2, 1, 4);
        ExcelFirstRowBean b3 = new ExcelFirstRowBean("\u53f7\u724c\u7c7b\u578b", 1, 5, 1, 29);
        list.add(b1);
        list.add(b2);
        list.add(b3);
        list.add(b5);
        ExportExcelUtil.createCombineExcel(wb, fileName, list, strs, dataList, 2, 30);
        return ExportExcelUtil.getFileName(name, sj);
    }

    @Override
    public ArrayList<DataStatisticsCaseInfo> queryCaseNumberInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel) {
        HashMap<String, DataStatisticsCaseInfo> infoMap = new HashMap<String, DataStatisticsCaseInfo>(32);
        ArrayList list = new ArrayList(32);
        this.dealCaseReasonInfo(dataCollectionParams, isExportExcel, infoMap);
        this.dealCaseTypeInfo(dataCollectionParams, isExportExcel, infoMap);
        this.dealCaseSeverityInfo(dataCollectionParams, isExportExcel, infoMap);
        return new ArrayList<DataStatisticsCaseInfo>(infoMap.values());
    }

    private void dealCaseReasonInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel, Map<String, DataStatisticsCaseInfo> infoMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') AS createTime,\n  g.collect_reason AS reason,\n  COUNT(g.id) AS num \nFROM  t_collect_associated_case ap  LEFT JOIN t_collect_general g \n  ON ap.collect_id = g.id     where 1 = 1 and g.type_case = '1' ");
        this.addStatisticsReasonConditionSql(dataCollectionParams, sb, isExportExcel);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String reason = (String)map.get("reason");
            Long num = (Long)map.get("num");
            DataStatisticsCaseInfo caseInfo = infoMap.get(createTime);
            if (caseInfo != null) {
                this.setPersonReasonNum(caseInfo, reason, (long)num);
                continue;
            }
            caseInfo = new DataStatisticsCaseInfo();
            caseInfo.setCreateTime(createTime);
            this.setPersonReasonNum(caseInfo, reason, (long)num);
            infoMap.put(createTime, caseInfo);
        }
    }

    private void dealCaseTypeInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel, Map<String, DataStatisticsCaseInfo> infoMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  DATE_FORMAT(g.create_time, '%Y-%m-%d') AS createTime,\n  ap.type AS carType,\n  COUNT(g.id) AS num \nFROM t_collect_associated_case ap  left  join  t_collect_general g  on ap.`collect_id` = g.id  \n WHERE 1 = 1   AND g.`type_case` = '1' ");
        this.addStatisticsCaseTypeConditionSql(dataCollectionParams, sb, isExportExcel);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String type = (String)map.get("carType");
            Long num = (Long)map.get("num");
            DataStatisticsCaseInfo caseInfo = infoMap.get(createTime);
            if (caseInfo != null) {
                this.setCaseTypeNum(caseInfo, type, num);
                continue;
            }
            caseInfo = new DataStatisticsCaseInfo();
            caseInfo.setCreateTime(createTime);
            this.setCaseTypeNum(caseInfo, type, num);
            infoMap.put(createTime, caseInfo);
        }
    }

    private void dealCaseSeverityInfo(DataCollectionParams dataCollectionParams, boolean isExportExcel, Map<String, DataStatisticsCaseInfo> infoMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT   DATE_FORMAT(g.create_time, '%Y-%m-%d') AS createTime,\n  ap.degree AS degree,\n  COUNT(g.id) AS num \nFROM  t_collect_associated_case ap  left join  \n  t_collect_general g on  ap.`collect_id` = g.id  where 1 = 1 and g.`type_case` = '1' ");
        this.addStatisticsCaseSeverityConditionSql(dataCollectionParams, sb, isExportExcel);
        JDBCSession jdbcSession = this.jdbcSessionService.getJDBCSession();
        List<Map<String, Object>> mapList = jdbcSession.executeQuery(sb.toString(), null);
        for (Map<String, Object> map : mapList) {
            String createTime = (String)map.get("createTime");
            String degree = (String)map.get("degree");
            Long num = (Long)map.get("num");
            DataStatisticsCaseInfo caseInfo = infoMap.get(createTime);
            if (caseInfo != null) {
                this.setDegreeNum(caseInfo, degree, num);
                continue;
            }
            caseInfo = new DataStatisticsCaseInfo();
            caseInfo.setCreateTime(createTime);
            this.setDegreeNum(caseInfo, degree, num);
            infoMap.put(createTime, caseInfo);
        }
    }

    @Override
    public String exportCaseNumberInfo(HSSFWorkbook wb, DataCollectionParams dataCollectionParams) {
        String sj = this.dataCollectionService.getSj(dataCollectionParams);
        ArrayList<DataStatisticsCaseInfo> infos = this.queryCaseNumberInfo(dataCollectionParams, true);
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        for (DataStatisticsCaseInfo info1 : infos) {
            Object[] aryData = null;
            aryData = new Object[]{info1.getCreateTime(), info1.getTotalInfoNum(), info1.getSecurityReasonNum(), info1.getIllegalReasonNum(), info1.getOtherReasonNum(), info1.getSecurityTypeNum(), info1.getXsTypeNum(), info1.getTrafficTypeNum(), info1.getOtherTypeNum(), info1.getSeriousSeverityNum(), info1.getKindSeverityNum(), info1.getNoEffectSeverityNum()};
            dataList.add(aryData);
        }
        String name = "\u4e8b\u4ef6\u91c7\u96c6\u7edf\u8ba1";
        String fileName = name + sj;
        ArrayList<ExcelFirstRowBean> list = new ArrayList<ExcelFirstRowBean>(16);
        ExcelFirstRowBean b1 = new ExcelFirstRowBean("\u91c7\u96c6\u65f6\u95f4", 1, 0, 2, 0);
        ExcelFirstRowBean b5 = new ExcelFirstRowBean("\u5408\u8ba1", 1, 1, 2, 1);
        ExcelFirstRowBean b2 = new ExcelFirstRowBean("\u91c7\u96c6\u539f\u56e0", 1, 2, 1, 4);
        ExcelFirstRowBean b3 = new ExcelFirstRowBean("\u4e8b\u4ef6\u7c7b\u578b", 1, 5, 1, 8);
        ExcelFirstRowBean b4 = new ExcelFirstRowBean("\u4e25\u91cd\u7a0b\u5ea6", 1, 9, 1, 11);
        list.add(b1);
        list.add(b2);
        list.add(b3);
        list.add(b4);
        list.add(b5);
        String[] strs = new String[]{"\u6cbb\u5b89\u4fe1\u606f", "\u8fdd\u6cd5\u4fe1\u606f", "\u5176\u4ed6", "\u6cbb\u5b89", "\u5211\u4e8b", "\u4ea4\u901a", "\u5176\u4ed6", "\u4e25\u91cd", "\u4e00\u822c", "\u65e0\u5f71\u54cd"};
        ExportExcelUtil.createCombineExcel(wb, fileName, list, strs, dataList, 2, 12);
        return ExportExcelUtil.getFileName(name, sj);
    }

    private void addStatisticsReasonConditionSql(DataCollectionParams dataCollectionParams, StringBuilder sb, boolean isExportExcle) {
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.dataCollectionService.addCollecterIdForSql(dataCollectionParams, sb);
        this.addPageGroupByForSql(sb);
        this.dataCollectionService.addOrderByForSql(sb);
    }

    private void addStatisticsCarTypeConditionSql(DataCollectionParams dataCollectionParams, StringBuilder sb, boolean isExportExcle) {
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.dataCollectionService.addCollecterIdForSql(dataCollectionParams, sb);
        this.addGroupByCarTypeForSql(sb);
        this.dataCollectionService.addOrderByForSql(sb);
    }

    private void addStatisticsCaseTypeConditionSql(DataCollectionParams dataCollectionParams, StringBuilder sb, boolean isExportExcle) {
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.dataCollectionService.addCollecterIdForSql(dataCollectionParams, sb);
        this.addGroupByCaseTypeForSql(sb);
        this.dataCollectionService.addOrderByForSql(sb);
    }

    private void addStatisticsCaseSeverityConditionSql(DataCollectionParams dataCollectionParams, StringBuilder sb, boolean isExportExcle) {
        this.dataCollectionService.addDateForSql(dataCollectionParams, sb);
        this.dataCollectionService.addCollecterIdForSql(dataCollectionParams, sb);
        this.addGroupByCaseSeverityForSql(sb);
        this.dataCollectionService.addOrderByForSql(sb);
    }

    private void setDataPersonReasonNum(DataStatisticsDataInfo dataInfo, String reason, long num, String type) {
        if (reason.equalsIgnoreCase("collect_reason_illegal")) {
            dataInfo.setIllegalInfoNum(dataInfo.getIllegalInfoNum() + num);
        } else if (reason.equalsIgnoreCase("collect_reason_security")) {
            dataInfo.setSecurityInfoNum(dataInfo.getSecurityInfoNum() + num);
        } else if (reason.equalsIgnoreCase("collect_reason_other")) {
            dataInfo.setOtherInfoNum(dataInfo.getOtherInfoNum() + num);
        }
        if (type.equalsIgnoreCase("p")) {
            dataInfo.setPersonInfoNum(dataInfo.getPersonInfoNum() + num);
        } else if (type.equalsIgnoreCase("v")) {
            dataInfo.setVehicleInfoNum(dataInfo.getVehicleInfoNum() + num);
        } else if (type.equalsIgnoreCase("c")) {
            dataInfo.setCaseInfoNum(dataInfo.getCaseInfoNum() + num);
        }
        dataInfo.setTotalInfoNum(dataInfo.getTotalInfoNum() + num);
    }

    private void setPersonReasonNum(DataStatisticsPersonInfo personInfo, String reason, long num) {
        if (reason.equalsIgnoreCase("collect_reason_illegal")) {
            personInfo.setIllegalInfoNum(num);
        } else if (reason.equalsIgnoreCase("collect_reason_security")) {
            personInfo.setSecurityInfoNum(num);
        } else if (reason.equalsIgnoreCase("collect_reason_other")) {
            personInfo.setOtherInfoNum(num);
        }
    }

    private void setVehicleReasonNum(DataStatisticsVehicleInfo personInfo, String reason, long num) {
        if (reason.equalsIgnoreCase("collect_reason_illegal")) {
            personInfo.setIllegalInfoNum(num);
        } else if (reason.equalsIgnoreCase("collect_reason_security")) {
            personInfo.setSecurityInfoNum(num);
        } else if (reason.equalsIgnoreCase("collect_reason_other")) {
            personInfo.setOtherInfoNum(num);
        }
    }

    private void setPersonReasonNum(DataStatisticsCaseInfo personInfo, String reason, long num) {
        if (reason.equalsIgnoreCase("collect_reason_illegal")) {
            personInfo.setIllegalReasonNum(num);
        } else if (reason.equalsIgnoreCase("collect_reason_security")) {
            personInfo.setSecurityReasonNum(num);
        } else if (reason.equalsIgnoreCase("collect_reason_other")) {
            personInfo.setOtherReasonNum(num);
        }
    }

    private void setCarTypeNum(DataStatisticsVehicleInfo vehicleInfo, String type, Long num) {
        switch (type) {
            case "01": {
                vehicleInfo.setBigCar(num);
                break;
            }
            case "16": {
                vehicleInfo.setCoachCar(num);
                break;
            }
            case "17": {
                vehicleInfo.setCoachMotorcycle(num);
                break;
            }
            case "04": {
                vehicleInfo.setConsulateCar(num);
                break;
            }
            case "10": {
                vehicleInfo.setConsulateMotorcycle(num);
                break;
            }
            case "03": {
                vehicleInfo.setEmbassyCar(num);
                break;
            }
            case "09": {
                vehicleInfo.setEmbassyMotorcycles(num);
                break;
            }
            case "06": {
                vehicleInfo.setForeignCar(num);
                break;
            }
            case "13": {
                vehicleInfo.setFarmVehicles(num);
                break;
            }
            case "12": {
                vehicleInfo.setForeignMotorcycles(num);
                break;
            }
            case "15": {
                vehicleInfo.setHandCar(num);
                break;
            }
            case "08": {
                vehicleInfo.setMoped(num);
                break;
            }
            case "05": {
                vehicleInfo.setOverseasCar(num);
                break;
            }
            case "11": {
                vehicleInfo.setOverseasMotorcycles(num);
                break;
            }
            case "23": {
                vehicleInfo.setPoliceCar(num);
                break;
            }
            case "24": {
                vehicleInfo.setPoliceMotorcycle(num);
                break;
            }
            case "02": {
                vehicleInfo.setSmallCar(num);
                break;
            }
            case "20": {
                vehicleInfo.setTemporaryCar(num);
                break;
            }
            case "22": {
                vehicleInfo.setTemporaryVehicle(num);
                break;
            }
            case "21": {
                vehicleInfo.setTemporaryMotorcycle(num);
                break;
            }
            case "14": {
                vehicleInfo.setTractor(num);
                break;
            }
            case "18": {
                vehicleInfo.setTestCar(num);
                break;
            }
            case "19": {
                vehicleInfo.setTestMotorcycle(num);
                break;
            }
            case "07": {
                vehicleInfo.setWheeledMotorcycl(num);
                break;
            }
            case "25": {
                vehicleInfo.setNewEntryCar(num);
                break;
            }
        }
    }

    private void setCaseTypeNum(DataStatisticsCaseInfo caseInfo, String type, Long num) {
        switch (type) {
            case "za": {
                caseInfo.setSecurityTypeNum(num);
                break;
            }
            case "xs": {
                caseInfo.setXsTypeNum(num);
                break;
            }
            case "jt": {
                caseInfo.setTrafficTypeNum(num);
                break;
            }
            case "qt": {
                caseInfo.setOtherTypeNum(num);
                break;
            }
        }
    }

    private void addPageGroupByForSql(StringBuilder sb) {
        sb.append("  GROUP BY DATE_FORMAT(g.create_time, '%Y-%m-%d') , g.collect_reason ");
    }

    private void addGroupByCarTypeForSql(StringBuilder sb) {
        sb.append("  GROUP BY DATE_FORMAT(g.create_time, '%Y-%m-%d') , ap.card_type ");
    }

    private void addGroupByCaseTypeForSql(StringBuilder sb) {
        sb.append("  GROUP BY DATE_FORMAT(g.create_time, '%Y-%m-%d') , ap.type ");
    }

    private void addGroupByCaseSeverityForSql(StringBuilder sb) {
        sb.append("  GROUP BY DATE_FORMAT(g.create_time, '%Y-%m-%d') , ap.degree ");
    }

    private void setDegreeNum(DataStatisticsCaseInfo caseInfo, String degree, long num) {
        if (degree.equalsIgnoreCase("yz")) {
            caseInfo.setSeriousSeverityNum(num);
        } else if (degree.equalsIgnoreCase("yb")) {
            caseInfo.setKindSeverityNum(num);
        } else if (degree.equalsIgnoreCase("wyx")) {
            caseInfo.setNoEffectSeverityNum(num);
        }
    }
}

