/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.xatl.metting.bean.QueryMeetBean;
import pams.function.xatl.metting.dao.MeetingDao;
import pams.function.xatl.metting.entity.Meeting;
import pams.function.xatl.metting.entity.MeetingMember;
import pams.function.xatl.metting.util.DateUtils;
import pams.function.xatl.metting.util.MeetingConstants;

@Repository
public class MeetingDaoImpl
implements MeetingDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<MeetingMember> getMeetMemberList(QueryMeetBean queryMeetBean, Page page) {
        String userId = queryMeetBean.getUserId();
        StringBuilder sb = new StringBuilder("SELECT member.*  FROM t_xatl_meeting_member member LEFT JOIN t_xatl_meeting meet ON member.meetId=meet.id WHERE 1=1");
        ArrayList<Object> list = new ArrayList<Object>();
        sb.append("  AND member.member=?");
        list.add(userId);
        sb.append(" AND meet.pubStatus=?");
        list.add(MeetingConstants.PUBSTATUS_SUCCESS);
        if (StringUtils.isNotEmpty((String)queryMeetBean.getTitle())) {
            sb.append(" AND meet.title LIKE ?");
            list.add("%" + queryMeetBean.getTitle() + "%");
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getStartTimeStr())) {
            sb.append(" AND meet.createTime >= ?");
            list.add(DateUtils.parseDate(queryMeetBean.getStartTimeStr()));
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getEndTimeStr())) {
            sb.append(" AND meet.createTime <= ?");
            list.add(DateUtils.parseDate(queryMeetBean.getEndTimeStr()));
        }
        sb.append(" ORDER BY meet.updateTime DESC ");
        String selectCount = "select count(*) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, MeetingMember.class);
    }

    @Override
    public List<Meeting> getMeetDraftList(QueryMeetBean queryMeetBean, Page page) {
        String userId = queryMeetBean.getUserId();
        StringBuilder sb = new StringBuilder("select * from t_xatl_meeting meet where 1=1");
        ArrayList<Object> list = new ArrayList<Object>();
        sb.append(" and meet.isdraft=? and meet.isDelete=? ");
        list.add(MeetingConstants.ISDRAFT_YES);
        list.add(MeetingConstants.ISDELETE_NO);
        if (StringUtils.isNotEmpty((String)userId)) {
            sb.append(" and meet.creator=? ");
            list.add(userId);
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getTitle())) {
            sb.append(" AND meet.title LIKE ?");
            list.add("%" + queryMeetBean.getTitle() + "%");
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getStartTimeStr())) {
            sb.append(" AND meet.createTime >= ?");
            list.add(DateUtils.parseDate(queryMeetBean.getStartTimeStr()));
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getEndTimeStr())) {
            sb.append(" AND meet.createTime <= ?");
            list.add(DateUtils.parseDate(queryMeetBean.getEndTimeStr()));
        }
        sb.append(" ORDER BY meet.updateTime DESC ");
        String selectCount = "select count(*) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Meeting.class);
    }

    @Override
    public List<Meeting> getWebMeetList(QueryMeetBean queryMeetBean, Page page) {
        StringBuilder sb = new StringBuilder("select a.* from T_XATL_MEETING A  join (select distinct meet.id from T_XATL_MEETING meet LEFT JOIN t_xatl_meeting_member member ON member.meetId=meet.id ").append(" where 1=1 and( meet.creator=? or (member.member=? and meet.pubstatus=?)) and meet.isdelete = ?");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(queryMeetBean.getUserId());
        list.add(queryMeetBean.getUserId());
        list.add(MeetingConstants.PUBSTATUS_SUCCESS);
        list.add(MeetingConstants.ISDELETE_NO);
        if (StringUtils.isNotEmpty((String)queryMeetBean.getTitle())) {
            sb.append(" AND meet.title LIKE ?");
            list.add("%" + queryMeetBean.getTitle() + "%");
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getStartTimeStr())) {
            sb.append(" AND meet.createTime >= to_date('").append(queryMeetBean.getStartTimeStr()).append("', 'yyyy-mm-dd hh24:mi:ss')");
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getEndTimeStr())) {
            sb.append(" AND meet.createTime <= to_date('").append(queryMeetBean.getEndTimeStr()).append("', 'yyyy-mm-dd hh24:mi:ss')");
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getPublishId())) {
            sb.append(" AND meet.creator = ?");
            list.add(queryMeetBean.getPublishId());
        }
        if (queryMeetBean.getPubStatus() != null) {
            sb.append(" AND meet.pubStatus = ?");
            list.add(queryMeetBean.getPubStatus());
        }
        if (queryMeetBean.getIsImportant() != null) {
            sb.append(" AND meet.isImportant = ?");
            list.add(queryMeetBean.getIsImportant());
        }
        sb.append(")B on a.id=b.id ORDER BY a.pubStatus, a.updateTime DESC");
        String selectCount = "select count(*) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, Meeting.class);
    }

    @Override
    public List<Map<String, String>> getWebPublish(String userId) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(userId);
        list.add(userId);
        list.add(MeetingConstants.PUBSTATUS_SUCCESS);
        list.add(MeetingConstants.ISDELETE_NO);
        String sb = "select \"personId\" as \"code\" ,person.name \"name\" from   (select meet.creator \"personId\" from T_XATL_MEETING meet LEFT JOIN t_xatl_meeting_member member ON member.meetId=meet.id where 1=1 and( meet.creator=? or (member.member=? and meet.pubstatus=?)) and meet.isdelete = ?  group by meet.creator)t left join t_person  person on \"personId\" = person.id";
        return this.baseDao.getListBySQL(sb, list.toArray(), Map.class);
    }

    @Override
    public String addMeet(Meeting meeting) {
        meeting.setCreateTime(new Date());
        meeting.setUpdateTime(new Date());
        Serializable id = (Serializable)this.baseDao.create((Object)meeting);
        return (String)((Object)id);
    }

    @Override
    public String addMeetBySql(Meeting meeting) {
        String sql = "\tinsert into  t_xatl_meeting (id, title, startTime, endTime, place, content, isImportant, pubStatus, creator, createTime, updateTime) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(meeting.getId() == null ? "1111111" : meeting.getId());
        list.add(meeting.getTitle() == null ? "" : meeting.getTitle());
        list.add(meeting.getStartTime() == null ? new Date() : meeting.getStartTime());
        list.add(meeting.getEndTime() == null ? new Date() : meeting.getEndTime());
        list.add(meeting.getPlace() == null ? "" : meeting.getPlace());
        list.add(meeting.getContent() == null ? "" : meeting.getContent());
        list.add(meeting.getIsImportant());
        list.add(meeting.getPubStatus());
        list.add(meeting.getCreator() == null ? "" : meeting.getCreator());
        list.add(meeting.getCreateTime() == null ? new Date() : meeting.getCreateTime());
        list.add(meeting.getUpdateTime() == null ? new Date() : meeting.getCreateTime());
        return (String)this.baseDao.updateBySql(sql, list.toArray());
    }

    @Override
    public void updateMeet(Meeting meeting) {
        meeting.setUpdateTime(new Date());
        this.baseDao.update((Object)meeting);
    }

    @Override
    public void deleteMeet(Meeting meeting) {
        this.baseDao.delete((Object)meeting);
    }

    @Override
    public int getCountMeeting(String meetId, int isRead) {
        String sql = "SELECT COUNT(member.id) FROM t_xatl_meeting_member member LEFT JOIN t_xatl_meeting meet ON member.meetId=meet.id WHERE 1=1";
        sql = sql + " AND meet.id='" + meetId + "' AND member.isRead=" + isRead + " AND member.member != member.creator";
        return Integer.parseInt(this.baseDao.getSingleValue(sql));
    }

    @Override
    public Meeting getMeetInfo(String meetId) {
        return (Meeting)this.baseDao.getObjectById(Meeting.class, (Serializable)((Object)meetId));
    }

    @Override
    public List<Map<String, String>> getRootDept() {
        String sql = "select t.id \"id\", t.code \"code\",t.name \"name\" ,t.parent_id \"parentId\" from T_DEPARTMENT t where 1=1 and t.flag=0  and t.deptype='org'  and t.parent_id is null and t.display_state =1";
        return this.baseDao.getListBySQL(sql, null, Map.class);
    }

    @Override
    public List<Map<String, String>> getAllDept() {
        String sql = "select t.id \"id\", t.code \"code\",t.name \"name\" ,t.parent_id \"parentId\" from T_DEPARTMENT t where 1=1 and t.flag=0 ";
        return this.baseDao.getListBySQL(sql, null, Map.class);
    }

    @Override
    public List<Map<String, String>> getControlUser(String userId, String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(deptId);
        list.add(userId);
        String sb = "select person.id \"id\",person.code \"code\" ,person.name \"name\", person.dep_id \"deptId\" ,dept.name \"deptName\"  from T_PERSON  person  join  t_xatl_meeting_adminmember member on person.id = member.memberid   left join t_department dept on person.dep_id = dept.id where 1=1 and person.flag=0 and person.dep_id = ? and member.personId=? ";
        return this.baseDao.getListBySQL(sb, list.toArray(), Map.class);
    }

    @Override
    public List<Map<String, String>> getUser(String userId, String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        list.add(deptId);
        String sb = "  select \"id\" ,\"code\",\"name\",\"deptId\", \"deptName\", (case when \"temp\" is null then 0 else 1 end)  \"checked\"    from (select person.id \"id\" ,person.code \"code\"  ,person.name \"name\", person.dep_id \"deptId\" , dept.name \"deptName\" ,(select member.memberid from t_xatl_meeting_adminmember member where 1=1 and member.memberid=person.id  and member.personid=?) \"temp\" from T_PERSON  person left join t_department dept on person.dep_id = dept.id where 1=1 and person.flag=0 and person.dep_id = ?)t ";
        return this.baseDao.getListBySQL(sb, list.toArray(), Map.class);
    }

    @Override
    public List<Map<String, String>> getAllUser(String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(deptId);
        String sb = " select person.id  \"id\",person.code \"code\" ,person.name \"name\", person.dep_id  \"deptId\" ,dept.name \"deptName\" , (case when person.id = person.dep_id then 1 else 0 end) \"checked\"  from T_PERSON  person left join t_department dept on person.dep_id = dept.id where 1=1  and person.flag=0 and person.dep_id = ? ";
        return this.baseDao.getListBySQL(sb, list.toArray(), Map.class);
    }

    @Override
    public List<Map<String, Object>> getAdminUser(String userId, String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(deptId);
        String sb = " select \"id\", \"code\", \"text\",(case when \"temp\" is null then  0  else  1   end) \"checked\"   from (select person.id \"id\",  person.code \"code\",  person.name \"text\",  (select admin.personId  from t_xatl_meeting_admin admin  where 1 = 1  and admin.personId = person.id) \"temp\"  from T_PERSON person  left join t_department dept  on person.dep_id = dept.id  where 1 = 1  and person.flag = 0  and person.dep_id = ?) t";
        return this.baseDao.getListBySQL(sb, list.toArray(), Map.class);
    }

    private List<Map<String, Object>> getAdminMemberUserBackup(String userId, String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        StringBuilder sb = new StringBuilder("  select \"id\", \"code\", \"text\", \"deptId\", \"deptName\",(case when \"temp\" is null then  0  else  1  end) \"checked\"").append(" from (select person.id \"id\",  person.code \"code\",  person.name \"text\",  dept.id \"deptId\", dept.name \"deptName\", (select member.memberId  from t_xatl_meeting_adminmember member").append(" left join t_xatl_meeting_admin admin on member.personid = admin.personid ").append(" where 1 = 1  and member.memberId = person.id and  member.personId= ?) \"temp\"").append("  from T_PERSON person  left join t_department dept  on person.dep_id = dept.id  where 1 = 1  and person.flag = 0").append(" ");
        if (StringUtils.isNotEmpty((String)deptId)) {
            sb.append("and person.dep_id = ?");
            list.add(deptId);
        }
        sb.append(" ) t");
        return this.baseDao.getListBySQL(sb.toString(), list.toArray(), Map.class);
    }

    @Override
    public List<Map<String, Object>> getAdminMemberUser(String userId, String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        StringBuilder sb = new StringBuilder("    select person.id \"id\",  person.code \"code\",  person.name \"text\" ,dept.id \"deptId\", dept.name \"deptName\",(case when person.id = person.dep_id then 1 else 0 end)\"checked\"").append(" from t_xatl_meeting_adminmember adminmember left join  T_PERSON person on adminmember.memberid = person.id").append("  left join t_department dept  on person.dep_id = dept.id  where 1 = 1  and person.flag = 0 and adminmember.personid =?").append("  ");
        if (StringUtils.isNotEmpty((String)deptId)) {
            sb.append("and person.dep_id = ?");
            list.add(deptId);
        }
        return this.baseDao.getListBySQL(sb.toString(), list.toArray(), Map.class);
    }

    @Override
    public List<Map<String, Object>> getAdminMemberUserToCheck(String userId, String meetId, String deptId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        list.add(meetId);
        list.add(userId);
        StringBuilder sb = new StringBuilder(" select \"id\", \"code\", \"text\",(case when \"temp\" is null then 0 else 1 end) \"checked\", \"deptId\", \"deptName\"").append(" from (select person.id \"id\", person.code \"code\",  person.name \"text\", dept.id \"deptId\", dept.name \"deptName\",").append(" (select meetmember.member from t_xatl_meeting_member meetmember  where 1 = 1").append(" and meetmember.creator = ?  and meetmember.meetid = ? and meetmember.member = person.id) \"temp\"").append(" from t_xatl_meeting_adminmember adminmember left join t_xatl_meeting_admin admin  on admin.personid = adminmember.personid").append(" left join T_PERSON person  on adminmember.memberid = person.id  left join t_department dept on person.dep_id = dept.id").append("  where 1 = 1 and person.flag = 0  and adminmember.personid = ?");
        if (StringUtils.isNotEmpty((String)deptId)) {
            sb.append("and person.dep_id = ?");
            list.add(deptId);
        }
        sb.append(") t");
        return this.baseDao.getListBySQL(sb.toString(), list.toArray(), Map.class);
    }
}

