/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

public class BeanUtil {
    private static ObjectMapper mapper;
    private static ApplicationContext context;

    private static void init() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        if (context == null) {
            context = ContextLoader.getCurrentWebApplicationContext();
        }
    }

    public static String toJsonStr(Object value) throws Exception {
        return mapper.writeValueAsString(value);
    }

    public static Map<String, Object> jsonToMap(String json) throws JsonParseException, JsonMappingException, IOException {
        return (Map)mapper.readValue(json, HashMap.class);
    }

    public static Object getSpringBean(String beanName) {
        return context.getBean(beanName);
    }

    public static Object getSpringBean(Class<?> clazz) {
        return context.getBean(clazz);
    }

    public static void copyProperties(Object from, Object to) {
        ArrayList<Object> fields = new ArrayList<Object>();
        Method getMethod = null;
        Method setMethod = null;
        try {
            Class<?> c1 = from.getClass();
            Class<?> c2 = to.getClass();
            Object[] fs1 = c1.getDeclaredFields();
            Object[] fs1Super = c1.getSuperclass().getDeclaredFields();
            if (fs1Super != null && fs1Super.length > 0) {
                fs1 = (Field[])ArrayUtils.addAll((Object[])fs1, (Object[])fs1Super);
            }
            Object[] fs2 = c2.getDeclaredFields();
            Object[] fs2Super = c2.getSuperclass().getDeclaredFields();
            if (fs2Super != null && fs2Super.length > 0) {
                fs2 = (Field[])ArrayUtils.addAll((Object[])fs2, (Object[])fs2Super);
            }
            block2: for (Object aFs2 : fs2) {
                for (Object aFs1 : fs1) {
                    if (!((Field)aFs1).getName().equals(((Field)aFs2).getName())) continue;
                    fields.add(aFs1);
                    continue block2;
                }
            }
            if (fields.size() > 0) {
                for (Object e : fields) {
                    Field f = (Field)e;
                    String fileName = f.getName();
                    String str = fileName.substring(0, 1).toUpperCase();
                    String getName = "get" + str + fileName.substring(1);
                    String setName = "set" + str + fileName.substring(1);
                    getMethod = c1.getMethod(getName, new Class[0]);
                    setMethod = c2.getMethod(setName, f.getType());
                    Object o = getMethod.invoke(from, new Object[0]);
                    if (null == o) continue;
                    setMethod.invoke(to, o);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        BeanUtil.init();
    }
}

