/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String DISPLAY_DATE = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String YYYY_MM_DD_HH_MM_ZH = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static final String DATE = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String MONTH = "yyyy-MM";
    public static final String HH_MM = "HH:mm";
    public static final String YMD = "yyyyMMdd";
    public static final int ONE_DAY_HOURS = 24;
    public static final int ONE_MINUTE_SECONDS = 60;
    public static final int ONE_HOUR_MINUTES = 60;
    public static final int ONE_SECOND_MILLISECOND = 1000;
    public static final int ONE_DAY_TIME = 86400;

    public static Date now() {
        return DateUtils.getCalendar().getTime();
    }

    public static Date now(String format) {
        return DateUtils.parseDate(DateUtils.formatDate(DateUtils.now(), format), format);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(Locale.CHINA);
    }

    public static Calendar getCalendar(Date date) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static int getDay(Date date) {
        return DateUtils.getCalendar(date).get(5);
    }

    public static Calendar getCalendar(int year, int month, int date) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.clear();
        calendar.set(year, month - 1, date);
        return calendar;
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String formatDate(Date date, String format, boolean lenient) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(lenient);
        return dateFormat.format(date);
    }

    public static Date parseDate(String date, String format, boolean lenient) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(lenient);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String date) {
        if (StringUtils.isEmpty((String)date)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_TIME);
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean validDate(String date, String format) {
        return DateUtils.parseDate(date, format) != null;
    }

    public static String formatTimeAxis(Date date) {
        Calendar now = DateUtils.getCalendar();
        Calendar cal = DateUtils.getCalendar(date);
        if (now.get(1) != cal.get(1)) {
            return DateUtils.formatDate(date, YYYY_MM_DD_HH_MM_ZH);
        }
        Calendar c1 = DateUtils.getCalendar(now.get(1), now.get(2) + 1, now.get(5));
        Calendar c2 = DateUtils.getCalendar(cal.get(1), cal.get(2) + 1, cal.get(5));
        long dateDiff = c1.getTimeInMillis() - c2.getTimeInMillis();
        long diffDays = dateDiff / 86400000L;
        int twoDayAgo = 2;
        int threeDayAgo = 3;
        if (diffDays == 0L) {
            long diff = now.getTime().getTime() - date.getTime();
            long diffMinutes = diff / 60000L % 60L;
            long diffHours = diff / 3600000L % 24L;
            if (diff < 60000L) {
                return "\u521a\u521a";
            }
            if (diff < 3600000L) {
                return diffMinutes + "\u5206\u949f\u524d";
            }
            if (diff < 86400000L) {
                return diffHours + "\u5c0f\u65f6\u524d";
            }
        } else {
            if (diffDays == 1L) {
                return "\u6628\u5929" + DateUtils.formatDate(date, HH_MM);
            }
            if (diffDays == (long)twoDayAgo) {
                return "\u4e24\u5929\u524d" + DateUtils.formatDate(date, HH_MM);
            }
            if (diffDays == (long)threeDayAgo) {
                return "\u4e09\u5929\u524d" + DateUtils.formatDate(date, HH_MM);
            }
        }
        return DateUtils.formatDate(date, YYYY_MM_DD_HH_MM_ZH);
    }

    public static Date timestampToDate(Timestamp timestamp) {
        return new Date(timestamp.getTime());
    }

    public static Date maxDate(Date date) {
        Calendar cal = DateUtils.getCalendar(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date minDate(Date date) {
        Calendar cal = DateUtils.getCalendar(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date nextDate(Date date) {
        Calendar cal = DateUtils.getCalendar(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static boolean validateDateRange(String startDateStr, String endDateStr) {
        Date startDate = null;
        Date now = DateUtils.now(DATE);
        if (StringUtils.isNotBlank((String)startDateStr)) {
            startDate = DateUtils.parseDate(startDateStr, DATE);
            if (startDate == null) {
                return false;
            }
            if (startDate.after(now)) {
                return false;
            }
        }
        Date endDate = null;
        if (StringUtils.isNotBlank((String)endDateStr)) {
            endDate = DateUtils.parseDate(endDateStr, DATE);
            if (endDate == null) {
                return false;
            }
            if (endDate.after(now)) {
                return false;
            }
        }
        return startDate == null || endDate == null || !startDate.after(endDate);
    }

    public static String getSundayOfThisWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayOfWeek = c.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        c.add(5, -dayOfWeek + 7);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE);
        return sdf.format(c.getTime());
    }

    public static int getDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayOfWeek = c.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        return dayOfWeek;
    }

    public static Date getMondayOfNextWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayOfWeek = c.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        c.add(5, -dayOfWeek + 7 + 1);
        return c.getTime();
    }

    public static String getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE);
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public static Date getLastDayOfMonthDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE);
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public static Date getFirstDayOfMonthDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNextDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static List<Integer> getDays(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        int minimum = calendar.getActualMinimum(5);
        int maximum = calendar.getActualMaximum(5);
        ArrayList<Integer> days = new ArrayList<Integer>(maximum);
        for (int i = minimum; i <= maximum; ++i) {
            days.add(i);
        }
        return days;
    }

    public static List<Integer> getDaysLimitNow(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        int minimum = calendar.getActualMinimum(5);
        int maximum = calendar.getActualMaximum(5);
        Calendar nowCalendar = DateUtils.getCalendar();
        if (calendar.get(1) == nowCalendar.get(1) && calendar.get(2) == nowCalendar.get(2)) {
            maximum = nowCalendar.get(5);
        }
        ArrayList<Integer> days = new ArrayList<Integer>(maximum);
        for (int i = minimum; i <= maximum; ++i) {
            days.add(i);
        }
        return days;
    }

    public static List<Integer> getMonthsLimitLastMonth(int year) {
        Calendar calendar = DateUtils.getCalendar();
        int curYear = calendar.get(1);
        int curMonth = calendar.get(2);
        int minimum = 1;
        int maximum = 12;
        if (curYear == year) {
            maximum = curMonth;
        }
        ArrayList<Integer> months = new ArrayList<Integer>(maximum);
        for (int i = minimum; i <= maximum; ++i) {
            months.add(i);
        }
        return months;
    }

    public static int compare(Date date1, Date date2) {
        long l2;
        long l1 = date1.getTime();
        if (l1 > (l2 = date2.getTime())) {
            return 1;
        }
        if (l1 == l2) {
            return 0;
        }
        if (l1 < l2) {
            return -1;
        }
        return 0;
    }

    public static int diffDays(Date date1, Date date2) {
        int day = (int)((date1.getTime() - date2.getTime()) / 86400000L);
        return day;
    }

    public static String convertDate(String date, String format) {
        return DateUtils.formatDate(DateUtils.parseDate(date, format), format);
    }

    public static List<Date> getIntervalDays(Date date, int interval) {
        Calendar firstDayCal = DateUtils.getCalendar(date);
        int limit = interval;
        int step = 1;
        if (interval < 0) {
            step = -1;
            limit = -interval;
        }
        ArrayList<Date> dates = new ArrayList<Date>(limit);
        while (dates.size() < limit) {
            firstDayCal.add(5, step);
            dates.add(firstDayCal.getTime());
        }
        return dates;
    }

    public static Date getLastMonth() {
        Calendar calendar = DateUtils.getCalendar();
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static int countMonths(Date startDate, Date endDate) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c2.setTime(startDate);
        c1.setTime(endDate);
        int year = c2.get(1) - c1.get(1);
        if (year < 0) {
            year = -year;
            return year * 12 + c1.get(2) - c2.get(2);
        }
        return year * 12 + c2.get(2) - c1.get(2);
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static Date[] getSeasonDate(Date date) {
        Date[] season = new Date[2];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int secSeason = 2;
        int thirdSeason = 3;
        int fouthSeason = 4;
        int nSeason = DateUtils.getSeason(date);
        if (nSeason == 1) {
            c.set(2, 0);
            season[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
            c.set(2, 2);
            season[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        } else if (nSeason == secSeason) {
            c.set(2, 3);
            season[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
            c.set(2, 5);
            season[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        } else if (nSeason == thirdSeason) {
            c.set(2, 6);
            season[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
            c.set(2, 8);
            season[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        } else if (nSeason == fouthSeason) {
            c.set(2, 9);
            season[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
            c.set(2, 11);
            season[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        }
        return season;
    }

    public static Date[] getHalfYear(Date date) {
        Date[] result = new Date[2];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        int halfYear = 5;
        if (month <= halfYear) {
            c.set(2, 0);
            result[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
            c.set(2, 5);
            result[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        } else {
            c.set(2, 6);
            result[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
            c.set(2, 11);
            result[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        }
        return result;
    }

    public static Date[] getYear(Date date) {
        Date[] result = new Date[2];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(2, 0);
        result[0] = DateUtils.getFirstDayOfMonthDate(c.getTime());
        c.set(2, 11);
        result[1] = DateUtils.getLastDayOfMonthDate(c.getTime());
        return result;
    }

    public static Date getDateForHourChange(Date date, int hour) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, hour);
        return c.getTime();
    }

    public static Date getDateForMinuteChange(Date date, int minute) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, minute);
        return c.getTime();
    }
}

