/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.xatl.ruyihu.bean.ApplyMoneyDetailBean;
import pams.function.xatl.ruyihu.entity.ApplyMoneyEntity;
import pams.function.xatl.ruyihu.service.IApplyMoneyService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
@Scope(value="session")
public class ApplyMoneyController
extends BaseControler {
    private static final Logger logger = LoggerFactory.getLogger(ApplyMoneyController.class);
    @Resource
    private IApplyMoneyService applyMoneyService;
    @Resource
    private UserManageService userManageService;

    @RequestMapping(value={"ruyihu/applyMoneyController/dailyListPage.do"})
    public String dailyListPage() {
        return "ruyihu/applymoney/default/dailyList";
    }

    @RequestMapping(value={"ruyihu/applyMoneyController/govListPage.do"})
    public String govListPage() {
        return "ruyihu/applymoney/default/govList";
    }

    @RequestMapping(value={"ruyihu/applyMoneyController/detailPage.do"})
    public String detailPage() {
        return "ruyihu/applymoney/default/detailPage";
    }

    @RequestMapping(value={"ruyihu/applyMoneyController/delete.do"})
    public void delete(String applyId, HttpServletResponse response) {
        this.applyMoneyService.delete(applyId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/ruyihu/applyMoneyController/detail.do"})
    public void detail(String applyId, HttpServletResponse response) {
        ApplyMoneyDetailBean applyMoneyDetail = this.applyMoneyService.applyMoneyDetail(null, applyId);
        Util.writeUtf8Text((HttpServletResponse)response, (String)QuickJson.toJsonStr(applyMoneyDetail));
    }

    @RequestMapping(value={"/ruyihu/applyMoneyController/list.do"})
    public void list(@RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, @RequestParam(required=false) Integer applyType, @RequestParam(required=false) String applyDept, @RequestParam(required=false) String projectName, @RequestParam(required=false) Integer status, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, HttpServletResponse response) {
        Page pageParam = new Page(page, rows);
        List<ApplyMoneyEntity> list = this.applyMoneyService.applyMoneyList(applyType, applyDept, projectName, status, startDate, endDate, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(list)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (ApplyMoneyEntity applyMoney : list) {
                Person person = this.userManageService.queryPersonById(applyMoney.getApplyUserId());
                ObjectNode node = QuickJson.newObjectNode();
                node.put("applyId", applyMoney.getApplyId());
                node.put("applyType", applyMoney.getApplyType());
                node.put("applyDate", applyMoney.getApplyDate());
                node.put("projectName", applyMoney.getProjectName());
                node.put("applyDept", applyMoney.getApplyDept());
                node.put("applyUserId", applyMoney.getApplyUserId());
                node.put("applyUserName", person.getName());
                node.put("status", applyMoney.getStatus());
                node.put("money", applyMoney.getMoney());
                rowsNode.add((JsonNode)node);
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        logger.info("\u8c03\u7528list\u7ed3\u679c\uff1a" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"/ruyihu/applyMoneyController/pdf.do"})
    public void pdf(String applyId, HttpServletResponse response) throws Exception {
        AbstractMyAssert.hasText(applyId, "applyId \u4e0d\u80fd\u4e3a\u7a7a");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        byte[] bytes = this.applyMoneyService.reportToPDF(applyId);
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", "attachment;fileName=applyMoney" + DateFormatUtils.format((Date)LakeMobUtils.now(), (String)"yyyyMMddHHmmss") + ".pdf");
        response.setContentLength(bytes.length);
        servletOutputStream.write(bytes, 0, bytes.length);
        servletOutputStream.flush();
        servletOutputStream.close();
    }
}

