/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.service.CommonTreeService;
import com.xdja.pams.common.util.Util;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.xatl.ruyihu.entity.AuthEntity;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
@Scope(value="session")
public class AuthController
extends BaseControler {
    @Autowired
    private CommonTreeService commonTreeService;
    @Autowired
    private AuthService authService;
    @Autowired
    private UserManageService userManageService;
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);

    @RequestMapping(value={"ruyihu/authController/leaveApprovalAuthPage.do"})
    public String leaveApprovalAuthPage() {
        return "ruyihu/auth/default/leaveApprovalAuth";
    }

    @RequestMapping(value={"ruyihu/authController/meetingSummaryQueryAuthPage.do"})
    public String meetingSummaryQueryAuthPage() {
        return "ruyihu/auth/default/meetingSummaryQueryAuth";
    }

    @RequestMapping(value={"ruyihu/authController/managerSettingPage.do"})
    public String managerSettingPage() {
        return "ruyihu/auth/default/managerSetting";
    }

    @Deprecated
    @RequestMapping(value={"ruyihu/authController/getLeaveApprovalAuth.do"})
    public void getLeaveApprovalAuth(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String rootId) {
    }

    @Deprecated
    @RequestMapping(value={"ruyihu/authController/updateLeaveApprovalAuth.do"})
    public void updateLeaveApprovalAuth(HttpServletResponse response, @RequestParam String personList) {
    }

    @RequestMapping(value={"ruyihu/authController/updateMeetingSummaryQueryAuth.do"})
    public void updateMeetingSummaryQueryAuth(HttpServletResponse response, @RequestParam String personList) {
        AbstractMyAssert.hasText(personList, "personList \u4e0d\u80fd\u4e3a\u7a7a");
        Iterable ids = Splitter.on((String)",").omitEmptyStrings().split((CharSequence)personList);
        this.authService.updateMeetingSummaryQueryAuth(Lists.newArrayList((Iterable)ids));
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/authController/getMeetingSummaryQueryAuthList.do"})
    public void getMeetingSummaryQueryAuthList(HttpServletResponse response) {
        List<AuthEntity> authorizedList = this.authService.getMeetingSummaryQueryAuthList();
        ArrayNode rst = QuickJson.newArrayNode();
        for (AuthEntity one : authorizedList) {
            Person person = this.userManageService.queryPersonById(one.getPersonId());
            ObjectNode tmp = QuickJson.newObjectNode().put("id", one.getAuthId()).put("depName", person.getDepartment().getName()).put("personId", one.getPersonId()).put("personName", person.getName()).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd"));
            rst.add((JsonNode)tmp);
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/authController/getMeetingSummaryQueryAuth.do"})
    public void getMeetingSummaryQueryAuth(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String rootId) {
        Set<String> authorizedSet = this.authService.getMeetingSummaryQueryAuth();
        this.generateDepAndPersonTreeJson(request, response, id, rootId, authorizedSet);
    }

    private void generateDepAndPersonTreeJson(HttpServletRequest request, HttpServletResponse response, String id, String rootId, Set<String> authorizedSet) {
        String jsonlist = "";
        try {
            String controlPolices = this.getControlPolices(request);
            String controlDeps = this.getControlDeps(request);
            List listmap = this.commonTreeService.getDepAndPersonJson(id, rootId, controlDeps, controlPolices);
            for (Map one : listmap) {
                Object itemId = one.get("id");
                if (authorizedSet.contains(itemId)) {
                    one.put("checked", true);
                    continue;
                }
                one.put("checked", false);
            }
            jsonlist = Util.toJsonStr((Object)listmap);
        }
        catch (Exception e) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + id + "\u3011\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)jsonlist);
    }

    @RequestMapping(value={"ruyihu/authController/getOfficeLeader.do"})
    public void getOfficeLeader(HttpServletResponse response) {
        Person leader = this.authService.getOfficeLeaderPerson();
        ObjectNode rst = QuickJson.newObjectNode();
        if (leader != null) {
            rst.put("personId", leader.getId());
            rst.put("personName", leader.getName());
        } else {
            rst.put("personId", "");
            rst.put("personName", "");
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/authController/updateLeader.do"})
    public void updateLeader(HttpServletResponse response, @RequestParam String personId) {
        AbstractMyAssert.hasText(personId, "personId \u4e0d\u80fd\u4e3a\u7a7a");
        this.authService.updateOfficeLeader(personId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/authController/getFinLeader.do"})
    public void getFinLeader(HttpServletResponse response) {
        Person leader = this.authService.getFinLeaderPerson();
        ObjectNode rst = QuickJson.newObjectNode();
        if (leader != null) {
            rst.put("personId", leader.getId());
            rst.put("personName", leader.getName());
        } else {
            rst.put("personId", "");
            rst.put("personName", "");
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/authController/updateFinLeader.do"})
    public void updateFinLeader(HttpServletResponse response, @RequestParam String personId) {
        AbstractMyAssert.hasText(personId, "personId \u4e0d\u80fd\u4e3a\u7a7a");
        this.authService.updateFinLeader(personId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }
}

