/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Util;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.xatl.ruyihu.entity.CalendarEntity;
import pams.function.xatl.ruyihu.service.CalendarService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
@Scope(value="session")
public class CalendarController
extends BaseControler {
    @Resource
    private CalendarService calendarService;
    public static final Logger LOGGER = LoggerFactory.getLogger(CalendarController.class);

    @RequestMapping(value={"ruyihu/calendarController/setDate.do"})
    public void setDate(@RequestParam(required=false) String daily, @RequestParam(required=false) String type, HttpServletResponse response, HttpServletRequest request) {
        LOGGER.info("\u8c03\u7528setDate\uff0cdaily:" + daily + ", type:" + type);
        if (StringUtils.isEmpty((CharSequence)daily) || StringUtils.isEmpty((CharSequence)type)) {
            throw new LakeMobException("daily\u548ctype\u53c2\u6570\u5747\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date date = null;
        try {
            date = Util.parseDate((String)daily, (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            LOGGER.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        if (!"work".equals(type) && !"rest".equals(type)) {
            LOGGER.error("type\u7c7b\u578b\u9519\u8bef\uff1a{}", (Object)type);
            throw new LakeMobException("type\u7c7b\u578b\u9519\u8bef");
        }
        this.calendarService.setDate(date, type);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/calendarController/querySpecialDate.do"})
    public void querySpecialDate(@RequestParam(required=false) String month, HttpServletResponse response, HttpServletRequest request) {
        LOGGER.info("\u8c03\u7528querySpecialDate\uff0cmonth:" + month);
        if (StringUtils.isEmpty((CharSequence)month)) {
            throw new LakeMobException("month\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date beginDate = null;
        try {
            beginDate = Util.parseDate((String)(month + "-01"), (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            LOGGER.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        Date endDate = this.calendarService.getLastDayOfMonth(beginDate);
        List<CalendarEntity> calendarEntityList = this.calendarService.queryCalendarEntityList(beginDate, endDate);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("total", calendarEntityList.size());
        result.put("rows", calendarEntityList);
        String json = Util.toJsonStr(result);
        LOGGER.info("\u8c03\u7528querySpecialDate\u7684\u7ed3\u679c:" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }
}

