/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import org.activiti.engine.RuntimeService;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.bean.StartIssueForm;
import pams.function.xatl.ruyihu.bean.StartReceiveForm;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.NoticeEntity;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.service.DocumentReportService;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
@Scope(value="session")
public class DocumentController
extends BaseControler {
    public static final Logger LOGGER = LoggerFactory.getLogger(DocumentController.class);
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private DocumentService documentService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private NoticeService noticeService;
    @Resource
    private UserManageService userManageService;
    @Resource
    private ElectronicSignService electronicSignService;
    @Resource
    private AuthService authService;
    @Resource
    private DocumentReportService documentReportService;

    @RequestMapping(value={"ruyihu/documentController/deleteProcess.do"})
    public void deleteProcess(@RequestParam String id, HttpServletResponse response) {
        this.runtimeService.deleteProcessInstance(id, "delete");
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/documentController/issueDocumentPage.do"})
    public String issueDocumentPage() {
        return "ruyihu/document/default/issueDocument";
    }

    @RequestMapping(value={"ruyihu/documentController/receiveDocumentPage.do"})
    public String receiveDocumentPage() {
        return "ruyihu/document/default/receiveDocument";
    }

    @RequestMapping(value={"ruyihu/documentController/documentListPage.do"})
    public String documentListPage() {
        return "ruyihu/document/default/documentList";
    }

    @RequestMapping(value={"ruyihu/documentController/documentDetailPage.do"})
    public String documentDetailPage() {
        return "ruyihu/document/default/documentDetail";
    }

    @RequestMapping(value={"ruyihu/documentController/startIssueDocument.do"}, method={RequestMethod.POST})
    public void startIssueDocument(StartIssueForm form, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 startIssueDocument");
        AbstractMyAssert.hasText(form.getTitle(), "title \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.hasText(form.getType(), "type \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.isTrue(LakeMobUtils.DOCUMENT_TYPE_MAP.containsKey(form.getType()), "type\u503c\u4e0d\u5bf9");
        if (!StringUtils.hasText((String)form.getIssueOffice())) {
            form.setIssueOffice("");
        }
        if (!StringUtils.hasText((String)form.getShortName())) {
            form.setShortName("");
        }
        AbstractMyAssert.hasText(form.getIssueDate(), "issueDate \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.hasText(form.getPersonId(), "personId \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.isTrue(!CollectionUtils.isEmpty(form.getOfficeFlowPersonList()), "officeFlowPersonList \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.isTrue(!CollectionUtils.isEmpty(form.getDoneFlowPersonList()), "doneFlowPersonList \u4e0d\u80fd\u4e3a\u7a7a");
        if (!CollectionUtils.isEmpty(form.getAttachmentList())) {
            ArrayList uploadFileList = Lists.newArrayList();
            for (MultipartFile one : form.getAttachmentList()) {
                if (one.isEmpty()) continue;
                FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(one, one.getOriginalFilename());
                uploadFileList.add(fastFileInfo);
            }
            form.setFastFileList(uploadFileList);
        }
        LakeMobUtils.removeDuplication(form.getOfficeFlowPersonList());
        LakeMobUtils.removeDuplication(form.getCountersignFlowPersonList());
        LakeMobUtils.removeDuplication(form.getIssueFlowPersonList());
        LakeMobUtils.removeDuplication(form.getDoneFlowPersonList());
        if (form.getCountersignFlowPersonList() == null) {
            form.setCountersignFlowPersonList(new ArrayList<String>());
        }
        if (form.getIssueFlowPersonList() == null) {
            form.setIssueFlowPersonList(new ArrayList<String>());
        }
        String documentId = this.documentService.startIssueDocument(form);
        ObjectNode rst = QuickJson.newObjectNode().put("documentId", documentId);
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/documentController/getDocumentList.do"})
    public void getDocumentList(@RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, @RequestParam(required=false) String titleLike, @RequestParam(required=false) String type, @RequestParam(required=false) String status, @RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, HttpServletResponse response, HttpServletRequest request) {
        LOGGER.info("\u8c03\u7528 getDocumentList");
        Page pageParam = new Page(page, rows);
        Date begin = LakeMobUtils.parseDate(beginDate);
        Date end = LakeMobUtils.parseDate(endDate);
        if (StringUtils.hasText((String)type)) {
            AbstractMyAssert.isTrue(LakeMobUtils.DOCUMENT_TYPE_MAP.containsKey(type), "type\u503c\u4e0d\u5bf9");
        }
        Set<String> meetingSummaryQueryAuth = this.authService.getMeetingSummaryQueryAuth();
        this.setOperator(request);
        boolean hasSummaryAuth = meetingSummaryQueryAuth.contains(this.person.getId());
        List<DocumentEntity> datas = this.documentService.getDocumentList(begin, end, titleLike, type, status, hasSummaryAuth, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(datas)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (DocumentEntity one : datas) {
                ObjectNode doc = QuickJson.newObjectNode().put("documentId", one.getDocumentId()).put("issueDate", DateFormatUtils.format((Date)one.getIssueDate(), (String)"yyyy/MM/dd")).put("title", one.getDocumentTitle()).put("typeDesc", LakeMobUtils.DOCUMENT_TYPE_MAP.get(one.getDocumentType())).put("issueOffice", one.getIssueOffice()).put("shortName", one.getShortName()).put("statusDesc", LakeMobUtils.DOCUMENT_STATUS_MAP.get(one.getApprovalStatus())).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd"));
                List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(one.getDocumentId(), "doc");
                ArrayNode attachArrNode = QuickJson.newArrayNode();
                for (AttachmentEntity att : attachments) {
                    attachArrNode.add((JsonNode)QuickJson.newObjectNode().put("id", att.getAttachmentId()).put("name", att.getAttachmentName()).put("size", att.getAttachmentSize()).put("url", this.fastDFSClientService.getRealDownloadUrl(att.getAttachmentUrl())));
                }
                doc.put("attachmentList", (JsonNode)attachArrNode);
                rowsNode.add((JsonNode)doc);
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/documentController/startReceiveDocument.do"}, method={RequestMethod.POST})
    public void startReceiveDocument(StartReceiveForm form, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 startReceiveDocument");
        AbstractMyAssert.hasText(form.getTitle(), "title \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.hasText(form.getType(), "type \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.isTrue(LakeMobUtils.DOCUMENT_TYPE_MAP.containsKey(form.getType()), "type\u503c\u4e0d\u5bf9");
        if (!StringUtils.hasText((String)form.getIssueOffice())) {
            form.setIssueOffice("");
        }
        if (!StringUtils.hasText((String)form.getShortName())) {
            form.setShortName("");
        }
        AbstractMyAssert.hasText(form.getIssueDate(), "issueDate \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.hasText(form.getPersonId(), "depId \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.isTrue(!CollectionUtils.isEmpty(form.getOpinionFlowPersonList()), "opinionFlowPersonList \u4e0d\u80fd\u4e3a\u7a7a");
        AbstractMyAssert.isTrue(!CollectionUtils.isEmpty(form.getDoneFlowPersonList()), "doneFlowPersonList \u4e0d\u80fd\u4e3a\u7a7a");
        if (!CollectionUtils.isEmpty(form.getAttachmentList())) {
            ArrayList uploadFileList = Lists.newArrayList();
            for (MultipartFile one : form.getAttachmentList()) {
                if (one.isEmpty()) continue;
                FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(one, one.getOriginalFilename());
                uploadFileList.add(fastFileInfo);
            }
            form.setFastFileList(uploadFileList);
        }
        LakeMobUtils.removeDuplication(form.getOpinionFlowPersonList());
        LakeMobUtils.removeDuplication(form.getLeaderFlowPersonList());
        LakeMobUtils.removeDuplication(form.getDoneFlowPersonList());
        if (form.getLeaderFlowPersonList() == null) {
            form.setLeaderFlowPersonList(new ArrayList<String>());
        }
        String documentId = this.documentService.startReceiveDocument(form);
        ObjectNode rst = QuickJson.newObjectNode().put("documentId", documentId);
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/documentController/getDocumentDetail.do"})
    public void getDocumentDetail(@RequestParam(required=false) String documentId, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 getDocumentDetail");
        AbstractMyAssert.hasText(documentId, "documentId \u4e0d\u80fd\u4e3a\u7a7a");
        DocumentEntity doc = this.documentService.getDocumentById(documentId);
        AbstractMyAssert.notNull(doc, "\u65e0\u6cd5\u627e\u5230\u516c\u6587" + documentId);
        if ("doc_type_publish_summary".equals(doc.getDocumentType())) {
            Set<String> meetingSummaryQueryAuth = this.authService.getMeetingSummaryQueryAuth();
            this.setOperator(request);
            boolean contains = meetingSummaryQueryAuth.contains(this.person.getId());
            AbstractMyAssert.isTrue(contains, "\u65e0\u6743\u6d4f\u89c8\u8be5\u516c\u6587");
        }
        List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(documentId, "doc");
        List<FlowAssociateEntity> flowAssociates = this.flowAssociateService.getFlowAssociateListByDocumentIdMergeDoneTask(documentId);
        List<FlowTraceEntity> flowTraces = this.flowTraceService.getFlowTraceListByDocumentId(documentId);
        List<NoticeEntity> copyList = this.noticeService.getCopyListByDocumentId(documentId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        Person authorPerson = this.userManageService.queryPersonById(doc.getPersonId());
        root.put("documentId", doc.getDocumentId()).put("issueDate", DateFormatUtils.format((Date)doc.getIssueDate(), (String)"yyyy/MM/dd")).put("shortName", doc.getShortName()).put("typeDesc", LakeMobUtils.DOCUMENT_TYPE_MAP.get(doc.getDocumentType())).put("statusDesc", LakeMobUtils.DOCUMENT_STATUS_MAP.get(doc.getApprovalStatus())).put("issueOffice", doc.getIssueOffice()).put("title", doc.getDocumentTitle()).put("personName", authorPerson.getName()).put("depName", authorPerson.getDepartment().getName());
        ArrayNode attachmentListNode = JsonNodeFactory.instance.arrayNode();
        for (AttachmentEntity one : attachments) {
            attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getAttachmentId()).put("size", one.getAttachmentSize()).put("name", one.getAttachmentName()).put("url", this.fastDFSClientService.getRealDownloadUrl(one.getAttachmentUrl())));
        }
        ArrayNode workflowPersonListNode = JsonNodeFactory.instance.arrayNode();
        for (FlowAssociateEntity one : flowAssociates) {
            if ("doneTask".equals(one.getTaskKey()) && "0".equals(one.getPersonId())) {
                workflowPersonListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getId()).put("personId", one.getPersonId()).put("personName", "\u529e\u516c\u5ba4\u529e\u7ed3").put("processed", LakeMobUtils.isTrue(one.getProcessStatus())));
                continue;
            }
            workflowPersonListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getId()).put("personId", one.getPersonId()).put("personName", this.userManageService.queryPersonById(one.getPersonId()).getName()).put("processed", LakeMobUtils.isTrue(one.getProcessStatus())));
        }
        ArrayNode workflowTraceListNode = JsonNodeFactory.instance.arrayNode();
        for (FlowTraceEntity one : flowTraces) {
            ElectronicSignEntity electronicSignByPerson = this.electronicSignService.getElectronicSignByPerson(one.getPersonId());
            String signUrl = LakeMobUtils.getSignUrl(electronicSignByPerson);
            workflowTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getTraceId()).put("personId", one.getPersonId()).put("personName", this.userManageService.queryPersonById(one.getPersonId()).getName()).put("comment", LakeMobUtils.toString(one.getProcessComment())).put("createTime", DateFormatUtils.format((Date)one.getDoneTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(signUrl)));
        }
        ArrayNode copyTraceListNode = JsonNodeFactory.instance.arrayNode();
        for (NoticeEntity one : copyList) {
            ElectronicSignEntity electronicSignByPerson = this.electronicSignService.getElectronicSignByPerson(one.getProcesserId());
            String signUrl = LakeMobUtils.getSignUrl(electronicSignByPerson);
            boolean processed = LakeMobUtils.isTrue(one.getProcessStatus());
            copyTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getNoticeId()).put("personId", one.getProcesserId()).put("personName", this.userManageService.queryPersonById(one.getProcesserId()).getName()).put("processed", processed).put("statusDesc", processed ? "\u5df2\u5904\u7406" : "\u5904\u7406\u4e2d").put("comment", LakeMobUtils.toString(one.getProcessComment())).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(signUrl)));
        }
        root.put("attachmentList", (JsonNode)attachmentListNode);
        root.put("workflowPersonList", (JsonNode)workflowPersonListNode);
        root.put("workflowTraceList", (JsonNode)workflowTraceListNode);
        root.put("copyTraceList", (JsonNode)copyTraceListNode);
        String json = QuickJson.toJsonStr((JsonNode)root);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/documentController/downloadDocument.do"})
    public void downloadDocument(@RequestParam(required=false) String documentId, HttpServletRequest request, HttpServletResponse response) throws IOException, JRException {
        LOGGER.info("\u8c03\u7528 downloadDocument");
        AbstractMyAssert.hasText(documentId, "documentId \u4e0d\u80fd\u4e3a\u7a7a");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        byte[] bytes = null;
        bytes = this.documentReportService.reportToPDF(documentId);
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", "attachment;fileName=doc" + DateFormatUtils.format((Date)LakeMobUtils.now(), (String)"yyyyMMddHHmmss") + ".pdf");
        response.setContentLength(bytes.length);
        servletOutputStream.write(bytes, 0, bytes.length);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    @RequestMapping(value={"ruyihu/documentController/delete.do"}, method={RequestMethod.POST})
    public void delete(@RequestParam String documentId, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 delete");
        this.documentService.delete(documentId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }
}

