/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pams.function.xatl.ruyihu.bean.LeaveSummaryInfo;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.LeaveQueryService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
@Scope(value="session")
public class LeaveController
extends BaseControler {
    public static final Logger LOGGER = LoggerFactory.getLogger(LeaveController.class);
    @Resource
    private LeaveQueryService leaveQueryService;
    @Resource
    private UserManageService userManageService;
    @Resource
    private ElectronicSignService electronicSignService;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private AttachmentService attachmentService;

    @RequestMapping(value={"ruyihu/leaveController/leaveListPage.do"})
    public String leaveListPage() {
        return "ruyihu/leave/default/leaveList";
    }

    @RequestMapping(value={"ruyihu/leaveController/leaveSummaryPage.do"})
    public String leaveSummaryPage() {
        return "ruyihu/leave/default/leaveSummary";
    }

    @RequestMapping(value={"ruyihu/leaveController/leaveDetailPage.do"})
    public String leaveDetailPage() {
        return "ruyihu/leave/default/leaveDetail";
    }

    @RequestMapping(value={"ruyihu/leaveController/getLeaveList.do"})
    public void getLeaveList(@RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, @RequestParam(required=false) String personNameLike, @RequestParam(required=false) String type, @RequestParam(required=false) String status, @RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, HttpServletResponse response, HttpServletRequest request) {
        LOGGER.info("\u8c03\u7528 getLeaveList\uff0cpersonNameLike:" + personNameLike + ", type:" + type + ", status:" + status + ", beginDate:" + beginDate + ", endDate:" + endDate + ", page:" + page + ", rows:" + rows);
        Page pageParam = new Page(page, rows);
        Date begin = LakeMobUtils.parseDate(beginDate);
        Date end = LakeMobUtils.parseDate(endDate);
        if (StringUtils.hasText((String)type)) {
            AbstractMyAssert.isTrue(LakeMobUtils.LEAVE_TYPE_MAP.containsKey(type), "type\u503c\u4e0d\u5bf9");
        }
        List<LeaveEntity> datas = this.leaveQueryService.getLeaveList(begin, end, personNameLike, type, status, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(datas)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (LeaveEntity one : datas) {
                Person person = this.userManageService.queryPersonById(one.getPersonId());
                ObjectNode doc = QuickJson.newObjectNode();
                doc.put("leaveId", one.getLeaveId());
                doc.put("personId", one.getPersonId());
                doc.put("personName", person.getName());
                doc.put("depId", one.getDepId());
                doc.put("depName", person.getDepartment().getName());
                doc.put("typeDesc", LakeMobUtils.LEAVE_TYPE_MAP.get(one.getLeaveType()));
                doc.put("statusDesc", LakeMobUtils.LEAVE_STATUS_MAP.get(one.getApprovalStatus()));
                doc.put("dayCount", one.getDayCount());
                doc.put("beginTime", DateFormatUtils.format((Date)one.getBeginDate(), (String)"yyyy/MM/dd") + " " + (one.getBeginHalfDay() == 1 ? "\u4e0a\u5348" : "\u4e0b\u5348"));
                doc.put("endTime", DateFormatUtils.format((Date)one.getEndDate(), (String)"yyyy/MM/dd") + " " + (one.getEndHalfDay() == 1 ? "\u4e0a\u5348" : "\u4e0b\u5348"));
                doc.put("joinDate", one.getJoinDate());
                String cellLeaderId = one.getCellLeaderId();
                doc.put("cellLeaderId", cellLeaderId);
                doc.put("cellLeaderName", LakeMobUtils.getLeaveCellLeaderName(cellLeaderId, this.userManageService));
                doc.put("reason", one.getReason());
                doc.put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss"));
                List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(one.getLeaveId(), "leave");
                ArrayNode attachmentListNode = QuickJson.newArrayNode();
                for (AttachmentEntity att : attachments) {
                    attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", att.getAttachmentId()).put("name", att.getAttachmentName()).put("size", att.getAttachmentSize()).put("url", this.fastDFSClientService.getRealDownloadUrl(att.getAttachmentUrl())));
                }
                doc.put("attachmentList", (JsonNode)attachmentListNode);
                rowsNode.add((JsonNode)doc);
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/leaveController/getLeaveDetail.do"})
    public void getLeaveDetail(@RequestParam(required=false) String leaveId, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 getLeaveDetail,leaveId:" + leaveId);
        AbstractMyAssert.hasText(leaveId, "leaveId \u4e0d\u80fd\u4e3a\u7a7a");
        LeaveEntity leave = this.leaveQueryService.getLeaveById(leaveId);
        AbstractMyAssert.notNull(leave, "\u65e0\u6cd5\u627e\u5230\u8bf7\u5047\u5916\u51fa\u7533\u8bf7" + leaveId);
        List<FlowAssociateEntity> flowAssociates = this.flowAssociateService.getFlowAssociateListByLeaveId(leaveId);
        Person person = this.userManageService.queryPersonById(leave.getPersonId());
        String cellLeaderId = leave.getCellLeaderId();
        ObjectNode root = QuickJson.newObjectNode().put("leaveId", leave.getLeaveId()).put("personId", leave.getPersonId()).put("personName", person.getName()).put("depId", leave.getDepId()).put("depName", person.getDepartment().getName()).put("typeDesc", LakeMobUtils.LEAVE_TYPE_MAP.get(leave.getLeaveType())).put("statusDesc", LakeMobUtils.LEAVE_STATUS_MAP.get(leave.getApprovalStatus())).put("dayCount", leave.getDayCount()).put("beginTime", DateFormatUtils.format((Date)leave.getBeginDate(), (String)"yyyy/MM/dd") + " " + (leave.getBeginHalfDay() == 1 ? "\u4e0a\u5348" : "\u4e0b\u5348")).put("endTime", DateFormatUtils.format((Date)leave.getEndDate(), (String)"yyyy/MM/dd") + " " + (leave.getEndHalfDay() == 1 ? "\u4e0a\u5348" : "\u4e0b\u5348")).put("joinDate", leave.getJoinDate()).put("cellLeaderId", cellLeaderId).put("cellLeaderName", LakeMobUtils.getLeaveCellLeaderName(cellLeaderId, this.userManageService)).put("reason", leave.getReason()).put("createTime", DateFormatUtils.format((Date)leave.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss"));
        ArrayNode workflowPersonListNode = JsonNodeFactory.instance.arrayNode();
        for (FlowAssociateEntity one : flowAssociates) {
            workflowPersonListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getId()).put("personId", one.getPersonId()).put("personName", this.userManageService.queryPersonById(one.getPersonId()).getName()).put("processed", LakeMobUtils.isTrue(one.getProcessStatus())));
        }
        List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(leaveId, "leave");
        ArrayNode attachmentListNode = QuickJson.newArrayNode();
        for (AttachmentEntity att : attachments) {
            attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", att.getAttachmentId()).put("name", att.getAttachmentName()).put("size", att.getAttachmentSize()).put("url", this.fastDFSClientService.getRealDownloadUrl(att.getAttachmentUrl())));
        }
        ArrayNode workflowTraceListNode = JsonNodeFactory.instance.arrayNode();
        ElectronicSignEntity electronicSignByPerson = this.electronicSignService.getElectronicSignByPerson(leave.getPersonId());
        String starterSignUrl = LakeMobUtils.getSignUrl(electronicSignByPerson);
        workflowTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", 0).put("personId", leave.getPersonId()).put("personName", this.userManageService.queryPersonById(leave.getPersonId()).getName()).put("statusDesc", "\u63d0\u4ea4\u7533\u8bf7").put("createTime", DateFormatUtils.format((Date)leave.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(starterSignUrl)));
        if ("leave_approval_revoke".equals(leave.getApprovalStatus())) {
            workflowTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", 0).put("personId", leave.getPersonId()).put("personName", this.userManageService.queryPersonById(leave.getPersonId()).getName()).put("statusDesc", "\u64a4\u9500\u7533\u8bf7").put("createTime", DateFormatUtils.format((Date)leave.getDoneTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(starterSignUrl)));
        } else {
            List<FlowTraceEntity> flowTraces = this.flowTraceService.getFlowTraceListByLeaveId(leaveId);
            for (FlowTraceEntity one : flowTraces) {
                ElectronicSignEntity electronicSignByPersonTmp = this.electronicSignService.getElectronicSignByPerson(one.getPersonId());
                String signUrl = LakeMobUtils.getSignUrl(electronicSignByPersonTmp);
                workflowTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getTraceId()).put("personId", one.getPersonId()).put("personName", this.userManageService.queryPersonById(one.getPersonId()).getName()).put("statusDesc", LakeMobUtils.isTrue(one.getPass()) ? "\u540c\u610f" : "\u62d2\u7edd").put("createTime", DateFormatUtils.format((Date)one.getDoneTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(signUrl)));
            }
        }
        root.put("workflowPersonList", (JsonNode)workflowPersonListNode);
        root.put("workflowTraceList", (JsonNode)workflowTraceListNode);
        root.put("attachmentList", (JsonNode)attachmentListNode);
        String json = QuickJson.toJsonStr((JsonNode)root);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/leaveController/getLeaveSummary.do"})
    public void getLeaveSummary(@RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, @RequestParam(required=false) String personNameLike, @RequestParam(required=false) String depNameLike, @RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) String mode, HttpServletResponse response, HttpServletRequest request) {
        LOGGER.info("\u8c03\u7528getLeaveSummary\uff0cpersonNameLike:" + personNameLike + ", depNameLike:" + depNameLike + ", beginDate:" + beginDate + ", endDate:" + endDate + ", mode:" + mode + ", page:" + page + ", rows:" + rows);
        Page pageParam = new Page(page, rows);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)beginDate)) {
            beginDate = "1970-01-01";
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endDate)) {
            endDate = "2099-01-01";
        }
        Date begin = null;
        Date end = null;
        try {
            begin = Util.parseDate((String)beginDate, (String)"yyyy-MM-dd");
            end = Util.parseDate((String)endDate, (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            LOGGER.error("beginDate\u6216endDate\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        String controlDeps = "8888888888";
        String controlPolices = "all";
        String testMode = "test";
        if (!testMode.equals(mode)) {
            controlDeps = this.getControlDeps(request);
            controlPolices = this.getControlPolices(request);
        }
        List<LeaveSummaryInfo> datas = this.leaveQueryService.getLeaveSummaryList(begin, end, controlDeps, controlPolices, personNameLike, depNameLike, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(datas)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (LeaveSummaryInfo one : datas) {
                ObjectNode doc = QuickJson.newObjectNode().put("personId", one.getPersonId()).put("personName", one.getPersonName()).put("depId", one.getDepId()).put("depName", one.getDepName()).put("totalOfficial", one.getTotalOfficial()).put("totalAffair", one.getTotalAffair()).put("totalSick", one.getTotalSick()).put("totalHoliday", one.getTotalHoliday()).put("totalOther", one.getTotalOther()).put("totalLeave", one.getTotalLeave()).put("totalBusinessTrip", one.getTotalBusinessTrip()).put("totalMarital", one.getTotalMarital());
                rowsNode.add((JsonNode)doc);
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        LOGGER.info("\u8c03\u7528getLeaveSummary\u7ed3\u679c\uff1a" + json);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/leaveController/delete.do"}, method={RequestMethod.POST})
    public void delete(@RequestParam String leaveId, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 delete");
        this.leaveQueryService.delete(leaveId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/leaveController/excel.do"})
    public void excel(@RequestParam(required=false) String personNameLike, @RequestParam(required=false) String depNameLike, @RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, HttpServletResponse response, HttpServletRequest request) {
        Page pageParam = new Page(1, Integer.MAX_VALUE);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)beginDate)) {
            beginDate = "1970-01-01";
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)endDate)) {
            endDate = "2099-01-01";
        }
        Date begin = null;
        Date end = null;
        try {
            begin = Util.parseDate((String)beginDate, (String)"yyyy-MM-dd");
            end = Util.parseDate((String)endDate, (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            LOGGER.error("beginDate\u6216endDate\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        String controlDeps = this.getControlDeps(request);
        String controlPolices = this.getControlPolices(request);
        List<LeaveSummaryInfo> lists = this.leaveQueryService.getLeaveSummaryList(begin, end, controlDeps, controlPolices, personNameLike, depNameLike, pageParam);
        ArrayList datas = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(lists)) {
            for (LeaveSummaryInfo one : lists) {
                HashMap map = Maps.newHashMap();
                map.put("personId", one.getPersonId());
                map.put("personName", one.getPersonName());
                map.put("depId", one.getDepId());
                map.put("depName", one.getDepName());
                map.put("totalOfficial", Float.valueOf(one.getTotalOfficial()));
                map.put("totalAffair", Float.valueOf(one.getTotalAffair()));
                map.put("totalSick", Float.valueOf(one.getTotalSick()));
                map.put("totalHoliday", Float.valueOf(one.getTotalHoliday()));
                map.put("totalOther", Float.valueOf(one.getTotalOther()));
                map.put("totalMarital", Float.valueOf(one.getTotalMarital()));
                map.put("totalLeave", Float.valueOf(one.getTotalLeave()));
                map.put("totalBusinessTrip", Float.valueOf(one.getTotalBusinessTrip()));
                datas.add(map);
            }
        }
        response.setContentType("application/vnd.ms-excel");
        String fileName = Util.toUtf8String((String)"\u8bf7\u5047\u5916\u51fa\u8bb0\u5f55") + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            String[] heanderNames = new String[]{"\u4eba\u5458\u540d\u79f0", "\u90e8\u95e8\u540d\u79f0", "\u516c\u51fa\u7edf\u8ba1\uff08\u5929\uff09", "\u51fa\u5dee\u7edf\u8ba1\uff08\u5929\uff09", "\u5a5a\u4ea7\u5047\u7edf\u8ba1\uff08\u5929\uff09", "\u4e8b\u5047\u7edf\u8ba1\uff08\u5929\uff09", "\u75c5\u5047\u7edf\u8ba1\uff08\u5929\uff09", "\u516c\u4f11\u5047\u7edf\u8ba1\uff08\u5929\uff09", "\u5176\u4ed6\u5047\u7edf\u8ba1\uff08\u5929\uff09", "\u5168\u90e8\u8bf7\u5047\u7edf\u8ba1\uff08\u5929\uff09"};
            String[] keys = new String[]{"personName", "depName", "totalOfficial", "totalBusinessTrip", "totalMarital", "totalAffair", "totalSick", "totalHoliday", "totalOther", "totalLeave"};
            ExcelUtil.exportExcel((String)"\u8bf7\u5047\u5916\u51fa\u8bb0\u5f55", (OutputStream)response.getOutputStream(), (String)"\u8bf7\u5047\u5916\u51fa\u8bb0\u5f55", (List)datas, (String[])heanderNames, (String[])keys);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

