/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.ruyihu.entity.RegulationEntity;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.RegulationService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
public class RegulationController {
    public static final Logger LOGGER = LoggerFactory.getLogger(RegulationController.class);
    @Resource
    private RegulationService regulationService;
    @Resource
    private FastDFSClientService fastDFSClientService;

    @RequestMapping(value={"ruyihu/regulationController/getRegulationList.do"})
    public void getRegulationList(@RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int rows, @RequestParam(required=false) String titleLike, @RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 getRegulationList");
        Page pageParam = new Page(page, rows);
        Date begin = LakeMobUtils.parseDate(beginDate);
        Date end = LakeMobUtils.parseDate(endDate);
        List<RegulationEntity> datas = this.regulationService.getRegulationList(begin, end, titleLike, pageParam);
        ObjectNode rst = QuickJson.newObjectNode();
        if (!CollectionUtils.isEmpty(datas)) {
            ArrayNode rowsNode = QuickJson.newArrayNode();
            for (RegulationEntity one : datas) {
                rowsNode.add((JsonNode)QuickJson.newObjectNode().put("regulationId", one.getRegulationId()).put("title", one.getRegulationTitle()).put("fileUrl", this.fastDFSClientService.getRealDownloadUrl(one.getDownloadUrl())).put("fileName", one.getFileName()).put("fileSize", one.getFileSize()).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd")));
            }
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)rowsNode);
        } else {
            rst.put("total", pageParam.getTotal()).put("rows", (JsonNode)QuickJson.newArrayNode());
        }
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/regulationController/addRegulation.do"}, method={RequestMethod.POST})
    public void addRegulation(@RequestParam(required=false) String regulationName, @RequestParam MultipartFile regulationFile, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 addRegulation");
        if (!StringUtils.hasText((String)regulationName)) {
            regulationName = regulationFile.getOriginalFilename();
        }
        String regulationId = this.regulationService.addRegulation(regulationName, regulationFile);
        ObjectNode rst = QuickJson.newObjectNode();
        rst.put("regulationId", regulationId).put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/regulationController/deleteRegulation.do"}, method={RequestMethod.POST})
    public void deleteRegulation(@RequestParam String regulationId, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 deleteRegulation");
        this.regulationService.deleteRegulation(regulationId);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/regulationController/editRegulation.do"}, method={RequestMethod.POST})
    public void editRegulation(@RequestParam String regulationId, @RequestParam String regulationName, HttpServletResponse response) {
        LOGGER.info("\u8c03\u7528 editRegulation");
        AbstractMyAssert.hasText(regulationName, "regulationName \u4e0d\u80fd\u4e3a\u7a7a");
        this.regulationService.updateRegulationTitle(regulationId, regulationName);
        ObjectNode rst = QuickJson.newObjectNode().put("rtnCode", 1).put("rtnMsg", "\u64cd\u4f5c\u6210\u529f");
        String json = QuickJson.toJsonStr((JsonNode)rst);
        Util.writeUtf8Text((HttpServletResponse)response, (String)json);
    }

    @RequestMapping(value={"ruyihu/regulationController/regulationListPage.do"})
    public String regulationListPage() {
        return "ruyihu/regulation/default/regulationList";
    }

    @RequestMapping(value={"ruyihu/regulationController/regulationAddPage.do"})
    public String regulationAddPage() {
        return "ruyihu/regulation/default/regulationAdd";
    }

    @RequestMapping(value={"ruyihu/regulationController/regulationEditPage.do"})
    public String regulationEditPage() {
        return "ruyihu/regulation/default/regulationEdit";
    }
}

