/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.dao.AnnouncementDao;
import pams.function.xatl.ruyihu.entity.AnnouncementEntity;

@Repository
public class AnnouncementDaoImpl
implements AnnouncementDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public AnnouncementEntity getById(String id) {
        return (AnnouncementEntity)this.baseDao.getObjectById(AnnouncementEntity.class, (Serializable)((Object)id));
    }

    @Override
    public int count(AnnouncementEntity condition) {
        StringBuilder from = new StringBuilder("select count(*) from AnnouncementEntity where 1=1 ");
        ArrayList params = Lists.newArrayList();
        if (StringUtils.hasText((String)condition.getTitleLike())) {
            from.append(" and title like ? ");
            params.add("%" + condition.getTitleLike() + "%");
        }
        if (StringUtils.hasText((String)condition.getDepartmentLike())) {
            from.append(" and department like ? ");
            params.add("%" + condition.getDepartmentLike() + "%");
        }
        if (condition.getTimestamp() != null && condition.getTimestamp() > 0L) {
            from.append(" and createTime < ?");
            params.add(new Date(condition.getTimestamp()));
        }
        if (condition.getBeginDate() != null) {
            from.append(" and publishTime >= ? ");
            params.add(condition.getBeginDate());
        }
        if (condition.getEndDate() != null) {
            from.append(" and publishTime <? ");
            params.add(DateUtils.addDays((Date)condition.getEndDate(), (int)1));
        }
        Number rst = (Number)this.baseDao.getObjectByHQL(from.toString(), params.toArray());
        return rst.intValue();
    }

    @Override
    public List<AnnouncementEntity> getList(AnnouncementEntity condition) {
        StringBuilder from = new StringBuilder("select count(*) from AnnouncementEntity where 1=1 ");
        ArrayList params = Lists.newArrayList();
        if (StringUtils.hasText((String)condition.getTitleLike())) {
            from.append(" and title like ? ");
            params.add("%" + condition.getTitleLike() + "%");
        }
        if (StringUtils.hasText((String)condition.getDepartmentLike())) {
            from.append(" and department like ? ");
            params.add("%" + condition.getDepartmentLike() + "%");
        }
        if (condition.getTimestamp() != null && condition.getTimestamp() > 0L) {
            from.append(" and createTime < ?");
            params.add(new Date(condition.getTimestamp()));
        }
        if (condition.getBeginDate() != null) {
            from.append(" and publishTime >= ? ");
            params.add(condition.getBeginDate());
        }
        if (condition.getEndDate() != null) {
            from.append(" and publishTime <? ");
            params.add(DateUtils.addDays((Date)condition.getEndDate(), (int)1));
        }
        return this.baseDao.getListByHQL(from.toString(), params.toArray());
    }

    @Override
    public List<AnnouncementEntity> getList(AnnouncementEntity condition, Page pageParam) {
        StringBuilder from = new StringBuilder("from AnnouncementEntity where 1=1 ");
        ArrayList params = Lists.newArrayList();
        if (StringUtils.hasText((String)condition.getTitleLike())) {
            from.append(" and title like ? ");
            params.add("%" + condition.getTitleLike() + "%");
        }
        if (StringUtils.hasText((String)condition.getDepartmentLike())) {
            from.append(" and department like ? ");
            params.add("%" + condition.getDepartmentLike() + "%");
        }
        if (condition.getTimestamp() != null && condition.getTimestamp() > 0L) {
            from.append(" and createTime < ?");
            params.add(new Date(condition.getTimestamp()));
        }
        if (condition.getBeginDate() != null) {
            from.append(" and publishTime >= ? ");
            params.add(condition.getBeginDate());
        }
        if (condition.getEndDate() != null) {
            from.append(" and publishTime <? ");
            params.add(DateUtils.addDays((Date)condition.getEndDate(), (int)1));
        }
        List result = this.baseDao.getListByHQL("select count(*) " + from.toString(), from.toString() + " order by createTime desc", params.toArray(), pageParam);
        return result;
    }

    @Override
    public List<AnnouncementEntity> getList(String currentUser, AnnouncementEntity condition, Page pageParam) {
        StringBuilder from = new StringBuilder("from t_lakemob_announcement a , t_lakemob_reading_log r where a.id=r.content_id(+) ");
        ArrayList params = Lists.newArrayList();
        from.append("and r.type(+)=? ");
        params.add("anno");
        from.append(" and r.person_id(+) = ? ");
        params.add(currentUser);
        if (StringUtils.hasText((String)condition.getTitleLike())) {
            from.append(" and a.title like ? ");
            params.add("%" + condition.getTitleLike() + "%");
        }
        if (StringUtils.hasText((String)condition.getDepartmentLike())) {
            from.append(" and a.department like ? ");
            params.add("%" + condition.getDepartmentLike() + "%");
        }
        if (condition.getTimestamp() != null && condition.getTimestamp() > 0L) {
            from.append(" and a.create_time < ?");
            params.add(new Date(condition.getTimestamp()));
        }
        if (condition.getBeginDate() != null) {
            from.append(" and a.publish_time >= ? ");
            params.add(condition.getBeginDate());
        }
        if (condition.getEndDate() != null) {
            from.append(" and a.publish_time <? ");
            params.add(DateUtils.addDays((Date)condition.getEndDate(), (int)1));
        }
        List result = this.baseDao.getListBySQL("select count(*) " + from.toString(), "select a.*,nvl2(r.id,1,0) as flag " + from.toString() + " order by flag asc,a.create_time desc", params.toArray(), pageParam, AnnouncementEntity.class);
        return result;
    }

    @Override
    public AnnouncementEntity save(AnnouncementEntity one) {
        this.baseDao.saveOrUpdate((Object)one);
        return one;
    }

    @Override
    public void delete(AnnouncementEntity one) {
        this.baseDao.delete((Object)one);
    }
}

