/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import pams.function.xatl.ruyihu.bean.BusinessTripDateBean;
import pams.function.xatl.ruyihu.bean.BusinessTripDetailBean;
import pams.function.xatl.ruyihu.dao.IBusinessTripDao;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.enums.BusinessTripStatusEnum;

@Repository
public class BusinessTripDaoImpl
implements IBusinessTripDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public void save(BusinessTripEntity businessTripEntity) {
        this.baseDao.saveOrUpdate((Object)businessTripEntity);
    }

    @Override
    public BusinessTripEntity get(String applyId) {
        return (BusinessTripEntity)this.baseDao.getObjectById(BusinessTripEntity.class, (Serializable)((Object)applyId));
    }

    @Override
    public List<BusinessTripEntity> businessTripList(boolean isOfficeLeader, String currentUser, long timestamp, int pageSize, int businessUserType) {
        ArrayList params = Lists.newArrayList();
        StringBuilder sb = new StringBuilder("select am.* from t_lakemob_business_trip am where 1=1 ");
        if (1 == businessUserType) {
            sb.append("and apply_user_id = ? and am.status != ? ");
            params.add(currentUser);
            params.add(BusinessTripStatusEnum.DELETE.value);
        } else {
            sb.append("and (am.apply_id in (select bj.business_id from t_lakemob_business_joiner bj where bj.person_id = ? and bj.business_type = ? ) and am.status != ?) ");
            params.add(currentUser);
            params.add("business_trip");
            params.add(BusinessTripStatusEnum.DELETE.value);
        }
        if (isOfficeLeader) {
            sb.append(" or am.status = ? ");
            params.add(BusinessTripStatusEnum.DONE.value);
        }
        if (timestamp > 0L) {
            sb.append(" and am.create_time < ?");
            params.add(new Date(timestamp));
        }
        sb.append(" order by am.create_time desc");
        return this.baseDao.getListBySQL((String)null, sb.toString(), params.toArray(), new Page(1, pageSize), BusinessTripEntity.class);
    }

    @Override
    public List<BusinessTripDetailBean> businessTripIdList(boolean isOfficeLeader, String currentUser, long timestamp, int pageSize, int businessUserType) {
        String applyIdSql;
        ArrayList params = Lists.newArrayList();
        if (1 == businessUserType) {
            applyIdSql = " select t1.apply_id \"applyId\" from t_lakemob_business_trip t1 where t1.apply_user_id = ? ";
            params.add(currentUser);
        } else {
            applyIdSql = " select bj.business_id \"applyId\" from t_lakemob_business_joiner bj where bj.person_id = ? and bj.business_type = ? ";
            params.add(currentUser);
            params.add("business_trip");
        }
        String countSql = "select count(1) from (" + applyIdSql + ")";
        return this.baseDao.getListBySQL(countSql, applyIdSql, params.toArray(), new Page(1, pageSize), BusinessTripDetailBean.class);
    }

    @Override
    public List<BusinessTripEntity> businessTripList(String personNameLike, Integer approvalStatus, Date begin, Date end, Page page) {
        StringBuilder sb = new StringBuilder("select business.* ").append("  from t_lakemob_business_trip business ").append("  left join t_person person ").append("    on business.trip_user_id = person.id ").append("  left join t_department dept ").append("    on person.dep_id = dept.id ").append(" where business.status != ? ");
        ArrayList params = Lists.newArrayList();
        params.add(BusinessTripStatusEnum.DELETE.value);
        if (StringUtils.isNotEmpty((CharSequence)personNameLike)) {
            sb.append(" and person.name like ? ");
            params.add("%" + StringUtils.trim((String)personNameLike) + "%");
        }
        if (null != approvalStatus) {
            sb.append(" and business.status = ? ");
            params.add(approvalStatus);
        }
        if (null != begin) {
            sb.append(" and business.start_date >= ? ");
            params.add(begin);
        }
        if (null != end) {
            sb.append(" and business.end_date <=  ? ");
            params.add(end);
        }
        sb.append(" order by business.create_time desc");
        String countSql = "select count(1) from (" + sb.toString() + ") t";
        return this.baseDao.getListBySQL(countSql, sb.toString(), params.toArray(), page, BusinessTripEntity.class);
    }

    @Override
    public List<BusinessTripEntity> myList(String tripUserId) {
        List listByHQL = this.baseDao.getListByHQL("from BusinessTripEntity b where b.tripUserId=? and b.status=?", new Object[]{tripUserId, BusinessTripStatusEnum.DONE.value});
        return listByHQL;
    }

    @Override
    public int getBusinessTripDayCount(String personId, String date) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer(" select count(1) from T_LAKEMOB_BUSINESS_TRIP  t where 1=1 AND t.status = ?");
        sb.append(" AND t.apply_user_id = ?");
        sb.append(" AND to_date(?,'YYYY-MM-DD') >= t.real_start_date ");
        sb.append(" AND to_date(?,'YYYY-MM-DD') <= t.real_end_date");
        params.add(BusinessTripStatusEnum.DONE.value);
        params.add(personId);
        params.add(date);
        params.add(date);
        Object value = this.baseDao.getObjectBySQL(sb.toString(), params.toArray());
        return Integer.parseInt(value.toString()) >= 1 ? 1 : 0;
    }

    @Override
    public List<BusinessTripEntity> businessTripList(Date begin, Date end, String personId, String reportStatus) {
        StringBuilder sb = new StringBuilder(" from BusinessTripEntity ").append(" where status = ? ");
        ArrayList params = Lists.newArrayList();
        params.add(BusinessTripStatusEnum.DONE.value);
        if (end != null) {
            sb.append(" and startDate <= ? ");
            params.add(end);
        }
        if (begin != null) {
            sb.append(" and endDate >= ? ");
            params.add(begin);
        }
        if (StringUtils.isNotEmpty((CharSequence)personId)) {
            sb.append(" and applyUserId = ?");
            params.add(personId);
        }
        if (StringUtils.isNotEmpty((CharSequence)reportStatus)) {
            sb.append(" and reportStatus = ?");
            params.add(reportStatus);
        }
        return this.baseDao.getListByHQL(sb.toString(), params.toArray());
    }

    @Override
    public List<BusinessTripDateBean> queryBusinessTripDateList(String personId, String startDate, String endDate) {
        String sql = "SELECT bt.start_date as \"startDate\", bt.end_date as \"endDate\", bt.real_start_date as \"realStartDate\", bt.real_end_date as \"realEndDate\" FROM t_lakemob_business_trip bt WHERE bt.status = ? and bt.apply_user_id = ? AND to_date(?,'YYYY-MM-DD') <= bt.start_date AND to_date(?,'YYYY-MM-DD') >= bt.start_date order by bt.real_start_date ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(BusinessTripStatusEnum.DONE.value);
        params.add(personId);
        params.add(startDate);
        params.add(endDate);
        return this.baseDao.getListBySQL(sql, params.toArray(), BusinessTripDateBean.class);
    }
}

