/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.dao.DocumentDao;
import pams.function.xatl.ruyihu.entity.DocumentEntity;

@Repository
public class DocumentDaoImpl
implements DocumentDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public void saveDocument(DocumentEntity doc) {
        this.baseDao.saveOrUpdate((Object)doc);
    }

    @Override
    public DocumentEntity getDocumentById(String businessKey) {
        DocumentEntity objectById = (DocumentEntity)this.baseDao.getObjectById(DocumentEntity.class, (Serializable)((Object)businessKey));
        this.processEntity(objectById);
        return objectById;
    }

    private void processEntity(List<DocumentEntity> list) {
        for (DocumentEntity one : list) {
            this.processEntity(one);
        }
    }

    private void processEntity(DocumentEntity one) {
        if (null != one) {
            one.setShortName(Strings.nullToEmpty((String)one.getShortName()));
            one.setIssueOffice(Strings.nullToEmpty((String)one.getIssueOffice()));
        }
    }

    @Override
    public List<DocumentEntity> getDocumentList(Date begin, Date end, String titleLike, String type, String status, boolean hasSummaryAuth, Page pageParam) {
        List result;
        StringBuilder from = new StringBuilder("from DocumentEntity where 1=1 ");
        ArrayList params = Lists.newArrayList();
        if (StringUtils.hasText((String)type)) {
            from.append(" and documentType = ? ");
            params.add(type);
        }
        if (!hasSummaryAuth) {
            from.append(" and documentType != ? ");
            params.add("doc_type_publish_summary");
        }
        if (StringUtils.hasText((String)titleLike)) {
            from.append(" and documentTitle like ?");
            params.add("%" + titleLike + "%");
        }
        if (StringUtils.hasText((String)status)) {
            from.append(" and approvalStatus = ? ");
            params.add(status);
        }
        if (begin != null) {
            from.append(" and issueDate >= ? ");
            params.add(begin);
        }
        if (end != null) {
            from.append(" and issueDate <? ");
            params.add(DateUtils.addDays((Date)end, (int)1));
        }
        List out = result = this.baseDao.getListByHQL("select count(*) " + from.toString(), from.toString() + " order by createTime desc", params.toArray(), pageParam);
        this.processEntity(out);
        return out;
    }

    @Override
    public List<DocumentEntity> getTopDocumentListWithApproval(String currentUser, long timestamp, int pageSize, String titleLike, String status, String type, String shortNameLike, Date begin, Date end, boolean withMeetingSummary) {
        List rst;
        StringBuilder sb = new StringBuilder("select distinct d from DocumentEntity d, BusinessJoinerEntity j where ((d.documentId=j.businessId and j.businessType=? and j.personId=?) or d.personId = ?)");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("document");
        params.add(currentUser);
        params.add(currentUser);
        if (StringUtils.hasText((String)titleLike)) {
            sb.append(" and d.documentTitle like ? ");
            params.add("%" + titleLike + "%");
        }
        if (StringUtils.hasText((String)status)) {
            sb.append(" and d.approvalStatus=? ");
            params.add(status);
        }
        if (StringUtils.hasText((String)type)) {
            sb.append(" and d.documentType=? ");
            params.add(type);
        }
        if (!withMeetingSummary) {
            sb.append(" and d.documentType!=? ");
            params.add("doc_type_publish_summary");
        }
        if (StringUtils.hasText((String)shortNameLike)) {
            sb.append(" and d.shortName like ?");
            params.add("%" + shortNameLike + "%");
        }
        if (begin != null) {
            sb.append(" and d.issueDate >= ?");
            params.add(begin);
        }
        if (end != null) {
            sb.append(" and d.issueDate <?");
            params.add(DateUtils.addDays((Date)end, (int)1));
        }
        if (timestamp > 0L) {
            sb.append(" and d.createTime<?");
            params.add(new Date(timestamp));
        }
        sb.append(" order by d.createTime desc");
        List output = rst = this.baseDao.getTopListByHQL(sb.toString(), params.toArray(), pageSize);
        this.processEntity(output);
        return output;
    }

    @Override
    public int countDocumentListWithApproval(String currentUser, long timestamp, String titleLike, String status, String type, String shortNameLike, Date begin, Date end) {
        StringBuilder sb = new StringBuilder("select count(d.documentId) from DocumentEntity d, BusinessJoinerEntity j where d.documentId=j.businessId and j.businessType=? and j.personId=?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("document");
        params.add(currentUser);
        if (StringUtils.hasText((String)titleLike)) {
            sb.append(" and d.documentTitle like ? ");
            params.add("%" + titleLike + "%");
        }
        if (StringUtils.hasText((String)status)) {
            sb.append(" and d.approvalStatus=? ");
            params.add(status);
        }
        if (StringUtils.hasText((String)type)) {
            sb.append(" and d.documentType=? ");
            params.add(type);
        }
        if (StringUtils.hasText((String)shortNameLike)) {
            sb.append(" and d.shortName like ?");
            params.add("%" + shortNameLike + "%");
        }
        if (begin != null) {
            sb.append(" and d.issueDate >= ?");
            params.add(begin);
        }
        if (end != null) {
            sb.append(" and d.issueDate <?");
            params.add(DateUtils.addDays((Date)end, (int)1));
        }
        if (timestamp > 0L) {
            sb.append(" and d.createTime<?");
            params.add(new Date(timestamp));
        }
        Object rst = this.baseDao.getObjectByHQL(sb.toString(), params.toArray());
        return ((Number)rst).intValue();
    }

    @Override
    public void delete(DocumentEntity document) {
        this.baseDao.delete((Object)document);
    }
}

