/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.dao.RegulationDao;
import pams.function.xatl.ruyihu.entity.RegulationEntity;

@Repository
public class RegulationDaoImpl
implements RegulationDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public int countRegulation(String titleLike, long timestamp) {
        StringBuilder sb = new StringBuilder("select count(*) from RegulationEntity where 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.hasText((String)titleLike)) {
            sb.append(" and regulationTitle like ? ");
            params.add("%" + titleLike + "%");
        }
        if (timestamp > 0L) {
            sb.append(" and createTime<?");
            params.add(new Date(timestamp));
        }
        Number rst = (Number)this.baseDao.getObjectByHQL(sb.toString(), params.toArray());
        return rst.intValue();
    }

    @Override
    public void deleteRegulation(String regulationId) {
        this.baseDao.updateBySql("delete from t_lakemob_regulation where regulation_id =?", new Object[]{regulationId});
    }

    @Override
    public RegulationEntity getRegulation(String regulationId) {
        return (RegulationEntity)this.baseDao.getObjectById(RegulationEntity.class, (Serializable)((Object)regulationId));
    }

    @Override
    public List<RegulationEntity> getRegulationList(Date begin, Date end, String titleLike, Page pageParam) {
        StringBuilder from = new StringBuilder("from RegulationEntity where 1=1 ");
        ArrayList params = Lists.newArrayList();
        if (StringUtils.hasText((String)titleLike)) {
            from.append(" and regulationTitle like ?");
            params.add("%" + titleLike + "%");
        }
        if (begin != null) {
            from.append(" and createTime >= ? ");
            params.add(begin);
        }
        if (end != null) {
            from.append(" and createTime <? ");
            params.add(DateUtils.addDays((Date)end, (int)1));
        }
        List result = this.baseDao.getListByHQL("select count(*) " + from.toString(), from.toString() + " order by createTime desc", params.toArray(), pageParam);
        return result;
    }

    @Override
    public List<RegulationEntity> getTopRegulationList(String titleLike, long timestamp, int pageSize) {
        StringBuilder sb = new StringBuilder("from RegulationEntity where 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.hasText((String)titleLike)) {
            sb.append(" and regulationTitle like ? ");
            params.add("%" + titleLike + "%");
        }
        if (timestamp > 0L) {
            sb.append(" and createTime<?");
            params.add(new Date(timestamp));
        }
        sb.append(" order by createTime desc");
        List rst = this.baseDao.getTopListByHQL(sb.toString(), params.toArray(), pageSize);
        return rst;
    }

    @Override
    public void saveRegulation(RegulationEntity entity) {
        this.baseDao.saveOrUpdate((Object)entity);
    }
}

