/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.jsonrpc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.QuickJson;

public class SuperRequest {
    private final JsonNode params;

    public SuperRequest(JsonNode params) {
        this.params = params;
    }

    public String needText(String key) {
        return this.needText(key, null);
    }

    public String needText(String key, String def) {
        String s = this.params.path(key).asText();
        if (StringUtils.hasText((String)s)) {
            return s.trim();
        }
        if (def != null) {
            return def;
        }
        throw new LakeMobException(key + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public <T> List<T> needList(String key, Class<T> cls) {
        JsonNode path = this.params.path(key);
        if (path.isMissingNode()) {
            return Lists.newArrayList();
        }
        return QuickJson.toList(path, cls);
    }

    public Boolean needBool(String key) {
        return this.needBool(key, null);
    }

    public Boolean needBool(String key, Boolean def) {
        String s = this.params.path(key).asText();
        if (StringUtils.hasText((String)s)) {
            try {
                Boolean number = Boolean.parseBoolean(s.trim());
                return number;
            }
            catch (Exception e) {
                throw new LakeMobException(key + "\u89e3\u6790\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if (def != null) {
            return def;
        }
        throw new LakeMobException(key + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public int needInt(String key) throws LakeMobException {
        return this.needInt(key, null);
    }

    public double needDouble(String key) throws LakeMobException {
        return this.needDouble(key, null);
    }

    public float needFloat(String key) throws LakeMobException {
        return this.needFloat(key, null);
    }

    public long needLong(String key) throws LakeMobException {
        return this.needLong(key, null);
    }

    public int needInt(String key, Integer def) throws LakeMobException {
        String s = this.toStr(key);
        if (StringUtils.hasText((String)s)) {
            try {
                int number = Integer.parseInt(s.trim());
                return number;
            }
            catch (Exception e) {
                throw new LakeMobException(key + "\u89e3\u6790\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if (def != null) {
            return def;
        }
        throw new LakeMobException(key + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private double needDouble(String key, Double def) throws LakeMobException {
        String s = this.toStr(key);
        if (StringUtils.hasText((String)s)) {
            try {
                double number = Double.parseDouble(s.trim());
                return number;
            }
            catch (Exception e) {
                throw new LakeMobException(key + "\u89e3\u6790\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if (def != null) {
            return def;
        }
        throw new LakeMobException(key + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public float needFloat(String key, Float def) throws LakeMobException {
        String s = this.toStr(key);
        if (StringUtils.hasText((String)s)) {
            try {
                float number = Float.parseFloat(s.trim());
                return number;
            }
            catch (Exception e) {
                throw new LakeMobException(key + "\u89e3\u6790\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if (def != null) {
            return def.floatValue();
        }
        throw new LakeMobException(key + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private String toStr(String key) {
        return this.params.path(key).asText();
    }

    public long needLong(String key, Long def) throws LakeMobException {
        String s = this.toStr(key);
        if (StringUtils.hasText((String)s)) {
            try {
                long number = Long.parseLong(s.trim());
                return number;
            }
            catch (Exception e) {
                throw new LakeMobException(key + "\u89e3\u6790\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if (def != null) {
            return def;
        }
        throw new LakeMobException(key + "\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public boolean isDebug() {
        boolean debug = this.needBool("_debug", false);
        return debug;
    }

    public String toJsonString() {
        return null != this.params ? this.params.toString() : "";
    }
}

