/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.bean.BusinessTripInfo;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.workreport.util.DateUtil;

@Service
public class ApplyBusinessTrip
extends AbstractLakeMobMethod {
    @Resource
    private IBusinessTripService businessTripService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            boolean isNotEmpty;
            BusinessTripInfo businessTrip = new BusinessTripInfo();
            String startDate = request.needText("startDate");
            String endDate = request.needText("endDate");
            boolean bl = isNotEmpty = StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)endDate);
            if (!isNotEmpty) {
                String msg = "\u51fa\u5dee\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a";
                result.put("isSuccess", false);
                result.put("msg", msg);
                throw new LakeMobException(msg);
            }
            Integer twoDayInterval = DateUtil.getTwoDayInterval(endDate, startDate, "yyyy-MM-dd");
            int queryMaxInterval = 60;
            if (twoDayInterval > queryMaxInterval) {
                String msg = "\u51fa\u5dee\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7" + queryMaxInterval + "\u5929";
                result.put("isSuccess", false);
                result.put("msg", msg);
                throw new LakeMobException(msg);
            }
            businessTrip.setStartDate(startDate);
            businessTrip.setEndDate(endDate);
            businessTrip.setApplyUserId(currentUser);
            String tripUserId = request.needText("tripUserId");
            businessTrip.setTripUserId(tripUserId);
            String position = request.needText("position", "");
            businessTrip.setPosition(position);
            String aAddStart = request.needText("aAddStart", "");
            businessTrip.setaAddStart(aAddStart);
            String aAddEnd = request.needText("aAddEnd", "");
            businessTrip.setaAddEnd(aAddEnd);
            String bAddStart = request.needText("bAddStart", "");
            businessTrip.setbAddStart(bAddStart);
            String bAddEnd = request.needText("bAddEnd", "");
            businessTrip.setbAddEnd(bAddEnd);
            String reason = request.needText("reason", "");
            businessTrip.setReason(reason);
            String payUnit = request.needText("payUnit", "");
            businessTrip.setPayUnit(payUnit);
            String trafficType = request.needText("trafficType", "");
            businessTrip.setTrafficType(trafficType);
            List<String> deptLeader = request.needList("deptLeader", String.class);
            businessTrip.setDeptLeader(deptLeader);
            List<String> directLeader = request.needList("directLeader", String.class);
            businessTrip.setDirectLeader(directLeader);
            List<String> mainLeader = request.needList("mainLeader", String.class);
            businessTrip.setMainLeader(mainLeader);
            this.businessTripService.applyBusinessTrip(businessTrip);
            result.put("isSuccess", true);
            result.put("msg", "");
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u5047\u7533\u8bf7\u51fa\u9519 {}", (Throwable)e);
        }
        return result;
    }
}

