/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.google.common.collect.Lists;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.bean.ApplyLeaveInfo;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.LeaveService;
import pams.function.xatl.ruyihu.service.impl.BusinessTripServiceImpl;
import pams.function.xatl.ruyihu.util.LakeMobException;

@Service
public class ApplyLeave
extends AbstractLakeMobMethod {
    @Resource
    private LeaveService leaveService;
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private FastDFSClientService fastDFSClientService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            String type = request.needText("type");
            String beginDate = request.needText("beginDate");
            int beginHalfDay = request.needInt("beginHalfDay");
            String endDate = request.needText("endTime", "");
            if (!StringUtils.hasText((String)endDate)) {
                endDate = request.needText("endDate", "");
            }
            if (!StringUtils.hasText((String)endDate)) {
                throw new LakeMobException("endTime endDate \u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
            }
            int queryMaxInterval = 60;
            float dayCount = request.needFloat("dayCount");
            if (dayCount > (float)queryMaxInterval) {
                String msg = "\u8bf7\u5047\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7" + queryMaxInterval + "\u5929";
                result.put("isSuccess", false);
                result.put("msg", msg);
                throw new LakeMobException(msg);
            }
            int endHalfDay = request.needInt("endHalfDay");
            String reason = request.needText("reason");
            int maxLen = 120;
            if (reason.length() > maxLen) {
                String msg = "\u8bf7\u5047\u539f\u56e0\u592a\u957f";
                result.put("isSuccess", false);
                result.put("msg", msg);
                throw new LakeMobException(msg);
            }
            String joinDate = request.needText("joinDate", "");
            String cellLeaderId = request.needText("cellLeaderId", "");
            List<String> workflowPersonList = request.needList("workflowPersonList", String.class);
            List<String> attachmentList = request.needList("attachmentList", String.class);
            ApplyLeaveInfo info = new ApplyLeaveInfo();
            info.setUserId(currentUser);
            info.setType(type);
            info.setBeginDate(beginDate);
            info.setBeginHalfDay(beginHalfDay);
            info.setEndTime(endDate);
            info.setEndHalfDay(endHalfDay);
            info.setDayCount(Float.valueOf(dayCount));
            info.setReason(reason);
            info.setJoinDate(joinDate);
            info.setCellLeaderId(cellLeaderId);
            info.setWorkflowPersonList(workflowPersonList);
            ArrayList attachmentEntities = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(attachmentList)) {
                File parent = new File(QueryReportTemplateBean.ROOT_PATH, "tmpAttacheDir");
                for (String one : attachmentList) {
                    AttachmentEntity att = this.attachmentService.getUnuseAttachment(one, "leave");
                    if (att == null) continue;
                    FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(new File(parent, att.getAttachmentUrl()), att.getAttachmentName());
                    att.setAttachmentUrl(fastFileInfo.getFileId());
                    attachmentEntities.add(att);
                }
            }
            String leaveId = this.leaveService.applyLeave(info, attachmentEntities);
            BusinessTripServiceImpl.leaveApplyListNewStatusMap.put(leaveId, true);
            result.put("isSuccess", true);
            result.put("msg", "");
        }
        catch (LakeMobException e) {
            this.logger.error("\u8bf7\u5047\u7533\u8bf7\u51fa\u9519 {}", (Throwable)e);
        }
        return result;
    }
}

