/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.task.Task;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowNoticeEntity;
import pams.function.xatl.ruyihu.enums.BusinessTripStatusEnum;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.service.IFlowNoticeService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobException;

@Service
public class ApprovalBusinessTrip
extends AbstractLakeMobMethod {
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private IBusinessTripService businessTripService;
    @Resource
    private IFlowNoticeService flowNoticeService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        String applyId = request.needText("applyId");
        int type = request.needInt("type");
        BusinessTripEntity businessTrip = this.businessTripService.get(applyId);
        if (businessTrip.getStatus() == BusinessTripStatusEnum.REVOKE.value) {
            List<FlowNoticeEntity> flowNoticeEntities = this.flowNoticeService.get(applyId, "business_trip", currentUser);
            if (CollectionUtils.isEmpty(flowNoticeEntities)) {
                for (FlowNoticeEntity flowNoticeEntity : flowNoticeEntities) {
                    this.flowNoticeService.delete(flowNoticeEntity);
                }
            }
            throw new LakeMobException("\u8be5\u7533\u8bf7\u5df2\u7ecf\u88ab\u64a4\u9500");
        }
        if (businessTrip.getStatus() == BusinessTripStatusEnum.DELETE.value) {
            throw new LakeMobException("\u8be5\u7533\u8bf7\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        List<FlowAssociateEntity> flowAssociateList = this.flowAssociateService.getFlowAssociateListByBusinessTripId(applyId);
        if (CollectionUtils.isEmpty(flowAssociateList)) {
            this.logger.debug("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458,applyId:{}, userId:{}", (Object)applyId, (Object)currentUser);
            throw new LakeMobException("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458\u4e0d\u80fd\u5ba1\u6279");
        }
        FlowAssociateEntity personFlowAssociateEntity = null;
        for (FlowAssociateEntity flowAssociateEntity : flowAssociateList) {
            if (!flowAssociateEntity.getPersonId().equals(currentUser)) continue;
            personFlowAssociateEntity = flowAssociateEntity;
            break;
        }
        if (null == personFlowAssociateEntity) {
            this.logger.debug("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458,applyId:{}, userId:{}", (Object)applyId, (Object)currentUser);
            throw new LakeMobException("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458\u4e0d\u80fd\u5ba1\u6279");
        }
        Task task = this.lakeMobWorkflowService.getTask(currentUser, businessTrip.getWorkflowId());
        if (null != task) {
            this.lakeMobWorkflowService.completeBusinessTripApprovalTask(task.getId(), type);
        }
        return new HashMap(8);
    }
}

