/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.AnnouncementEntity;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.ReadingLogEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.AnnouncementService;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.ReadingLogService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class GetAnnouncementDetail
extends AbstractLakeMobMethod {
    @Resource
    private AnnouncementService announcementService;
    @Resource
    private ReadingLogService readingLogService;
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private FastDFSClientService fastDFSClientService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        String announcementId = request.needText("announcementId");
        AnnouncementEntity one = this.announcementService.getAnnouncementById(announcementId);
        AbstractMyAssert.notNull(one, "\u901a\u77e5\u516c\u544a" + announcementId + "\u4e0d\u5b58\u5728");
        List<ReadingLogEntity> readingLog = this.readingLogService.findReadingLog(currentUser, Arrays.asList(announcementId));
        ObjectNode tmp = QuickJson.newObjectNode().put("id", one.getId()).put("title", one.getTitle()).put("department", one.getDepartment()).put("publishTime", DateFormatUtils.format((Date)one.getPublishTime(), (String)"yyyy/MM/dd")).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd")).put("read", !readingLog.isEmpty()).put("content", one.getContent());
        List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(announcementId, "anno");
        ArrayNode attachmentListNode = JsonNodeFactory.instance.arrayNode();
        for (AttachmentEntity att : attachments) {
            attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", att.getAttachmentId()).put("size", att.getAttachmentSize()).put("name", att.getAttachmentName()).put("url", this.fastDFSClientService.getRealDownloadUrl(att.getAttachmentUrl())));
        }
        tmp.put("attachmentList", (JsonNode)attachmentListNode);
        return tmp;
    }
}

