/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.xdja.pams.common.util.Page;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.AnnouncementEntity;
import pams.function.xatl.ruyihu.entity.ReadingLogEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.AnnouncementService;
import pams.function.xatl.ruyihu.service.ReadingLogService;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class GetAnnouncementList
extends AbstractLakeMobMethod {
    @Resource
    private AnnouncementService announcementService;
    @Resource
    private ReadingLogService readingLogService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        String title = request.needText("title", "");
        long timestamp = request.needLong("timestamp", 0L);
        int pageSize = request.needInt("pageSize", 10);
        int page = (int)(timestamp + 1L);
        int total = this.announcementService.countAnnouncement(title);
        int totalPage = total / pageSize + (total % pageSize == 0 ? 0 : 1);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPage) {
            page = totalPage;
        }
        boolean dataEnd = page == totalPage;
        List<AnnouncementEntity> datas = this.announcementService.getTopAnnouncementList(currentUser, title, new Page(page, pageSize));
        ObjectNode root = QuickJson.newObjectNode();
        ArrayNode dataList = QuickJson.newArrayNode();
        List<ReadingLogEntity> readingLogList = this.readingLogService.findReadingLog(currentUser, this.toIds(datas));
        Set<String> readAnnouncementSet = this.toAnnouncementSet(readingLogList);
        for (AnnouncementEntity one : datas) {
            ObjectNode tmp = QuickJson.newObjectNode().put("id", one.getId()).put("title", one.getTitle()).put("department", one.getDepartment()).put("publishTime", DateFormatUtils.format((Date)one.getPublishTime(), (String)"yyyy/MM/dd")).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd")).put("read", readAnnouncementSet.contains(one.getId()));
            dataList.add((JsonNode)tmp);
        }
        root.put("timestamp", page);
        root.put("dataEnd", dataEnd);
        root.put("dataList", (JsonNode)dataList);
        return root;
    }

    private Set<String> toAnnouncementSet(List<ReadingLogEntity> readingLogList) {
        HashSet<String> strings = new HashSet<String>(readingLogList.size());
        if (readingLogList != null) {
            for (ReadingLogEntity one : readingLogList) {
                strings.add(one.getContentId());
            }
        }
        return strings;
    }

    private List<String> toIds(List<AnnouncementEntity> datas) {
        ArrayList rst = Lists.newArrayList();
        for (AnnouncementEntity one : datas) {
            rst.add(one.getId());
        }
        return rst;
    }
}

