/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.bean.LeaveListNode;
import pams.function.xatl.ruyihu.bean.LeaveListParam;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.LeaveQueryService;
import pams.function.xatl.ruyihu.service.impl.BusinessTripServiceImpl;
import pams.function.xatl.ruyihu.util.LakeMobException;

@Service
public class GetLeaveList
extends AbstractLakeMobMethod {
    @Resource
    private LeaveQueryService leaveQueryService;
    public static final Logger LOGGER = LoggerFactory.getLogger(GetLeaveList.class);

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        List<LeaveListNode> leaveListNodeList;
        int count;
        LeaveListParam leaveListParam = new LeaveListParam();
        leaveListParam.setUserId(currentUser);
        leaveListParam.setType(request.needText("type", ""));
        leaveListParam.setStatus(request.needText("status", ""));
        leaveListParam.setBeginDate(request.needText("beginDate", ""));
        leaveListParam.setEndDate(request.needText("endDate", ""));
        leaveListParam.setTimestamp(request.needLong("timestamp", 0L));
        int pageSize = request.needInt("pageSize", 10);
        try {
            count = this.leaveQueryService.countLeaveList(leaveListParam);
            leaveListNodeList = this.leaveQueryService.getLeaveList(leaveListParam, pageSize);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u62e5\u6709\u7684\u8bf7\u5047\u5916\u51fa\u8bb0\u5f55\u4fe1\u606f\u51fa\u9519\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u67e5\u8be2\u6307\u5b9a\u7528\u6237\u62e5\u6709\u7684\u8bf7\u5047\u5916\u51fa\u8bb0\u5f55\u4fe1\u606f\u51fa\u9519");
        }
        boolean dataEnd = count <= leaveListNodeList.size();
        HashMap<String, Object> root = new HashMap<String, Object>(3);
        root.put("timestamp", leaveListParam.getTimestamp());
        root.put("dataEnd", dataEnd);
        root.put("dataList", leaveListNodeList);
        BusinessTripServiceImpl.leaveApproveNewStatusMap.put(currentUser, false);
        return root;
    }
}

