/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.bims.service.UserManageService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.NoticeEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class GetNoticeDetail
extends AbstractLakeMobMethod {
    @Resource
    private NoticeService noticeService;
    @Resource
    private DocumentService documentService;
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private UserManageService userManageService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private ElectronicSignService electronicSignService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String noticeId = request.needText("noticeId");
        NoticeEntity notice = this.noticeService.getNoticeById(noticeId);
        AbstractMyAssert.notNull(notice, "\u516c\u6587\u901a\u77e5" + noticeId + "\u4e0d\u5b58\u5728");
        DocumentEntity doc = this.documentService.getDocumentById(notice.getDocumentId());
        AbstractMyAssert.notNull(doc, "\u516c\u6587" + notice.getDocumentId() + "\u4e0d\u5b58\u5728");
        List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(doc.getDocumentId(), "doc");
        ObjectNode documentNode = QuickJson.newObjectNode().put("documentId", doc.getDocumentId()).put("issueDate", DateFormatUtils.format((Date)doc.getIssueDate(), (String)"yyyy/MM/dd")).put("shortName", doc.getShortName()).put("typeDesc", LakeMobUtils.DOCUMENT_TYPE_MAP.get(doc.getDocumentType())).put("issueOffice", doc.getIssueOffice()).put("title", doc.getDocumentTitle()).put("workflowDone", "doc_status_done".equals(doc.getApprovalStatus()));
        ArrayNode attachArrNode = QuickJson.newArrayNode();
        for (AttachmentEntity one : attachments) {
            attachArrNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getAttachmentId()).put("size", one.getAttachmentSize()).put("name", one.getAttachmentName()).put("url", this.fastDFSClientService.getRealDownloadUrl(one.getAttachmentUrl())));
        }
        documentNode.put("attachmentList", (JsonNode)attachArrNode);
        ObjectNode starterNode = JsonNodeFactory.instance.objectNode();
        ObjectNode receiverNode = JsonNodeFactory.instance.objectNode();
        String noticeType = notice.getNoticeType();
        if ("notice_optype_copy_self".equals(noticeType) || "notice_optype_forward_self".equals(noticeType)) {
            this.renderStarterAndReceiver(notice, starterNode, receiverNode);
        } else if ("notice_optype_forward_other".equals(noticeType) || "notice_optype_copy_other".equals(noticeType) || "notice_optype_copy_feedback".equals(noticeType) || "notice_optype_forward_feedback".equals(noticeType)) {
            NoticeEntity sourceNotice = this.noticeService.getNoticeById(notice.getSourceId());
            AbstractMyAssert.notNull(sourceNotice, "\u6e90\u901a\u77e5\u4fe1\u606f\u4e3a\u7a7a");
            this.renderStarterAndReceiver(sourceNotice, starterNode, receiverNode);
        } else if ("notice_optype_done".equals(noticeType)) {
            this.renderStarterAndReceiver(notice, starterNode, receiverNode);
        }
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put("noticeId", noticeId).put("opType", notice.getNoticeType()).put("processed", LakeMobUtils.isTrue(notice.getProcessStatus())).put("document", (JsonNode)documentNode);
        root.put("starter", (JsonNode)starterNode);
        root.put("receiver", (JsonNode)receiverNode);
        return root;
    }

    private void renderStarterAndReceiver(NoticeEntity notice, ObjectNode starterNode, ObjectNode receiverNode) {
        FlowTraceEntity trace = this.flowTraceService.getFlowTraceByBusinessAndTaskIdAndPerson(notice.getDocumentId(), notice.getSourceId(), notice.getStarterId());
        AbstractMyAssert.notNull(trace, "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u8f68\u8ff9");
        ElectronicSignEntity tracePersonSign = this.electronicSignService.getElectronicSignByPerson(trace.getPersonId());
        starterNode.put("id", trace.getTraceId()).put("personId", trace.getPersonId()).put("personName", this.userManageService.queryPersonById(trace.getPersonId()).getName()).put("comment", trace.getProcessComment()).put("createTime", DateFormatUtils.format((Date)trace.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(LakeMobUtils.getSignUrl(tracePersonSign)));
        ElectronicSignEntity receiverSign = this.electronicSignService.getElectronicSignByPerson(notice.getReceiverId());
        receiverNode.put("id", notice.getNoticeId()).put("personId", notice.getReceiverId()).put("personName", this.userManageService.queryPersonById(notice.getReceiverId()).getName()).put("processed", LakeMobUtils.isTrue(notice.getProcessStatus())).put("comment", notice.getProcessComment()).put("createTime", DateFormatUtils.format((Date)notice.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(LakeMobUtils.getSignUrl(receiverSign)));
    }
}

