/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import com.xdja.pams.bims.service.UserManageService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.entity.NoticeEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class GetNoticeList
extends AbstractLakeMobMethod {
    @Resource
    private NoticeService noticeService;
    @Resource
    private UserManageService userManageService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String pending = request.needText("pending", "");
        long timestamp = request.needLong("timestamp", 0L);
        int pageSize = request.needInt("pageSize", 10);
        String status = null;
        if (StringUtils.hasText((String)pending)) {
            status = LakeMobUtils.isTrue(pending) ? "0" : "1";
        }
        List<NoticeEntity> datas = this.noticeService.getTopNoticeList(currentUser, timestamp, pageSize, status);
        int count = this.noticeService.countNoticeList(currentUser, timestamp, status);
        boolean dataEnd = count <= datas.size();
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ArrayNode dataList = JsonNodeFactory.instance.arrayNode();
        for (NoticeEntity one : datas) {
            ObjectNode tmp = JsonNodeFactory.instance.objectNode().put("noticeId", one.getNoticeId()).put("processed", LakeMobUtils.isTrue(one.getProcessStatus())).put("documentId", one.getDocumentId()).put("starterId", one.getStarterId()).put("starterName", this.userManageService.queryPersonById(one.getStarterId()).getName()).put("opType", one.getNoticeType()).put("receiverId", one.getReceiverId()).put("title", one.getDocumentTitle()).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss"));
            if (one.getReceiverId().equals(currentUser)) {
                tmp.put("receiverName", "\u6211");
            } else {
                tmp.put("receiverName", this.userManageService.queryPersonById(one.getReceiverId()).getName());
            }
            dataList.add((JsonNode)tmp);
        }
        root.put("dataEnd", dataEnd);
        NoticeEntity last = (NoticeEntity)Iterables.getLast(datas, null);
        if (last != null) {
            root.put("timestamp", last.getCreateTime().getTime());
        } else {
            root.put("timestamp", 0);
        }
        root.put("dataList", (JsonNode)dataList);
        return root;
    }
}

