/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.task.Task;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobException;

@Service
public class ProcessDocumentApproval
extends AbstractLakeMobMethod {
    @Resource
    private DocumentService documentService;
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String taskId = request.needText("taskId");
        Task task = this.lakeMobWorkflowService.getTask(taskId);
        if (null == task) {
            throw new LakeMobException("\u8be5\u516c\u6587\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        String businessKey = this.lakeMobWorkflowService.getBusinessKey(task);
        if (!StringUtils.hasText((String)businessKey)) {
            throw new LakeMobException("\u8be5\u516c\u6587\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        DocumentEntity document = this.documentService.getDocumentById(businessKey);
        if (null == document) {
            throw new LakeMobException("\u8be5\u516c\u6587\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        String comment = request.needText("comment", "");
        AbstractMyAssert.isTrue(comment.length() <= 50, "comment \u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57");
        String forwardTo = request.needText("forwardTo", "");
        List<String> copyToList = request.needList("copyToList", String.class);
        List<String> forwardToList = request.needList("forwardToList", String.class);
        if (StringUtils.hasText((String)forwardTo) && !forwardToList.contains(forwardTo)) {
            forwardToList.add(forwardTo);
        }
        boolean success = this.documentService.completeDocumentApprovalTask(currentUser, taskId, comment, forwardToList, copyToList);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put("otherDone", !success);
        return root;
    }
}

