/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.QuickJson;
import pams.function.xatl.util.BASE64DecoderUtil;

@Service
public class UpdateElectronicSign
extends AbstractLakeMobMethod {
    @Resource
    private ElectronicSignService electronicSignService;
    @Resource
    private FastDFSClientService fastDFSClientService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String electronicSign = request.needText("electronicSign");
        byte[] bytes = null;
        try {
            bytes = BASE64DecoderUtil.string2Bytes(electronicSign);
        }
        catch (Exception e) {
            throw new LakeMobException("\u89e3\u7801BASE64\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a" + e.getMessage());
        }
        FastFileInfo info = this.fastDFSClientService.uploadFile(bytes, "sign_" + currentUser + ".png");
        ElectronicSignEntity signEntity = this.electronicSignService.updateElectronicSign(currentUser, info);
        return QuickJson.newObjectNode().put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(signEntity.getSignUrl()));
    }
}

