/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.NoticeEntity;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.FastDFSCacheService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;

@Service
public class DocumentReportService {
    private final Logger logger = LoggerFactory.getLogger(DocumentReportService.class);
    @Resource
    private DocumentService documentService;
    @Resource
    private NoticeService noticeService;
    @Resource
    private UserManageService userManageService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private FastDFSCacheService fastDFSCacheService;

    public byte[] reportToPDF(String documentId) throws JRException, FileNotFoundException {
        String classResourcePath;
        Map<String, Object> parameters;
        DocumentEntity doc = this.documentService.getDocumentById(documentId);
        AbstractMyAssert.notNull(doc, "\u516c\u6587" + documentId + "\u4e0d\u5b58\u5728");
        String documentType = doc.getDocumentType();
        if (documentType.equals("doc_type_receive") || documentType.equals("doc_type_receive_netmsg")) {
            parameters = this.getReceiveDocumentParameters(doc);
            classResourcePath = "/jrxml/receiveDocument.jrxml";
        } else {
            parameters = this.getIssueDocumentParameters(doc);
            classResourcePath = "/jrxml/issueDocument.jrxml";
        }
        URL resource = this.getClass().getResource(classResourcePath);
        if (resource == null) {
            this.logger.error("Can't found resource: " + classResourcePath);
            AbstractMyAssert.notNull(resource, "Can't found resource: " + classResourcePath);
        }
        this.logger.debug("read resource: " + resource.getFile());
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)new FileInputStream(resource.getFile()));
        return JasperRunManager.runReportToPdf((JasperReport)jasperReport, parameters, (JRDataSource)new JREmptyDataSource());
    }

    private Map<String, Object> getReceiveDocumentParameters(DocumentEntity doc) throws JRException {
        HashMap<String, Object> root = new HashMap<String, Object>(8);
        root.put("title", doc.getDocumentTitle());
        root.put("issueOffice", doc.getIssueOffice());
        root.put("shortName", doc.getShortName());
        this.fillHead(doc, root);
        this.fillLeaderAudit(doc, root);
        this.fillNiBanYiJian(doc, root);
        return root;
    }

    private void fillHead(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        String subHeadName;
        switch (doc.getDocumentType()) {
            case "doc_type_receive_netmsg": {
                subHeadName = this.compileReport("/jrxml/sub_head_receive_netmsg.jrxml");
                break;
            }
            case "doc_type_receive": {
                subHeadName = this.compileReport("/jrxml/sub_head_receive_file.jrxml");
                break;
            }
            default: {
                return;
            }
        }
        rootParams.put("sub_head_name", subHeadName);
    }

    private void fillNiBanYiJian(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        Map<String, Object> params = this.newParamsWithInit(2);
        List<FlowTraceEntity> traces = this.flowTraceService.getFlowTraceByBusinessAndTaskKey(doc.getDocumentId(), "opinionTask");
        String subNiBanYiJianName = traces.size() >= 2 ? this.compileReport("/jrxml/sub_nibanyijian_2.jrxml") : this.compileReport("/jrxml/sub_nibanyijian_1.jrxml");
        this.fillByTraces(params, traces);
        rootParams.put("sub_nibanyijian_params", params);
        rootParams.put("sub_nibanyijian_name", subNiBanYiJianName);
    }

    private Map<String, Object> newParamsWithInit(int size) {
        HashMap<String, Object> params = new HashMap<String, Object>(size);
        for (int i = 1; i <= size; ++i) {
            params.put("txt" + i, "");
            params.put("sign" + i, null);
            params.put("date" + i, "");
        }
        return params;
    }

    private void fillLeaderAudit(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        Map<String, Object> params = this.newParamsWithInit(5);
        List<FlowTraceEntity> traces = this.flowTraceService.getFlowTraceByBusinessAndTaskKey(doc.getDocumentId(), "leaderAuditTask");
        String subLeaderName = traces.size() >= 5 ? this.compileReport("/jrxml/sub_leader_5.jrxml") : (traces.size() < 1 ? this.compileReport("/jrxml/sub_leader_1.jrxml") : this.compileReport("/jrxml/sub_leader_" + traces.size() + ".jrxml"));
        this.fillByTraces(params, traces);
        rootParams.put("sub_leader_params", params);
        rootParams.put("sub_leader_name", subLeaderName);
    }

    private Map<String, Object> getIssueDocumentParameters(DocumentEntity doc) throws JRException {
        HashMap<String, Object> root = new HashMap<String, Object>(8);
        root.put("title", doc.getDocumentTitle());
        root.put("issueOffice", doc.getIssueOffice());
        root.put("issueYear", DateFormatUtils.format((Date)doc.getIssueDate(), (String)"yyyy"));
        root.put("issueMonth", DateFormatUtils.format((Date)doc.getIssueDate(), (String)"M"));
        root.put("issueDay", DateFormatUtils.format((Date)doc.getIssueDate(), (String)"d"));
        StringBuilder copyTo = new StringBuilder("");
        List<NoticeEntity> copyToList = this.noticeService.getCopyListByDocumentId(doc.getDocumentId());
        for (NoticeEntity one : copyToList) {
            Person person = this.userManageService.queryPersonById(one.getProcesserId());
            if (person == null) continue;
            copyTo.append(person.getName()).append("\u3001");
        }
        root.put("copyTo", copyTo.toString());
        this.fillCaption(doc, root);
        this.fillBanGongShiShenHe(doc, root);
        this.fillHuiQian(doc, root);
        this.fillQianFa(doc, root);
        this.fillNiGaoRen(doc, root);
        return root;
    }

    private void fillCaption(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        String subCaptionName;
        HashMap<String, String> params = new HashMap<String, String>(8);
        switch (doc.getDocumentType()) {
            case "doc_type_publish_summary": {
                subCaptionName = this.compileReport("/jrxml/sub_caption_f22.jrxml");
                params.put("caption", "\u5982\u610f\u6e56\u529e\u4e8b\u5904\u4f1a\u8bae\u7eaa\u8981");
                break;
            }
            case "doc_type_publish_party": {
                subCaptionName = this.compileReport("/jrxml/sub_caption_f19.jrxml");
                params.put("caption", "\u4e2d\u5171\u90d1\u5dde\u5e02\u90d1\u4e1c\u65b0\u533a\u5982\u610f\u6e56\u5de5\u4f5c\u59d4\u5458\u4f1a");
                break;
            }
            case "doc_type_publish_gov": {
                subCaptionName = this.compileReport("/jrxml/sub_caption_f22.jrxml");
                params.put("caption", "\u5982\u610f\u6e56\u529e\u4e8b\u5904");
                break;
            }
            default: {
                return;
            }
        }
        rootParams.put("sub_caption_params", params);
        rootParams.put("sub_caption_name", subCaptionName);
    }

    private void fillNiGaoRen(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        String subNiGaoRenName = this.compileReport("/jrxml/sub_nigaoren_1.jrxml");
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("txt1", "");
        params.put("sign1", this.fastDFSCacheService.getLocalSignPath(doc.getPersonId()));
        rootParams.put("sub_nigaoren_params", params);
        rootParams.put("sub_nigaoren_name", subNiGaoRenName);
    }

    private void fillBanGongShiShenHe(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        Map<String, Object> params = this.newParamsWithInit(2);
        List<FlowTraceEntity> traces = this.flowTraceService.getFlowTraceByBusinessAndTaskKey(doc.getDocumentId(), "officeAuditTask");
        String subBanGongShiShenHeName = traces.size() >= 2 ? this.compileReport("/jrxml/sub_bangongshishenhe_2.jrxml") : this.compileReport("/jrxml/sub_bangongshishenhe_1.jrxml");
        this.fillByTraces(params, traces);
        rootParams.put("sub_bangongshishenhe_params", params);
        rootParams.put("sub_bangongshishenhe_name", subBanGongShiShenHeName);
    }

    private void fillHuiQian(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        Map<String, Object> params = this.newParamsWithInit(12);
        List<FlowTraceEntity> traces = this.flowTraceService.getFlowTraceByBusinessAndTaskKey(doc.getDocumentId(), "countersignTask");
        String subHuiQianName = doc.getDocumentType().equals("doc_type_publish_summary") ? this.compileReport("/jrxml/sub_huiqian_huiyijiyao.jrxml") : (traces.size() >= 2 ? this.compileReport("/jrxml/sub_huiqian_2.jrxml") : this.compileReport("/jrxml/sub_huiqian_1.jrxml"));
        this.fillByTraces(params, traces);
        rootParams.put("sub_huiqian_params", params);
        rootParams.put("sub_huiqian_name", subHuiQianName);
    }

    private void fillByTraces(Map<String, Object> params, List<FlowTraceEntity> traces) {
        for (int i = 0; i < traces.size(); ++i) {
            int flag = i + 1;
            FlowTraceEntity one = traces.get(i);
            params.put("txt" + flag, StringUtils.hasText((String)one.getProcessComment()) ? one.getProcessComment() : "\u65e0");
            params.put("sign" + flag, this.fastDFSCacheService.getLocalSignPath(one.getPersonId()));
            Date date = one.getDoneTime();
            params.put("date" + flag, DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
        }
    }

    private void fillQianFa(DocumentEntity doc, Map<String, Object> rootParams) throws JRException {
        Map<String, Object> params = this.newParamsWithInit(2);
        List<FlowTraceEntity> traces = this.flowTraceService.getFlowTraceByBusinessAndTaskKey(doc.getDocumentId(), "issueTask");
        String subQianFaName = traces.size() >= 2 ? this.compileReport("/jrxml/sub_qianfa_2.jrxml") : this.compileReport("/jrxml/sub_qianfa_1.jrxml");
        this.fillByTraces(params, traces);
        rootParams.put("sub_qianfa_params", params);
        rootParams.put("sub_qianfa_name", subQianFaName);
    }

    public String compileReport(String classResource) throws JRException {
        String path = this.getClass().getResource(classResource).getPath();
        this.logger.debug("will compile subreport path: " + path);
        String subJasperFile = JasperCompileManager.compileReportToFile((String)path);
        this.logger.debug("compiled subreport: " + subJasperFile);
        return subJasperFile;
    }
}

