/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class FastDFSCacheService {
    private static final Logger LOG = LoggerFactory.getLogger(FastDFSCacheService.class);
    private String cacheDir = this.initCacheDir();
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private ElectronicSignService electronicSignService;
    private LoadingCache<String, String> fileCache = CacheBuilder.newBuilder().maximumSize(200L).removalListener((RemovalListener)new RemovalListener<String, String>(){

        public void onRemoval(RemovalNotification<String, String> removalNotification) {
            String value = (String)removalNotification.getValue();
            FileUtils.deleteQuietly((File)new File(value));
        }
    }).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            String randomCachePath = FastDFSCacheService.this.getRandomCachePath(key);
            FastDFSClientService.downloadTo(key, randomCachePath);
            return randomCachePath;
        }
    });

    private String initCacheDir() {
        File fastDFSCacheDir;
        URL resource = this.getClass().getResource("/app.properties");
        String path = resource.getPath();
        File classesPath = new File(path).getParentFile();
        if ("WEB-INF".equalsIgnoreCase(classesPath.getParentFile().getName())) {
            File webRootPath = classesPath.getParentFile().getParentFile();
            fastDFSCacheDir = new File(webRootPath, "fastDFSCache");
        } else if ("target".equalsIgnoreCase(classesPath.getParentFile().getName())) {
            File targetPath = classesPath.getParentFile();
            fastDFSCacheDir = new File(targetPath, "fastDFSCache");
        } else {
            throw new LakeMobException("\u672a\u77e5\u7684\u73af\u5883");
        }
        String absolutePath = fastDFSCacheDir.getAbsolutePath();
        if (!fastDFSCacheDir.exists()) {
            boolean mkdirs = fastDFSCacheDir.mkdirs();
            if (!mkdirs) {
                throw new LakeMobException("FastDFS\u6587\u4ef6\u7f13\u5b58\u76ee\u5f55\u521b\u5efa\u5931\u8d25:" + absolutePath);
            }
        } else {
            try {
                FileUtils.cleanDirectory((File)fastDFSCacheDir);
                fastDFSCacheDir.mkdirs();
            }
            catch (IOException e) {
                throw new LakeMobException("\u6e05\u7406FastDFS\u6587\u4ef6\u7f13\u5b58\u76ee\u5f55" + absolutePath + "\u5931\u8d25:" + e.getMessage());
            }
        }
        LOG.info("FastDFS\u6587\u4ef6\u7f13\u5b58\u76ee\u5f55:" + absolutePath);
        return absolutePath;
    }

    private String getRandomCachePath(String key) {
        return this.cacheDir + "/" + LakeMobUtils.uuid() + "." + Files.getFileExtension((String)key);
    }

    public String getLocalSignPath(String personId) {
        ElectronicSignEntity sign = this.electronicSignService.getElectronicSignByPerson(personId);
        if (sign == null) {
            return null;
        }
        String downloadUrl = this.fastDFSClientService.getRealDownloadUrl(sign.getSignUrl());
        String unchecked = (String)this.fileCache.getUnchecked((Object)downloadUrl);
        if (!new File(unchecked).exists()) {
            this.fileCache.invalidate((Object)downloadUrl);
            unchecked = (String)this.fileCache.getUnchecked((Object)downloadUrl);
        }
        return unchecked;
    }
}

