/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.xdja.pams.sso.bean.SynQueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.ruyihu.service.impl.BusinessTripServiceImpl;
import pams.function.xatl.ruyihu.util.QuickJson;
import pams.function.xatl.tims.bean.TaxMessageBean;
import pams.function.xatl.tims.service.MsgPushServiceForXatl;

@Service
public class LakeMobPushService {
    public static final Logger LOGGER = LoggerFactory.getLogger(LakeMobPushService.class);
    @Resource
    private MsgPushServiceForXatl msgPushService;
    @Resource
    private UserManageServiceForXatl userManageService;
    private volatile AtomicBoolean myLock = new AtomicBoolean(false);
    private ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("demo-pool-%d").build();
    ExecutorService singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), this.namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());

    private void pushMessage(String personIds, String source, String content) {
        TaxMessageBean taxMessageBean = new TaxMessageBean();
        taxMessageBean.setIds(personIds);
        ObjectNode msgs = QuickJson.newObjectNode().put("content", content).put("createTime", System.currentTimeMillis());
        ObjectNode msg = QuickJson.newObjectNode();
        msg.put("source", source).put("msgs", (JsonNode)msgs);
        taxMessageBean.setMsg(QuickJson.toJsonStr((JsonNode)msg));
        try {
            this.msgPushService.sendTaxMessage(taxMessageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001[" + content + "]\u7ed9[" + personIds + "]\u5931\u8d25!", (Throwable)e);
        }
    }

    public void pushMeeting(String ids, ObjectNode content, String businessId) {
        TaxMessageBean taxMessageBean = new TaxMessageBean();
        taxMessageBean.setIds(ids);
        ObjectNode msgs = QuickJson.newObjectNode();
        msgs.put("content", (JsonNode)content);
        msgs.put("businessId", businessId);
        msgs.put("createTime", System.currentTimeMillis());
        ObjectNode msg = QuickJson.newObjectNode();
        msg.put("source", "meetingType").put("msgs", (JsonNode)msgs);
        taxMessageBean.setMsg(QuickJson.toJsonStr((JsonNode)msg));
        try {
            this.msgPushService.sendTaxMessage(taxMessageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001[" + content + "]\u7ed9[" + ids + "]\u5931\u8d25!", (Throwable)e);
        }
    }

    public void pushWorkReport(String ids, String content, String businessId) {
        TaxMessageBean taxMessageBean = new TaxMessageBean();
        taxMessageBean.setIds(ids);
        ObjectNode msgs = QuickJson.newObjectNode().put("content", content).put("businessId", businessId).put("createTime", System.currentTimeMillis());
        ObjectNode msg = QuickJson.newObjectNode();
        msg.put("source", "workReport").put("msgs", (JsonNode)msgs);
        taxMessageBean.setMsg(QuickJson.toJsonStr((JsonNode)msg));
        try {
            this.msgPushService.sendTaxMessage(taxMessageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001[" + content + "]\u7ed9[" + ids + "]\u5931\u8d25!", (Throwable)e);
        }
    }

    public void pushDocumentApproval(List<String> ids) {
        this.pushMessage(Joiner.on((String)",").join(ids), "dbgw", "\u60a8\u6709\u65b0\u7684\u5f85\u529e\u516c\u6587");
    }

    public void pushDocumentNotice(Collection<String> ids) {
        this.pushMessage(Joiner.on((String)",").join(ids), "xgw", "\u60a8\u6709\u65b0\u7684\u516c\u6587\u901a\u77e5");
    }

    public void pushLeaveApproval(List<String> ids) {
        this.pushMessage(Joiner.on((String)",").join(ids), "qjwcsp", "\u60a8\u6709\u65b0\u7684\u8bf7\u5047\u5916\u51fa\u5ba1\u6279");
        for (String id : ids) {
            BusinessTripServiceImpl.leaveApplyNewStatusMap.put(id, true);
        }
    }

    public void pushLeaveEnd(List<String> ids) {
        this.pushMessage(Joiner.on((String)",").join(ids), "qjwcwc", "\u60a8\u7684\u8bf7\u5047\u5916\u51fa\u7533\u8bf7\u5ba1\u6279\u5b8c\u6210");
        for (String id : ids) {
            BusinessTripServiceImpl.leaveApproveNewStatusMap.put(id, true);
        }
    }

    public void pushAnnouncementPublish() {
        if (this.myLock.compareAndSet(false, true)) {
            SynQueryParam condition = new SynQueryParam();
            condition.setLastTime("0");
            final List<String> allIds = this.userManageService.queryAllPersonId();
            LOGGER.info("\u51c6\u5907\u5411{}\u4eba\u63a8\u9001\u65b0\u901a\u77e5\u516c\u544a", (Object)allIds.size());
            this.singleThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList<String> tmp = new ArrayList<String>();
                        for (String one : allIds) {
                            if (tmp.size() > 100) {
                                LOGGER.info("\u5f00\u59cb\u5411{}\u4eba\u63a8\u9001\u65b0\u901a\u77e5\u516c\u544a", (Object)tmp.size());
                                LakeMobPushService.this.pushMessage(Joiner.on((String)",").join(tmp), "tzgafb", "\u60a8\u6709\u65b0\u7684\u901a\u77e5\u516c\u544a");
                                tmp.clear();
                                continue;
                            }
                            tmp.add(one);
                        }
                        if (!tmp.isEmpty()) {
                            LOGGER.info("\u5f00\u59cb\u5411{}\u4eba\u63a8\u9001\u65b0\u901a\u77e5\u516c\u544a", (Object)tmp.size());
                            LakeMobPushService.this.pushMessage(Joiner.on((String)",").join(tmp), "tzgafb", "\u60a8\u6709\u65b0\u7684\u901a\u77e5\u516c\u544a");
                            tmp.clear();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u63a8\u9001\u65b0\u901a\u77e5\u516c\u544a\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        LakeMobPushService.this.myLock.set(false);
                        allIds.clear();
                        LOGGER.info("\u63a8\u9001\u65b0\u901a\u77e5\u516c\u544a\u7ed3\u675f");
                    }
                }
            });
            this.singleThreadPool.shutdown();
        }
    }

    public void pushApplyMoneyApproval(List<String> ids, String msg) {
        this.pushMessage(Joiner.on((String)",").join(ids), "zjsqsp", msg);
    }

    public void pushBusinessTripApproval(List<String> ids, String msg) {
        this.pushMessage(Joiner.on((String)",").join(ids), "ccsqsp", msg);
    }

    public void pushBusinessTripApply(List<String> ids, String msg) {
        this.pushMessage(Joiner.on((String)",").join(ids), "ccsq", msg);
    }
}

