/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.common.util.Page;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.dao.AnnouncementDao;
import pams.function.xatl.ruyihu.dao.AttachmentDao;
import pams.function.xatl.ruyihu.dao.ReadingLogDao;
import pams.function.xatl.ruyihu.entity.AnnouncementEntity;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.ReadingLogEntity;
import pams.function.xatl.ruyihu.service.AnnouncementService;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class AnnouncementServiceImpl
implements AnnouncementService {
    private final Logger logger = LoggerFactory.getLogger(AnnouncementServiceImpl.class);
    @Resource
    private AnnouncementDao announcementDao;
    @Resource
    private AttachmentDao attachmentDao;
    @Resource
    private LakeMobPushService lakeMobPushService;
    @Resource
    private ReadingLogDao readingLogDao;

    @Override
    public AnnouncementEntity getAnnouncementById(String announcementId) {
        return this.announcementDao.getById(announcementId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String publishAnnouncement(AnnouncementEntity one) {
        this.logger.info("\u5f00\u59cb\u53d1\u5e03\u65b0\u516c\u6587");
        if (one.getCreateTime() == null) {
            one.setCreateTime(LakeMobUtils.now());
        }
        this.announcementDao.save(one);
        int orderNum = 1;
        if (!CollectionUtils.isEmpty(one.getFastFileList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u9644\u4ef6\u4fe1\u606f\uff0c\u9644\u4ef6\u6570\u91cf{}", (Object)one.getFastFileList().size());
            for (FastFileInfo file : one.getFastFileList()) {
                AttachmentEntity attach = new AttachmentEntity();
                attach.setOwnerId(one.getId());
                attach.setType("anno");
                attach.setAttachmentName(file.getFileName());
                attach.setAttachmentSize((int)file.getFileSize());
                attach.setAttachmentUrl(file.getFileId());
                attach.setOrderNum(orderNum++);
                attach.setCreateTime(LakeMobUtils.now());
                this.attachmentDao.saveAttachment(attach);
            }
        }
        this.lakeMobPushService.pushAnnouncementPublish();
        return one.getId();
    }

    @Override
    public List<AnnouncementEntity> getAnnouncementList(AnnouncementEntity one, Page pageParam) {
        return this.announcementDao.getList(one, pageParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteAnnouncement(AnnouncementEntity one) {
        this.announcementDao.delete(one);
    }

    @Override
    public int countUnreadAnnouncement(String currentUser) {
        int total = this.announcementDao.count(new AnnouncementEntity());
        ReadingLogEntity condition = new ReadingLogEntity();
        condition.setType("anno");
        condition.setPersonId(currentUser);
        int read = this.readingLogDao.count(condition);
        return total - read;
    }

    @Override
    public List<AnnouncementEntity> getTopAnnouncementList(String currentUser, String titleLike, long timestamp, int pageSize) {
        AnnouncementEntity condition = new AnnouncementEntity();
        condition.setTitleLike(titleLike);
        condition.setTimestamp(timestamp);
        return this.announcementDao.getList(currentUser, condition, new Page(1, pageSize));
    }

    @Override
    public List<AnnouncementEntity> getTopAnnouncementList(String currentUser, String titleLike, Page page) {
        AnnouncementEntity condition = new AnnouncementEntity();
        condition.setTitleLike(titleLike);
        return this.announcementDao.getList(currentUser, condition, page);
    }

    @Override
    public int countAnnouncement(String titleLike, long timestamp) {
        AnnouncementEntity condition = new AnnouncementEntity();
        condition.setTitleLike(titleLike);
        condition.setTimestamp(timestamp);
        return this.announcementDao.count(condition);
    }

    @Override
    public int countAnnouncement(String titleLike) {
        AnnouncementEntity condition = new AnnouncementEntity();
        condition.setTitleLike(titleLike);
        return this.announcementDao.count(condition);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean readAnnouncement(String currentUser, String announcementId) {
        ReadingLogEntity condition = new ReadingLogEntity();
        condition.setPersonId(currentUser);
        condition.setContentId(announcementId);
        condition.setType("anno");
        List<ReadingLogEntity> list = this.readingLogDao.getList(condition);
        if (CollectionUtils.isEmpty(list)) {
            this.readingLogDao.save(condition);
            return true;
        }
        return false;
    }
}

