/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.dao.AuthDao;
import pams.function.xatl.ruyihu.entity.AuthEntity;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class AuthServiceImpl
implements AuthService {
    public static final Logger LOGGER = LoggerFactory.getLogger(AuthServiceImpl.class);
    @Resource
    private UserManageService userManageService;
    @Resource
    private AuthDao authDao;

    @Override
    public String getOfficeLeader() {
        List<AuthEntity> list = this.authDao.getAuthByType("office_leader");
        AuthEntity first = (AuthEntity)Iterables.getFirst(list, null);
        if (first == null) {
            LOGGER.error("\u529e\u516c\u5ba4\u4e3b\u4efb\u672a\u8bbe\u7f6e\uff01\uff01\uff01");
            throw new LakeMobException("\u529e\u516c\u5ba4\u4e3b\u4efb\u672a\u8bbe\u7f6e");
        }
        return first.getPersonId();
    }

    @Override
    public Person getOfficeLeaderPerson() {
        List<AuthEntity> list = this.authDao.getAuthByType("office_leader");
        AuthEntity first = (AuthEntity)Iterables.getFirst(list, null);
        if (first != null) {
            Person person = this.userManageService.queryPersonById(first.getPersonId());
            return person;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMeetingSummaryQueryAuth(List<String> ids) {
        this.authDao.deleteAuthByType("meeting_summary");
        for (String one : ids) {
            Person person = this.userManageService.queryPersonById(one);
            AbstractMyAssert.notNull(person, "\u4eba\u5458" + one + "\u4e0d\u5b58\u5728");
            AuthEntity e = new AuthEntity();
            e.setCreateTime(LakeMobUtils.now());
            e.setPersonId(one);
            e.setAuthType("meeting_summary");
            e.setMark("");
            e.setPersonName(person.getName());
            this.authDao.saveAuth(e);
        }
    }

    @Override
    public Set<String> getMeetingSummaryQueryAuth() {
        List<AuthEntity> list = this.authDao.getAuthByType("meeting_summary");
        HashSet rst = Sets.newHashSet();
        for (AuthEntity one : list) {
            rst.add(one.getPersonId());
        }
        return rst;
    }

    @Override
    public List<AuthEntity> getMeetingSummaryQueryAuthList() {
        return this.authDao.getAuthByType("meeting_summary");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOfficeLeader(String personId) {
        Person person = this.userManageService.queryPersonById(personId);
        AbstractMyAssert.notNull(person, "\u4eba\u5458" + personId + "\u4e0d\u5b58\u5728");
        this.authDao.deleteAuthByType("office_leader");
        AuthEntity e = new AuthEntity();
        e.setCreateTime(LakeMobUtils.now());
        e.setPersonId(personId);
        e.setAuthType("office_leader");
        e.setMark("");
        e.setPersonName(person.getName());
        this.authDao.saveAuth(e);
    }

    @Override
    public String getFinLeader() {
        List<AuthEntity> list = this.authDao.getAuthByType("fin_leader");
        AuthEntity first = (AuthEntity)Iterables.getFirst(list, null);
        if (first == null) {
            LOGGER.error("\u8d22\u653f\u6240\u7ba1\u7406\u5458\u672a\u8bbe\u7f6e\uff01\uff01\uff01");
            throw new LakeMobException("\u8d22\u653f\u6240\u7ba1\u7406\u5458\u672a\u8bbe\u7f6e");
        }
        return first.getPersonId();
    }

    @Override
    public Person getFinLeaderPerson() {
        List<AuthEntity> list = this.authDao.getAuthByType("fin_leader");
        AuthEntity first = (AuthEntity)Iterables.getFirst(list, null);
        if (first != null) {
            Person person = this.userManageService.queryPersonById(first.getPersonId());
            return person;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFinLeader(String personId) {
        Person person = this.userManageService.queryPersonById(personId);
        AbstractMyAssert.notNull(person, "\u4eba\u5458" + personId + "\u4e0d\u5b58\u5728");
        this.authDao.deleteAuthByType("fin_leader");
        AuthEntity e = new AuthEntity();
        e.setCreateTime(LakeMobUtils.now());
        e.setPersonId(personId);
        e.setAuthType("fin_leader");
        e.setMark("");
        e.setPersonName(person.getName());
        this.authDao.saveAuth(e);
    }
}

