/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.dao.CalendarDao;
import pams.function.xatl.ruyihu.entity.CalendarEntity;
import pams.function.xatl.ruyihu.enums.LeaveTypeEnum;
import pams.function.xatl.ruyihu.service.CalendarService;

@Service
public class CalendarServiceImpl
implements CalendarService {
    @Resource
    private CalendarDao calendarDao;

    @Override
    public List<CalendarEntity> queryCalendarEntityList() {
        return this.queryCalendarEntityList(null, null);
    }

    @Override
    public List<CalendarEntity> queryCalendarEntityList(Date beginDate, Date endDate) {
        List<CalendarEntity> calendarEntityList = this.calendarDao.queryCalendarEntityList(beginDate, endDate);
        if (calendarEntityList == null) {
            calendarEntityList = new ArrayList<CalendarEntity>();
        }
        return calendarEntityList;
    }

    @Override
    public Date addOneday(Date date) {
        return new Date(date.getTime() + 86400000L);
    }

    @Override
    public int getIntervalDays(Date beginDate, Date endDate) {
        if (null == beginDate || null == endDate) {
            return 0;
        }
        long intervalMilli = endDate.getTime() - beginDate.getTime();
        return (int)Math.abs(intervalMilli / 86400000L);
    }

    @Override
    public int getDayofWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    @Override
    public Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setDate(Date date, String type) {
        int dayOfWeek = this.getDayofWeek(date);
        CalendarEntity calendarEntity = this.calendarDao.getCalendarEntity(date);
        int sunday = 1;
        int saturday = 7;
        if ((dayOfWeek == sunday || dayOfWeek == saturday) && "rest".equals(type)) {
            if (calendarEntity != null) {
                this.calendarDao.deleteCalendarEntity(calendarEntity);
            }
            return;
        }
        if (dayOfWeek > sunday && dayOfWeek < saturday && "work".equals(type)) {
            if (calendarEntity != null) {
                this.calendarDao.deleteCalendarEntity(calendarEntity);
            }
            return;
        }
        if (calendarEntity == null) {
            calendarEntity = new CalendarEntity();
            calendarEntity.setId(Util.getDate((String)"yyyy-MM-dd", (Date)date));
            calendarEntity.setDaily(date);
            calendarEntity.setWeekday(dayOfWeek);
        }
        calendarEntity.setType(type);
        this.calendarDao.saveOrUpdateCalendarEntity(calendarEntity);
    }

    @Override
    public boolean isRestDay(Date date, List<CalendarEntity> calendarEntityList) {
        CalendarEntity calendarEntity = this.getCalendarEntity(date, calendarEntityList);
        if (calendarEntity != null) {
            return "rest".equals(calendarEntity.getType());
        }
        int dayofweek = this.getDayofWeek(date);
        return dayofweek == 1 || dayofweek == 7;
    }

    @Override
    public boolean isRestDay(Date date, List<CalendarEntity> calendarEntityList, String type) {
        if (LeaveTypeEnum.LEAVE_TYPE_MARITAL.getType().equals(type) || LeaveTypeEnum.LEAVE_TYPE_OTHER.getType().equals(type)) {
            return false;
        }
        return this.isRestDay(date, calendarEntityList);
    }

    @Override
    public CalendarEntity getCalendarEntity(Date date, List<CalendarEntity> calendarEntityList) {
        for (CalendarEntity calendarEntity : calendarEntityList) {
            if (calendarEntity.getDaily().getTime() != date.getTime()) continue;
            return calendarEntity;
        }
        return null;
    }
}

