/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.bean.StartIssueForm;
import pams.function.xatl.ruyihu.bean.StartReceiveForm;
import pams.function.xatl.ruyihu.dao.AttachmentDao;
import pams.function.xatl.ruyihu.dao.DocumentDao;
import pams.function.xatl.ruyihu.dao.FlowAssociateDao;
import pams.function.xatl.ruyihu.dao.NoticeDao;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class DocumentServiceImpl
implements DocumentService {
    private final Logger logger = LoggerFactory.getLogger(DocumentServiceImpl.class);
    @Resource
    private UserManageService userManageService;
    @Resource
    private DocumentDao documentDao;
    @Resource
    private AttachmentDao attachmentDao;
    @Resource
    private FlowAssociateDao flowAssociateDao;
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private NoticeDao noticeDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String startIssueDocument(StartIssueForm form) {
        FlowAssociateEntity fa;
        List<String> attachments;
        this.logger.info("\u5f00\u59cb\u5b58\u5165\u53d1\u6587\u4fe1\u606f\uff0c\u6807\u9898\uff1a{}", (Object)form.getTitle());
        DocumentEntity doc = new DocumentEntity();
        doc.setDocumentType(form.getType());
        doc.setDocumentTitle(form.getTitle());
        doc.setIssueDate(LakeMobUtils.parseDate(form.getIssueDate()));
        doc.setShortName(form.getShortName());
        if (StringUtils.hasText((String)form.getDepId())) {
            doc.setDepId(form.getDepId());
        } else {
            Person person = this.userManageService.queryPersonById(form.getPersonId());
            doc.setDepId(person.getDepId());
        }
        doc.setPersonId(form.getPersonId());
        doc.setIssueOffice(form.getIssueOffice());
        doc.setCreateTime(LakeMobUtils.now());
        doc.setApprovalStatus("doc_status_ing");
        this.documentDao.saveDocument(doc);
        int orderNum = 1;
        if (!CollectionUtils.isEmpty(form.getFastFileList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u9644\u4ef6\u4fe1\u606f\uff0c\u9644\u4ef6\u6570\u91cf{}", (Object)form.getFastFileList().size());
            for (FastFileInfo file : form.getFastFileList()) {
                AttachmentEntity attach = new AttachmentEntity();
                attach.setOwnerId(doc.getDocumentId());
                attach.setType("doc");
                attach.setAttachmentName(file.getFileName());
                attach.setAttachmentSize((int)file.getFileSize());
                attach.setAttachmentUrl(file.getFileId());
                attach.setOrderNum(orderNum++);
                attach.setCreateTime(LakeMobUtils.now());
                this.attachmentDao.saveAttachment(attach);
            }
        }
        if (!CollectionUtils.isEmpty(attachments = form.getAttachments())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u9644\u4ef6\u4fe1\u606f\uff0c\u9644\u4ef6\u6570\u91cf{}", (Object)form.getAttachments().size());
            File parent = new File(QueryReportTemplateBean.ROOT_PATH, "tmpAttacheDir");
            for (String attach : attachments) {
                AttachmentEntity att = this.attachmentDao.getUnuseAttachment(attach);
                if (att == null) continue;
                FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(new File(parent, att.getAttachmentUrl()), att.getAttachmentName());
                att.setAttachmentUrl(fastFileInfo.getFileId());
                att.setOwnerId(doc.getDocumentId());
                att.setType("doc");
                this.attachmentDao.saveAttachment(att);
            }
        }
        orderNum = 1;
        if (!CollectionUtils.isEmpty(form.getOfficeFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u529e\u516c\u5ba4\u5ba1\u6838\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getOfficeFlowPersonList().size());
            for (String one : form.getOfficeFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("officeAuditTask");
                fa.setPersonId(one);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        if (!CollectionUtils.isEmpty(form.getCountersignFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u4f1a\u7b7e\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getCountersignFlowPersonList().size());
            for (String one : form.getCountersignFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("countersignTask");
                fa.setPersonId(one);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        if (!CollectionUtils.isEmpty(form.getIssueFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u7b7e\u53d1\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getIssueFlowPersonList().size());
            for (String one : form.getIssueFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("issueTask");
                fa.setPersonId(one);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        if (!CollectionUtils.isEmpty(form.getDoneFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u529e\u7ed3\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getDoneFlowPersonList().size());
            for (String donePerson : form.getDoneFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("doneTask");
                fa.setPersonId(donePerson);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        String processInstanceId = this.lakeMobWorkflowService.startIssueDocumentWorkflow(form, doc.getDocumentId());
        doc.setWorkflowId(processInstanceId);
        this.documentDao.saveDocument(doc);
        return doc.getDocumentId();
    }

    @Override
    public DocumentEntity getDocumentById(String businessKey) {
        return this.documentDao.getDocumentById(businessKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean completeDocumentApprovalTask(String currentUser, String taskId, String comment, List<String> forwardToList, List<String> copyToList) {
        return this.lakeMobWorkflowService.completeDocumentApprovalTask(currentUser, taskId, comment, forwardToList, copyToList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doneDocument(String documentId) {
        DocumentEntity doc = this.documentDao.getDocumentById(documentId);
        if (doc != null) {
            doc.setApprovalStatus("doc_status_done");
            doc.setDoneTime(LakeMobUtils.now());
            this.documentDao.saveDocument(doc);
        }
    }

    @Override
    public List<DocumentEntity> getDocumentList(Date begin, Date end, String titleLike, String type, String status, boolean hasSummaryAuth, Page pageParam) {
        return this.documentDao.getDocumentList(begin, end, titleLike, type, status, hasSummaryAuth, pageParam);
    }

    @Override
    public List<DocumentEntity> getTopDocumentListWithApproval(String currentUser, long timestamp, int pageSize, String titleLike, String status, String type, String shortNameLike, Date begin, Date end) {
        return this.documentDao.getTopDocumentListWithApproval(currentUser, timestamp, pageSize, titleLike, status, type, shortNameLike, begin, end, false);
    }

    @Override
    public int countDocumentListWithApproval(String currentUser, long timestamp, String titleLike, String status, String type, String shortNameLike, Date begin, Date end) {
        return this.documentDao.countDocumentListWithApproval(currentUser, timestamp, titleLike, status, type, shortNameLike, begin, end);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String startReceiveDocument(StartReceiveForm form) {
        FlowAssociateEntity fa;
        List<String> attachments;
        this.logger.info("\u5f00\u59cb\u5b58\u5165\u6536\u6587\u4fe1\u606f\uff0c\u6807\u9898\uff1a{}", (Object)form.getTitle());
        DocumentEntity doc = new DocumentEntity();
        doc.setDocumentType(form.getType());
        doc.setDocumentTitle(form.getTitle());
        doc.setIssueDate(LakeMobUtils.parseDate(form.getIssueDate()));
        doc.setShortName(form.getShortName());
        if (StringUtils.hasText((String)form.getDepId())) {
            doc.setDepId(form.getDepId());
        } else {
            Person person = this.userManageService.queryPersonById(form.getPersonId());
            doc.setDepId(person.getDepId());
        }
        doc.setPersonId(form.getPersonId());
        doc.setIssueOffice(form.getIssueOffice());
        doc.setCreateTime(LakeMobUtils.now());
        doc.setApprovalStatus("doc_status_ing");
        this.documentDao.saveDocument(doc);
        int orderNum = 1;
        if (!CollectionUtils.isEmpty(form.getFastFileList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u9644\u4ef6\u4fe1\u606f\uff0c\u9644\u4ef6\u6570\u91cf{}", (Object)form.getFastFileList().size());
            for (FastFileInfo file : form.getFastFileList()) {
                AttachmentEntity attach = new AttachmentEntity();
                attach.setOwnerId(doc.getDocumentId());
                attach.setType("doc");
                attach.setAttachmentName(file.getFileName());
                attach.setAttachmentSize((int)file.getFileSize());
                attach.setAttachmentUrl(file.getFileId());
                attach.setOrderNum(orderNum++);
                attach.setCreateTime(LakeMobUtils.now());
                this.attachmentDao.saveAttachment(attach);
            }
        }
        if (!CollectionUtils.isEmpty(attachments = form.getAttachments())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u9644\u4ef6\u4fe1\u606f\uff0c\u9644\u4ef6\u6570\u91cf{}", (Object)form.getAttachments().size());
            File parent = new File(QueryReportTemplateBean.ROOT_PATH, "tmpAttacheDir");
            for (String attach : attachments) {
                AttachmentEntity att = this.attachmentDao.getUnuseAttachment(attach);
                if (att == null) continue;
                FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(new File(parent, att.getAttachmentUrl()), att.getAttachmentName());
                att.setAttachmentUrl(fastFileInfo.getFileId());
                att.setOwnerId(doc.getDocumentId());
                att.setType("doc");
                this.attachmentDao.saveAttachment(att);
            }
        }
        orderNum = 1;
        if (!CollectionUtils.isEmpty(form.getOpinionFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u62df\u529e\u610f\u89c1\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getOpinionFlowPersonList().size());
            for (String one : form.getOpinionFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("opinionTask");
                fa.setPersonId(one);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        if (!CollectionUtils.isEmpty(form.getLeaderFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u9886\u5bfc\u6279\u793a\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getLeaderFlowPersonList().size());
            for (String one : form.getLeaderFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("leaderAuditTask");
                fa.setPersonId(one);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        if (!CollectionUtils.isEmpty(form.getDoneFlowPersonList())) {
            this.logger.info("\u5f00\u59cb\u5b58\u5165\u529e\u7ed3\u4eba\u5458\uff0c\u6570\u91cf{}", (Object)form.getDoneFlowPersonList().size());
            for (String donePerson : form.getDoneFlowPersonList()) {
                fa = new FlowAssociateEntity();
                fa.setBusinessType("document");
                fa.setBusinessId(doc.getDocumentId());
                fa.setTaskKey("doneTask");
                fa.setPersonId(donePerson);
                fa.setOrderNum(orderNum++);
                fa.setProcessStatus("0");
                fa.setCreateTime(LakeMobUtils.now());
                this.flowAssociateDao.saveFlowAssociate(fa);
            }
        }
        String processInstanceId = this.lakeMobWorkflowService.startReceiveDocumentWorkflow(form, doc.getDocumentId());
        doc.setWorkflowId(processInstanceId);
        this.documentDao.saveDocument(doc);
        return doc.getDocumentId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String documentId) {
        DocumentEntity document = this.documentDao.getDocumentById(documentId);
        this.documentDao.delete(document);
        this.noticeDao.deleteByDoc(documentId);
        this.lakeMobWorkflowService.delete(documentId, "lakemob_document");
    }
}

