/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.service.UserManageService;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.dao.ElectronicSignDao;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.util.AbstractMyAssert;

@Service
public class ElectronicSignServiceImpl
implements ElectronicSignService {
    @Resource
    private ElectronicSignDao electronicSignDao;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private UserManageService userManageService;

    @Override
    public ElectronicSignEntity getElectronicSignByPerson(String personId) {
        return this.electronicSignDao.getElectronicSignByPerson(personId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ElectronicSignEntity updateElectronicSign(String personId, FastFileInfo info) {
        ElectronicSignEntity old = this.electronicSignDao.getElectronicSignByPerson(personId);
        if (old == null) {
            old = new ElectronicSignEntity();
            old.setPersonId(personId);
        }
        PersonBean person = this.userManageService.getPersonById(personId);
        AbstractMyAssert.notNull(person, "\u4eba\u5458" + personId + "\u4e0d\u5b58\u5728");
        old.setPersonName(person.getNAME());
        old.setSignUrl(info.getFileId());
        old.setUpdateTime(new Date());
        this.electronicSignDao.saveElectronicSign(old);
        return old;
    }
}

