/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.dao.FlowAssociateDao;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class FlowAssociateServiceImpl
implements FlowAssociateService {
    @Resource
    private FlowAssociateDao flowAssociateDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void completeFlowAssociate(String businessType, String businessKey, String taskKey, String assignee) {
        FlowAssociateEntity flowAssociate = this.flowAssociateDao.getFlowAssociate(businessType, businessKey, taskKey, assignee);
        if (flowAssociate != null) {
            flowAssociate.setProcessStatus("1");
            flowAssociate.setDoneTime(LakeMobUtils.now());
            this.flowAssociateDao.saveFlowAssociate(flowAssociate);
        }
    }

    @Override
    public List<FlowAssociateEntity> getFlowAssociateListByDocumentIdMergeDoneTask(String documentId) {
        List<FlowAssociateEntity> list = this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("document", documentId);
        boolean moreThanOneDoneTask = this.moreThanOneDoneTask(list);
        if (moreThanOneDoneTask) {
            ArrayList before = Lists.newArrayList();
            ArrayList doneFlowList = Lists.newArrayList();
            ArrayList after = Lists.newArrayList();
            boolean jump = false;
            for (FlowAssociateEntity one : list) {
                if ("doneTask".equals(one.getTaskKey())) {
                    doneFlowList.add(one);
                    jump = true;
                    continue;
                }
                if (jump) {
                    after.add(one);
                    continue;
                }
                before.add(one);
            }
            ArrayList rst = Lists.newArrayList();
            rst.addAll(before);
            FlowAssociateEntity processedDoneTaskFlow = this.getProcessedDoneTaskFlow(doneFlowList);
            if (processedDoneTaskFlow != null) {
                rst.add(processedDoneTaskFlow);
            } else {
                FlowAssociateEntity com = new FlowAssociateEntity();
                com.setBusinessType("document");
                com.setBusinessId(documentId);
                com.setId("0");
                com.setPersonId("0");
                com.setTaskKey("doneTask");
                com.setProcessStatus("0");
                com.setOrderNum(before.size() + 1);
                rst.add(com);
            }
            rst.addAll(after);
            return rst;
        }
        return list;
    }

    private FlowAssociateEntity getProcessedDoneTaskFlow(List<FlowAssociateEntity> list) {
        for (FlowAssociateEntity one : list) {
            if (!LakeMobUtils.isTrue(one.getProcessStatus())) continue;
            return one;
        }
        return null;
    }

    private boolean moreThanOneDoneTask(List<FlowAssociateEntity> list) {
        int i = 0;
        for (FlowAssociateEntity one : list) {
            if ("doneTask".equals(one.getTaskKey())) {
                ++i;
            }
            if (i < 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FlowAssociateEntity> getFlowAssociateListByDocumentId(String documentId) {
        return this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("document", documentId);
    }

    @Override
    public List<FlowAssociateEntity> getFlowAssociateListByLeaveId(String leaveId) {
        return this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("leave", leaveId);
    }

    @Override
    public List<FlowAssociateEntity> getFlowAssociateListByApplyMoneyId(String applyId) {
        return this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("apply_money", applyId);
    }

    @Override
    public List<FlowAssociateEntity> getFlowAssociateListByBusinessTripId(String businessTripId) {
        return this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("business_trip", businessTripId);
    }
}

