/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.dao.NoticeDao;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.NoticeEntity;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class NoticeServiceImpl
implements NoticeService {
    public static final Logger LOGGER = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Resource
    private NoticeDao noticeDao;
    @Resource
    private AuthService authService;
    @Resource
    private LakeMobPushService lakeMobPushService;
    @Resource
    private FlowAssociateService flowAssociateService;

    @Override
    public int getPendingNoticeCountByUser(String currentUser) {
        return this.noticeDao.getNoticeCountByProcessStatusAndProcesser("0", currentUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Set<String> forwardTo(String documentId, String documentTitle, String taskId, String starterId, List<String> receiverIds) {
        HashSet<String> needPush = new HashSet<String>();
        HashSet otherPeoples = Sets.newHashSet();
        List<FlowAssociateEntity> flows = this.flowAssociateService.getFlowAssociateListByDocumentId(documentId);
        for (FlowAssociateEntity one : flows) {
            otherPeoples.add(one.getPersonId());
        }
        String officeLeader = this.authService.getOfficeLeader();
        otherPeoples.add(officeLeader);
        for (String receiverId : new HashSet<String>(receiverIds)) {
            HashSet exclude = Sets.newHashSet();
            exclude.add(starterId);
            if (exclude.contains(receiverId)) continue;
            needPush.add(receiverId);
            LOGGER.info("{} forward document {} to {}", new Object[]{starterId, documentTitle, receiverId});
            NoticeEntity toMe = new NoticeEntity();
            toMe.setDocumentId(documentId);
            toMe.setDocumentTitle(documentTitle);
            toMe.setSourceId(taskId);
            toMe.setStarterId(starterId);
            toMe.setReceiverId(receiverId);
            toMe.setProcesserId(receiverId);
            toMe.setNoticeType("notice_optype_forward_self");
            toMe.setProcessStatus("0");
            toMe.setCreateTime(LakeMobUtils.now());
            this.noticeDao.saveNotice(toMe);
            exclude.add(receiverId);
            for (String oneId : otherPeoples) {
                if (exclude.contains(oneId)) continue;
                needPush.add(oneId);
                NoticeEntity toFlow = new NoticeEntity();
                toFlow.setDocumentId(documentId);
                toFlow.setDocumentTitle(documentTitle);
                toFlow.setSourceId(toMe.getNoticeId());
                toFlow.setStarterId(starterId);
                toFlow.setReceiverId(receiverId);
                toFlow.setProcesserId(oneId);
                toFlow.setNoticeType("notice_optype_forward_other");
                toFlow.setProcessStatus("0");
                toFlow.setCreateTime(LakeMobUtils.now());
                this.noticeDao.saveNotice(toFlow);
                LOGGER.info("notice flow associate{}, {} forward document {} to {}", new Object[]{oneId, starterId, documentTitle, receiverId});
            }
        }
        return needPush;
    }

    @Override
    public Set<String> copyTo(String documentId, String documentTitle, String taskId, String starterId, List<String> copyToList) {
        HashSet needPush = Sets.newHashSet();
        HashSet otherPeoples = Sets.newHashSet();
        List<FlowAssociateEntity> flows = this.flowAssociateService.getFlowAssociateListByDocumentId(documentId);
        for (FlowAssociateEntity one : flows) {
            otherPeoples.add(one.getPersonId());
        }
        String officeLeader = this.authService.getOfficeLeader();
        if (StringUtils.hasText((String)officeLeader) && !copyToList.contains(officeLeader)) {
            otherPeoples.add(officeLeader);
        }
        for (String one : copyToList) {
            HashSet exclude = Sets.newHashSet();
            exclude.add(starterId);
            if (exclude.contains(one)) continue;
            needPush.add(one);
            LOGGER.info("{} copy document {} to {}", new Object[]{starterId, documentTitle, one});
            NoticeEntity notice = new NoticeEntity();
            notice.setDocumentId(documentId);
            notice.setDocumentTitle(documentTitle);
            notice.setSourceId(taskId);
            notice.setStarterId(starterId);
            notice.setReceiverId(one);
            notice.setProcesserId(one);
            notice.setNoticeType("notice_optype_copy_self");
            notice.setProcessStatus("0");
            notice.setCreateTime(LakeMobUtils.now());
            this.noticeDao.saveNotice(notice);
            exclude.add(one);
            for (String oneId : otherPeoples) {
                if (exclude.contains(oneId)) continue;
                needPush.add(oneId);
                NoticeEntity toFlow = new NoticeEntity();
                toFlow.setDocumentId(documentId);
                toFlow.setDocumentTitle(documentTitle);
                toFlow.setSourceId(notice.getNoticeId());
                toFlow.setStarterId(starterId);
                toFlow.setReceiverId(one);
                toFlow.setProcesserId(oneId);
                toFlow.setNoticeType("notice_optype_copy_other");
                toFlow.setProcessStatus("0");
                toFlow.setCreateTime(LakeMobUtils.now());
                this.noticeDao.saveNotice(toFlow);
                LOGGER.info("notice flow associate{}, {} copy document {} to {}", new Object[]{oneId, starterId, documentTitle, one});
            }
        }
        return needPush;
    }

    @Override
    public void doneNotice(String documentId, String documentTitle, String taskId, String starterId, List<String> noticeList) {
        LOGGER.info("{} done document {}, notice {}", new Object[]{starterId, documentTitle, noticeList.toString()});
        for (String one : noticeList) {
            NoticeEntity notice = new NoticeEntity();
            notice.setDocumentId(documentId);
            notice.setDocumentTitle(documentTitle);
            notice.setSourceId(taskId);
            notice.setStarterId(starterId);
            notice.setReceiverId(one);
            notice.setProcesserId(one);
            notice.setNoticeType("notice_optype_done");
            notice.setProcessStatus("0");
            notice.setCreateTime(LakeMobUtils.now());
            this.noticeDao.saveNotice(notice);
        }
    }

    @Override
    public List<NoticeEntity> getCopyListByDocumentId(String documentId) {
        return this.noticeDao.getCopyListByDocumentId(documentId);
    }

    @Override
    public List<NoticeEntity> getTopNoticeList(String currentUser, long timestamp, int pageSize, String status) {
        return this.noticeDao.getTopNoticeList(currentUser, timestamp, pageSize, status);
    }

    @Override
    public int countNoticeList(String currentUser, long timestamp, String status) {
        return this.noticeDao.countNoticeList(currentUser, timestamp, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processNotice(String currentUser, String noticeId, String comment) {
        NoticeEntity notice = this.noticeDao.getNoticeById(noticeId);
        if (notice != null) {
            String noticeType;
            if (LakeMobUtils.isTrue(notice.getProcessStatus())) {
                throw new LakeMobException("\u8be5\u901a\u77e5\u5df2\u88ab\u5904\u7406");
            }
            if (!notice.getProcesserId().equals(currentUser)) {
                throw new LakeMobException("\u65e0\u6743\u5904\u7406\u8be5\u901a\u77e5");
            }
            notice.setProcessComment(comment);
            notice.setProcessStatus("1");
            notice.setDoneTime(LakeMobUtils.now());
            this.noticeDao.saveNotice(notice);
            if (!notice.getReceiverId().equals(currentUser)) {
                return;
            }
            if ("notice_optype_forward_self".equals(notice.getNoticeType())) {
                noticeType = "notice_optype_forward_feedback";
            } else if ("notice_optype_copy_self".equals(notice.getNoticeType())) {
                noticeType = "notice_optype_copy_feedback";
            } else {
                return;
            }
            HashSet needPush = Sets.newHashSet();
            needPush.add(currentUser);
            HashSet needNotice = Sets.newHashSet();
            List<FlowAssociateEntity> flows = this.flowAssociateService.getFlowAssociateListByDocumentId(notice.getDocumentId());
            for (FlowAssociateEntity one : flows) {
                needNotice.add(one.getPersonId());
            }
            String officeLeader = this.authService.getOfficeLeader();
            needNotice.add(officeLeader);
            for (String pid : needNotice) {
                if (needPush.contains(pid)) continue;
                needPush.add(pid);
                NoticeEntity one = new NoticeEntity();
                one.setDocumentId(notice.getDocumentId());
                one.setDocumentTitle(notice.getDocumentTitle());
                one.setSourceId(noticeId);
                one.setStarterId(currentUser);
                one.setReceiverId(notice.getStarterId());
                one.setProcesserId(pid);
                one.setNoticeType(noticeType);
                one.setProcessStatus("0");
                one.setCreateTime(LakeMobUtils.now());
                this.noticeDao.saveNotice(one);
            }
            needPush.remove(currentUser);
            this.lakeMobPushService.pushDocumentNotice(needPush);
        }
    }

    @Override
    public NoticeEntity getNoticeById(String noticeId) {
        return this.noticeDao.getNoticeById(noticeId);
    }

    @Override
    public void deleteByReceiverId(String receiverId) {
    }
}

