/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.dao.RegulationDao;
import pams.function.xatl.ruyihu.entity.RegulationEntity;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.RegulationService;

@Service
public class RegulationServiceImpl
implements RegulationService {
    @Resource
    private UserManageService userManageService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private RegulationDao regulationDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addRegulation(String regulationName, MultipartFile regulationFile) {
        FastFileInfo info = this.fastDFSClientService.uploadFile(regulationFile, regulationFile.getOriginalFilename());
        RegulationEntity entity = new RegulationEntity();
        entity.setFileName(info.getFileName());
        entity.setCreateTime(new Date());
        entity.setDownloadUrl(info.getFileId());
        entity.setFileSize((int)info.getFileSize());
        entity.setRegulationTitle(regulationName);
        this.regulationDao.saveRegulation(entity);
        return entity.getRegulationId();
    }

    @Override
    public int countRegulation(String titleLike, long timestamp) {
        return this.regulationDao.countRegulation(titleLike, timestamp);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRegulation(String regulationId) {
        RegulationEntity regulation = this.regulationDao.getRegulation(regulationId);
        if (regulation != null) {
            this.regulationDao.deleteRegulation(regulationId);
            this.fastDFSClientService.deleteFile(regulation.getDownloadUrl());
        }
    }

    @Override
    public List<RegulationEntity> getRegulationList(Date begin, Date end, String titleLike, Page pageParam) {
        return this.regulationDao.getRegulationList(begin, end, titleLike, pageParam);
    }

    @Override
    public List<RegulationEntity> getTopRegulationList(String titleLike, long timestamp, int pageSize) {
        return this.regulationDao.getTopRegulationList(titleLike, timestamp, pageSize);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRegulationTitle(String regulationId, String regulationName) {
        RegulationEntity regulation = this.regulationDao.getRegulation(regulationId);
        if (regulation != null) {
            regulation.setRegulationTitle(regulationName);
            this.regulationDao.saveRegulation(regulation);
        }
    }
}

