/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.workflow;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.service.UserManageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.dao.IApplyMoneyDao;
import pams.function.xatl.ruyihu.dao.IBusinessTripDao;
import pams.function.xatl.ruyihu.dao.IFlowNoticeDao;
import pams.function.xatl.ruyihu.entity.ApplyMoneyEntity;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.FlowNoticeEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.enums.ApplyMoneyStatusEnum;
import pams.function.xatl.ruyihu.enums.BusinessTripStatusEnum;
import pams.function.xatl.ruyihu.service.BusinessJoinerService;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.service.impl.BusinessTripServiceImpl;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service(value="lakeMobActivitiTaskListener")
public class LakeMobActivitiTaskListener
implements TaskListener {
    private static final long serialVersionUID = 1L;
    public static final Logger LOGGER = LoggerFactory.getLogger(LakeMobActivitiTaskListener.class);
    private static final String CREATE_STR = "create";
    private static final String COMPLETE_STR = "complete";
    @Resource
    private BusinessJoinerService businessJoinerService;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private NoticeService noticeService;
    @Resource
    private DocumentService documentService;
    @Resource
    private LakeMobPushService lakeMobPushService;
    @Resource
    private IApplyMoneyDao applyMoneyDao;
    @Resource
    private IBusinessTripDao businessTripDao;
    @Resource
    private IFlowNoticeDao flowNoticeDao;
    @Resource
    private UserManageService userManageService;

    public void notify(DelegateTask delegateTask) {
        String eventName = delegateTask.getEventName();
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        String taskKey = delegateTask.getTaskDefinitionKey();
        String assignee = delegateTask.getAssignee();
        if (LOGGER.isDebugEnabled()) {
            List<String> candidates = this.getCandidates(delegateTask);
            LOGGER.debug("Trigger taskListener, eventName: {}, taskName: {}, taskKey: {}, processKey: {}, processId: {}, assignee: {}, candidates: {}", new Object[]{eventName, delegateTask.getName(), taskKey, processDefinitionId, delegateTask.getProcessInstanceId(), assignee, candidates.toString()});
        }
        if (delegateTask instanceof TaskEntity) {
            TaskEntity task = (TaskEntity)delegateTask;
            ExecutionEntity processInstance = task.getProcessInstance();
            if (processInstance == null) {
                processInstance = task.getExecution().getParent();
            }
            String processInstanceId = processInstance.getProcessInstanceId();
            String businessKey = processInstance.getBusinessKey();
            if (processDefinitionId.startsWith("lakemob_document")) {
                this.processDocument(eventName, taskKey, assignee, task, processInstanceId, businessKey);
            } else if (processDefinitionId.startsWith("lakemob_leave")) {
                this.processLeave(eventName, taskKey, assignee, task, processInstanceId, businessKey);
            } else if (processDefinitionId.startsWith("lakemob_apply_money")) {
                this.processApplyMoney(eventName, taskKey, assignee, task, processInstanceId, businessKey);
            } else if (processDefinitionId.startsWith("lakemob_business_trip")) {
                this.processBusinessTrip(eventName, taskKey, assignee, task, processInstanceId, businessKey);
            }
        }
    }

    private void processBusinessTrip(String eventName, String taskKey, String assignee, TaskEntity task, String processInstanceId, String businessId) {
        Object type = task.getVariable("type");
        if (CREATE_STR.equals(eventName)) {
            if (StringUtils.hasText((String)assignee)) {
                boolean haveBusinessTripToApply;
                boolean bl = haveBusinessTripToApply = (null == type || LakeMobUtils.isTrue(type)) && !"revokeTask".equals(taskKey);
                if (haveBusinessTripToApply) {
                    this.businessJoinerService.addBusinessJoiner("business_trip", businessId, assignee);
                    this.lakeMobPushService.pushBusinessTripApproval(Collections.singletonList(assignee), "\u60a8\u6709\u65b0\u7684\u51fa\u5dee\u7533\u8bf7\u5f85\u5ba1\u6279");
                    for (String id : Collections.singletonList(assignee)) {
                        BusinessTripServiceImpl.businessTripApplyNewStatusMap.put(id, true);
                    }
                    FlowNoticeEntity flowNotice = new FlowNoticeEntity();
                    flowNotice.setBusinessId(businessId);
                    flowNotice.setPersonId(assignee);
                    flowNotice.setBusinessType("business_trip");
                    this.flowNoticeDao.save(flowNotice);
                }
            }
        } else if (COMPLETE_STR.equals(eventName)) {
            List<FlowNoticeEntity> flowNoticeEntities;
            this.flowAssociateService.completeFlowAssociate("business_trip", businessId, taskKey, assignee);
            String passStatus = LakeMobUtils.isTrue(task.getVariable("type")) ? "1" : "0";
            this.flowTraceService.addFlowTrace("business_trip", businessId, processInstanceId, task.getId(), taskKey, assignee, (String)task.getVariable("comment"), passStatus, task.getCreateTime(), LakeMobUtils.now());
            PersonBean person = this.userManageService.getPersonById(assignee);
            BusinessTripEntity businessTrip = this.businessTripDao.get(businessId);
            if (!LakeMobUtils.isTrue(passStatus) && !taskKey.equals("revokeTask")) {
                businessTrip.setStatus(BusinessTripStatusEnum.REFUSE.value);
                this.businessTripDao.save(businessTrip);
                this.lakeMobPushService.pushBusinessTripApply(Collections.singletonList(businessTrip.getApplyUserId()), person.getNAME() + "\u5ba1\u6279\u4e86\u60a8\u7684\u51fa\u5dee\u7533\u8bf7");
                FlowNoticeEntity flowNotice2me = new FlowNoticeEntity();
                flowNotice2me.setBusinessId(businessId);
                flowNotice2me.setPersonId(businessTrip.getApplyUserId());
                flowNotice2me.setBusinessType("business_trip");
                this.flowNoticeDao.save(flowNotice2me);
            }
            if (!CollectionUtils.isEmpty(flowNoticeEntities = this.flowNoticeDao.get(businessId, "business_trip", assignee))) {
                this.flowNoticeDao.delete(businessId, "business_trip", assignee);
            }
        }
    }

    private void processApplyMoney(String eventName, String taskKey, String assignee, TaskEntity task, String processInstanceId, String businessId) {
        Object type = task.getVariable("type");
        if (CREATE_STR.equals(eventName)) {
            if (StringUtils.hasText((String)assignee)) {
                if (null == type || LakeMobUtils.isTrue(type)) {
                    this.businessJoinerService.addBusinessJoiner("apply_money", businessId, assignee);
                    this.lakeMobPushService.pushApplyMoneyApproval(Collections.singletonList(assignee), "\u60a8\u6709\u65b0\u7684\u8d44\u91d1\u7533\u8bf7\u5f85\u5ba1\u6279");
                    FlowNoticeEntity flowNotice = new FlowNoticeEntity();
                    flowNotice.setBusinessId(businessId);
                    flowNotice.setPersonId(assignee);
                    flowNotice.setBusinessType("apply_money");
                    this.flowNoticeDao.save(flowNotice);
                }
            } else {
                List<String> candidates = this.getCandidates((DelegateTask)task);
                for (String one : candidates) {
                    this.businessJoinerService.addBusinessJoiner("apply_money", businessId, one);
                }
                this.lakeMobPushService.pushApplyMoneyApproval(candidates, "\u60a8\u6709\u65b0\u7684\u8d44\u91d1\u7533\u8bf7\u5f85\u5ba1\u6279");
            }
        } else if (COMPLETE_STR.equals(eventName)) {
            List<FlowNoticeEntity> flowNoticeEntities;
            this.flowAssociateService.completeFlowAssociate("apply_money", businessId, taskKey, assignee);
            List<FlowTraceEntity> flowTraceList = this.flowTraceService.getFlowTraceListByBusiness("apply_money", businessId);
            String passStatus = LakeMobUtils.isTrue(task.getVariable("type")) ? "1" : "0";
            this.flowTraceService.addFlowTrace("apply_money", businessId, processInstanceId, task.getId(), taskKey, assignee, (String)task.getVariable("comment"), passStatus, task.getCreateTime(), LakeMobUtils.now());
            PersonBean person = this.userManageService.getPersonById(assignee);
            ApplyMoneyEntity applyMoney = this.applyMoneyDao.get(businessId);
            if (!LakeMobUtils.isTrue(passStatus)) {
                applyMoney.setStatus(ApplyMoneyStatusEnum.REFUSE.value);
                this.applyMoneyDao.save(applyMoney);
                this.lakeMobPushService.pushApplyMoneyApproval(Collections.singletonList(applyMoney.getApplyUserId()), person.getNAME() + "\u5ba1\u6279\u4e86\u60a8\u7684\u8d44\u91d1\u7533\u8bf7");
                FlowNoticeEntity flowNotice2me = new FlowNoticeEntity();
                flowNotice2me.setBusinessId(businessId);
                flowNotice2me.setPersonId(applyMoney.getApplyUserId());
                flowNotice2me.setBusinessType("apply_money");
                this.flowNoticeDao.save(flowNotice2me);
                if (!CollectionUtils.isEmpty(flowTraceList)) {
                    ArrayList ids = Lists.newArrayList();
                    for (FlowTraceEntity flowTrace : flowTraceList) {
                        ids.add(flowTrace.getPersonId());
                        FlowNoticeEntity fn = new FlowNoticeEntity();
                        fn.setBusinessId(businessId);
                        fn.setPersonId(flowTrace.getPersonId());
                        fn.setBusinessType("apply_money");
                        this.flowNoticeDao.save(fn);
                    }
                    this.lakeMobPushService.pushApplyMoneyApproval(ids, person.getNAME() + "\u5ba1\u6279\u4e86\u8d44\u91d1\u7533\u8bf7");
                }
            }
            if (!CollectionUtils.isEmpty(flowNoticeEntities = this.flowNoticeDao.get(businessId, "apply_money", assignee))) {
                this.flowNoticeDao.delete(businessId, "apply_money", assignee);
            }
        }
    }

    private void processLeave(String eventName, String taskKey, String assignee, TaskEntity task, String processInstanceId, String businessKey) {
        if (CREATE_STR.equals(eventName)) {
            if (StringUtils.hasText((String)assignee)) {
                if (!"revokeTask".equals(taskKey)) {
                    this.businessJoinerService.addBusinessJoiner("leave", businessKey, assignee);
                }
                if (!"revokeTask".equals(taskKey)) {
                    this.lakeMobPushService.pushLeaveApproval(Collections.singletonList(assignee));
                }
            } else {
                List<String> candidates = this.getCandidates((DelegateTask)task);
                for (String one : candidates) {
                    this.businessJoinerService.addBusinessJoiner("leave", businessKey, one);
                }
                if (!"revokeTask".equals(taskKey)) {
                    this.lakeMobPushService.pushLeaveApproval(candidates);
                }
            }
        } else if (COMPLETE_STR.equals(eventName)) {
            this.flowAssociateService.completeFlowAssociate("leave", businessKey, taskKey, assignee);
            String passStatus = LakeMobUtils.isTrue(task.getVariable("pass")) ? "1" : "0";
            this.flowTraceService.addFlowTrace("leave", businessKey, processInstanceId, task.getId(), taskKey, assignee, "", passStatus, task.getCreateTime(), LakeMobUtils.now());
        }
    }

    private void processDocument(String eventName, String taskKey, String assignee, TaskEntity task, String processInstanceId, String businessKey) {
        if (CREATE_STR.equals(eventName)) {
            if (StringUtils.hasText((String)assignee)) {
                this.businessJoinerService.addBusinessJoiner("document", businessKey, assignee);
                this.lakeMobPushService.pushDocumentApproval(Collections.singletonList(assignee));
            } else {
                List<String> candidates = this.getCandidates((DelegateTask)task);
                for (String one : candidates) {
                    this.businessJoinerService.addBusinessJoiner("document", businessKey, one);
                }
                this.lakeMobPushService.pushDocumentApproval(candidates);
            }
        } else if (COMPLETE_STR.equals(eventName)) {
            List copyToList;
            this.flowAssociateService.completeFlowAssociate("document", businessKey, taskKey, assignee);
            this.flowTraceService.addFlowTrace("document", businessKey, processInstanceId, task.getId(), taskKey, assignee, LakeMobUtils.toString(task.getVariable("comment")), "1", task.getCreateTime(), LakeMobUtils.now());
            DocumentEntity doc = this.documentService.getDocumentById(businessKey);
            if (doc == null) {
                throw new LakeMobException("\u516c\u6587" + businessKey + "\u4e0d\u5b58\u5728");
            }
            HashSet forwardCopy = Sets.newHashSet();
            List forwardToList = (List)task.getVariable("forwardToList");
            if (!CollectionUtils.isEmpty((Collection)forwardToList)) {
                Set<String> joiners = this.noticeService.forwardTo(businessKey, doc.getDocumentTitle(), task.getId(), assignee, forwardToList);
                this.lakeMobPushService.pushDocumentNotice(joiners);
                forwardCopy.addAll(joiners);
            }
            if (!CollectionUtils.isEmpty((Collection)(copyToList = (List)task.getVariable("copyToList")))) {
                Set<String> joiners = this.noticeService.copyTo(businessKey, doc.getDocumentTitle(), task.getId(), assignee, copyToList);
                forwardCopy.addAll(joiners);
                this.lakeMobPushService.pushDocumentNotice(joiners);
            }
            if ("doneTask".equals(taskKey)) {
                List<String> candidates = this.getCandidates((DelegateTask)task);
                candidates.remove(assignee);
                if (!CollectionUtils.isEmpty(candidates)) {
                    this.noticeService.doneNotice(businessKey, doc.getDocumentTitle(), task.getId(), assignee, candidates);
                    this.lakeMobPushService.pushDocumentNotice(candidates);
                }
            }
            for (String str : forwardCopy) {
                this.businessJoinerService.addBusinessJoiner("document", businessKey, str);
            }
        }
    }

    private List<String> getCandidates(DelegateTask delegateTask) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (IdentityLink one : delegateTask.getCandidates()) {
            if (!one.getType().equals("candidate") || !StringUtils.hasText((String)one.getUserId())) continue;
            candidates.add(one.getUserId());
        }
        return candidates;
    }
}

