/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.util;

import com.google.common.collect.Sets;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.util.LakeMobException;

public class LakeMobUtils {
    public static final HashMap<String, String> DOCUMENT_TYPE_MAP = LakeMobUtils.initDocumentTypeMap();
    public static final HashMap<String, String> LEAVE_TYPE_MAP = LakeMobUtils.initLeaveTypeMap();
    public static final HashMap<String, String> DOCUMENT_STATUS_MAP = LakeMobUtils.initDocumentStatusMap();
    public static final HashMap<String, String> LEAVE_STATUS_MAP = LakeMobUtils.initLeaveStatusMap();

    public static Date parseDate(String txt) {
        if (!StringUtils.hasText((String)txt)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)txt, (String[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd"});
        }
        catch (ParseException e) {
            throw new LakeMobException("\u89e3\u6790\u65e5\u671f" + txt + "\u5931\u8d25");
        }
    }

    public static Date now() {
        return new Date();
    }

    public static String toString(Object comment) {
        return comment == null ? "" : comment.toString();
    }

    public static boolean isTrue(Object pass) {
        if (pass == null) {
            return false;
        }
        String s = pass.toString().trim();
        if ("1".equals(s)) {
            return true;
        }
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("y".equalsIgnoreCase(s)) {
            return true;
        }
        return "yes".equalsIgnoreCase(s);
    }

    private static HashMap<String, String> initLeaveTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("leave_type_all", "\u5168\u90e8\u8bf7\u5047");
        map.put("leave_type_affair", "\u4e8b\u5047");
        map.put("leave_type_sick", "\u75c5\u5047");
        map.put("leave_type_holiday", "\u516c\u4f11\u5047");
        map.put("leave_type_other", "\u5176\u4ed6\u5047\u671f");
        map.put("leave_type_official", "\u516c\u51fa");
        map.put("leave_type_marital", "\u5a5a\u4ea7\u5047");
        return map;
    }

    private static HashMap<String, String> initLeaveStatusMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("leave_approval_ing", "\u5ba1\u6279\u4e2d");
        map.put("leave_approval_pass", "\u5df2\u901a\u8fc7");
        map.put("leave_approval_reject", "\u672a\u901a\u8fc7");
        map.put("leave_approval_revoke", "\u5df2\u64a4\u9500");
        return map;
    }

    private static HashMap<String, String> initDocumentStatusMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("doc_status_ing", "\u5ba1\u6279\u4e2d");
        map.put("doc_status_done", "\u5df2\u5ba1\u6279");
        return map;
    }

    private static HashMap<String, String> initDocumentTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("doc_type_receive", "\u6536\u6587\uff08\u6587\u4ef6\u5904\u7406\u7b7e\uff09");
        map.put("doc_type_receive_netmsg", "\u6536\u6587\uff08\u7f51\u7edc\u8206\u60c5\u5904\u7406\u7b7e\uff09");
        map.put("doc_type_publish_party", "\u53d1\u6587\uff08\u515a\u6587\uff09");
        map.put("doc_type_publish_gov", "\u53d1\u6587\uff08\u529e\u6587\uff09");
        map.put("doc_type_publish_summary", "\u53d1\u6587\uff08\u4f1a\u8bae\u7eaa\u8981\uff09");
        return map;
    }

    public static void removeDuplication(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        LinkedHashSet tmp = Sets.newLinkedHashSet();
        tmp.addAll(list);
        list.clear();
        for (String one : tmp) {
            list.add(one);
        }
    }

    public static String getSignUrl(ElectronicSignEntity electronicSignByPerson) {
        return electronicSignByPerson == null ? "" : electronicSignByPerson.getSignUrl();
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getLeaveCellLeaderName(String cellLeaderId, UserManageService userManageService) {
        if (StringUtils.hasText((String)cellLeaderId)) {
            Person cellLeader = userManageService.queryPersonById(cellLeaderId);
            return cellLeader == null ? cellLeaderId : cellLeader.getName();
        }
        return "";
    }
}

