/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.xatl.ruyihu.util.LakeMobException;

public class QuickJson {
    private static final ObjectMapper MAPPER = QuickJson.initMapper();
    public static final Logger LOGGER = LoggerFactory.getLogger(QuickJson.class);

    public static <T> T toObj(JsonNode node, Class<T> cls) {
        try {
            return (T)MAPPER.readValue(node.traverse(), cls);
        }
        catch (Exception e) {
            String message = node.toString() + "\u8f6c\u6362\u6210" + cls.getName() + "\u5bf9\u8c61\u5f02\u5e38";
            LOGGER.error(message, (Throwable)e);
            throw new LakeMobException(message);
        }
    }

    public static <T> List<T> toList(JsonNode node, Class<T> cls) {
        try {
            return (List)MAPPER.readValue(node.traverse(), (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, cls));
        }
        catch (Exception e) {
            String message = node.toString() + "\u8f6c\u6362\u6210" + cls.getName() + "\u5217\u8868\u5f02\u5e38";
            LOGGER.error(message, (Throwable)e);
            throw new LakeMobException(message);
        }
    }

    private static ObjectMapper initMapper() {
        ObjectMapper obj = new ObjectMapper();
        obj.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        obj.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return obj;
    }

    public static ObjectNode newObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    public static ArrayNode newArrayNode() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public static String toJsonStr(JsonNode node) {
        try {
            return MAPPER.writeValueAsString((Object)node);
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210json\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
            throw new LakeMobException("\u751f\u6210json\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static String toJsonStr(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210json\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
            throw new LakeMobException("\u751f\u6210json\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

