/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.util;

import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import pams.function.xatl.datacollection.bean.ExcelFirstRowBean;

public class ExportExcelUtil {
    public static CellStyle createTitleCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment((short)2);
        titleCellStyle.setVerticalAlignment((short)1);
        titleCellStyle.setBorderBottom((short)6);
        titleCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderLeft((short)1);
        titleCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderRight((short)1);
        titleCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setBorderTop((short)1);
        titleCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        titleCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        titleCellStyle.setFillPattern((short)1);
        HSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)20);
        titleCellStyle.setFont((Font)font);
        return titleCellStyle;
    }

    public static CellStyle createHeadCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle headCellStyle = wb.createCellStyle();
        headCellStyle.setAlignment((short)2);
        headCellStyle.setVerticalAlignment((short)1);
        headCellStyle.setBorderBottom((short)2);
        headCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderLeft((short)1);
        headCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderRight((short)1);
        headCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setBorderTop((short)1);
        headCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        headCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headCellStyle.setFillPattern((short)1);
        return headCellStyle;
    }

    public static CellStyle createNormalCellStyle(HSSFWorkbook wb) {
        return ExportExcelUtil.getNewNormalCellStyle(wb);
    }

    public static CellStyle getNewNormalCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle normalCellStyle = wb.createCellStyle();
        normalCellStyle.setAlignment((short)2);
        normalCellStyle.setVerticalAlignment((short)1);
        normalCellStyle.setBorderBottom((short)1);
        normalCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderLeft((short)1);
        normalCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderRight((short)1);
        normalCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setBorderTop((short)1);
        normalCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        normalCellStyle.setWrapText(true);
        return normalCellStyle;
    }

    public CellStyle createNormalCellStyle2(HSSFWorkbook wb) {
        return ExportExcelUtil.getNewNormalCellStyle(wb);
    }

    public static void setCell(CellStyle headCellStyle, String[] aryTitle, int columnIndex, HSSFRow row) {
        for (String anAryTitle : aryTitle) {
            HSSFCell cell = row.createCell(columnIndex);
            ++columnIndex;
            cell.setCellValue(anAryTitle);
            cell.setCellStyle(headCellStyle);
        }
    }

    public static void createExcel(HSSFWorkbook wb, String sheetName, String[] aryTitle, List dataList) {
        HSSFSheet sheet = wb.createSheet(sheetName);
        CellStyle titleCellStyle = ExportExcelUtil.createTitleCellStyle(wb);
        CellStyle headCellStyle = ExportExcelUtil.createHeadCellStyle(wb);
        CellStyle normalCellStyle = ExportExcelUtil.createNormalCellStyle(wb);
        sheet.createFreezePane(0, 2);
        int rowIndex = 0;
        int columnIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex);
        ++rowIndex;
        org.apache.poi.hssf.util.CellRangeAddress cra = new org.apache.poi.hssf.util.CellRangeAddress(0, 0, 0, aryTitle.length - 1);
        sheet.addMergedRegion((CellRangeAddress)cra);
        row.setHeightInPoints(31.0f);
        HSSFCell cell = row.createCell(columnIndex);
        cell.setCellValue(sheetName);
        cell.setCellStyle(titleCellStyle);
        row = sheet.createRow(rowIndex);
        ++rowIndex;
        ExportExcelUtil.setCell(headCellStyle, aryTitle, columnIndex, row);
        assert (dataList != null);
        for (int i = 0; i < dataList.size(); ++i) {
            Object[] object = (Object[])dataList.get(i);
            row = sheet.createRow(rowIndex);
            columnIndex = 0;
            ++rowIndex;
            for (int j = 0; j < aryTitle.length; ++j) {
                cell = row.createCell(columnIndex);
                String value = object[j].toString();
                cell.setCellValue(null == object[j] ? "" : value);
                cell.setCellStyle(normalCellStyle);
                ++columnIndex;
                int valueTitle = aryTitle[j].getBytes().length;
                if (aryTitle[j] != null && (aryTitle[j].contains("\u5730\u5740") || aryTitle[j].contains("\u5730\u70b9"))) {
                    sheet.setColumnWidth(j, (valueTitle + 7) * 2 * 256);
                    continue;
                }
                sheet.setColumnWidth(j, (valueTitle + 1) * 2 * 256);
            }
        }
    }

    public static String getFileName(String fileName, String sj) {
        try {
            fileName = new String(fileName.getBytes("gbk"), "iso_8859_1") + ".xls";
        }
        catch (Exception e1) {
            fileName = sj + ".xls";
        }
        return fileName;
    }

    public static void createCombineExcel(HSSFWorkbook wb, String sheetName, List<ExcelFirstRowBean> list, String[] strs, List dataList, int startOffset, int colNum) {
        int i;
        HSSFSheet sheet = wb.createSheet(sheetName);
        CellStyle titleCellStyle = ExportExcelUtil.createTitleCellStyle(wb);
        CellStyle normalCellStyle = ExportExcelUtil.createNormalCellStyle(wb);
        int rowIndex = 0;
        int columnIndex = 0;
        HSSFRow row = sheet.createRow(rowIndex);
        ++rowIndex;
        org.apache.poi.hssf.util.CellRangeAddress cra = new org.apache.poi.hssf.util.CellRangeAddress(0, 0, 0, colNum - 1);
        sheet.addMergedRegion((CellRangeAddress)cra);
        row.setHeightInPoints(31.0f);
        HSSFCell cell = row.createCell(columnIndex);
        cell.setCellValue(sheetName);
        cell.setCellStyle(titleCellStyle);
        row = sheet.createRow(rowIndex);
        ++rowIndex;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ExcelFirstRowBean b = list.get(i2);
            org.apache.poi.hssf.util.CellRangeAddress cellRangePlanNo = new org.apache.poi.hssf.util.CellRangeAddress(b.getStartRow(), b.getEndRow(), (int)b.getStartCol(), (int)b.getEndCol());
            sheet.addMergedRegion((CellRangeAddress)cellRangePlanNo);
            ExportExcelUtil.setBorderStyle(1, cellRangePlanNo, sheet, wb);
            HSSFCell c0 = row.createCell(b.getStartCol());
            c0.setCellValue((RichTextString)new HSSFRichTextString(b.getName()));
            c0.setCellStyle(normalCellStyle);
        }
        HSSFRow row1 = sheet.createRow(rowIndex++);
        for (i = 0; i < strs.length; ++i) {
            HSSFCell c6 = row1.createCell(i + startOffset);
            c6.setCellValue((RichTextString)new HSSFRichTextString(strs[i]));
            c6.setCellStyle(normalCellStyle);
        }
        for (i = 0; i < dataList.size(); ++i) {
            Object[] object = (Object[])dataList.get(i);
            row = sheet.createRow(rowIndex);
            columnIndex = 0;
            ++rowIndex;
            for (int j = 0; j < object.length; ++j) {
                cell = row.createCell(columnIndex);
                cell.setCellValue(null == object[j] ? "" : object[j].toString());
                cell.setCellStyle(normalCellStyle);
                ++columnIndex;
                sheet.setColumnWidth(j, 5120);
            }
        }
    }

    public static void setBorderStyle(int border, org.apache.poi.hssf.util.CellRangeAddress region, HSSFSheet sheet, HSSFWorkbook wb) {
        RegionUtil.setBorderBottom((int)border, (CellRangeAddress)region, (Sheet)sheet, (Workbook)wb);
        RegionUtil.setBorderLeft((int)border, (CellRangeAddress)region, (Sheet)sheet, (Workbook)wb);
        RegionUtil.setBorderRight((int)border, (CellRangeAddress)region, (Sheet)sheet, (Workbook)wb);
        RegionUtil.setBorderTop((int)border, (CellRangeAddress)region, (Sheet)sheet, (Workbook)wb);
    }
}

